/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridiumX.knxnetIp.addresses.BGroupAddresses;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsComObjectPriorityEnum;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.KnxFlags;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="knxId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="depth", type="int", defaultValue="2", flags=1), @NiagaraProperty(name="groupName", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="isGroup", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isField", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="groupAddresses", type="BGroupAddresses", defaultValue="new BGroupAddresses()", flags=1), @NiagaraProperty(name="sendNotReceive", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="dataValueTypeId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="useComposite", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="comObjectSize", type="BKnxComObjectSizeEnum", defaultValue="BKnxComObjectSizeEnum.DEFAULT", flags=1), @NiagaraProperty(name="deviceFacets", type="BFacets", defaultValue="BFacets.NULL", flags=3), @NiagaraProperty(name="priority", type="BEtsComObjectPriorityEnum", defaultValue="BEtsComObjectPriorityEnum.DEFAULT", flags=1), @NiagaraProperty(name="pollAfterWrite", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="readFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="writeFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="communicationFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="transmitFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="updateFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="readOnInitFlag", type="boolean", defaultValue="false", flags=1)})
public final class BDiscoveredPoint
extends BVector
implements KnxFlags {
    public static final Property knxId = BDiscoveredPoint.newProperty((int)1, (String)"", null);
    public static final Property depth = BDiscoveredPoint.newProperty((int)1, (int)2, null);
    public static final Property groupName = BDiscoveredPoint.newProperty((int)1, (String)"", null);
    public static final Property isGroup = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property isField = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property groupAddresses = BDiscoveredPoint.newProperty((int)1, (BValue)new BGroupAddresses(), null);
    public static final Property sendNotReceive = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property dataValueTypeId = BDiscoveredPoint.newProperty((int)1, (String)"", null);
    public static final Property useComposite = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property comObjectSize = BDiscoveredPoint.newProperty((int)1, (BValue)BKnxComObjectSizeEnum.DEFAULT, null);
    public static final Property deviceFacets = BDiscoveredPoint.newProperty((int)3, (BValue)BFacets.NULL, null);
    public static final Property priority = BDiscoveredPoint.newProperty((int)1, (BValue)BEtsComObjectPriorityEnum.DEFAULT, null);
    public static final Property pollAfterWrite = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property readFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property writeFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property communicationFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property transmitFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property updateFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Property readOnInitFlag = BDiscoveredPoint.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BDiscoveredPoint.class);

    public String getKnxId() {
        return this.getString(knxId);
    }

    public void setKnxId(String v) {
        this.setString(knxId, v, null);
    }

    public int getDepth() {
        return this.getInt(depth);
    }

    public void setDepth(int v) {
        this.setInt(depth, v, null);
    }

    public String getGroupName() {
        return this.getString(groupName);
    }

    public void setGroupName(String v) {
        this.setString(groupName, v, null);
    }

    public boolean getIsGroup() {
        return this.getBoolean(isGroup);
    }

    public void setIsGroup(boolean v) {
        this.setBoolean(isGroup, v, null);
    }

    public boolean getIsField() {
        return this.getBoolean(isField);
    }

    public void setIsField(boolean v) {
        this.setBoolean(isField, v, null);
    }

    public BGroupAddresses getGroupAddresses() {
        return (BGroupAddresses)this.get(groupAddresses);
    }

    public void setGroupAddresses(BGroupAddresses v) {
        this.set(groupAddresses, (BValue)v, null);
    }

    public boolean getSendNotReceive() {
        return this.getBoolean(sendNotReceive);
    }

    public void setSendNotReceive(boolean v) {
        this.setBoolean(sendNotReceive, v, null);
    }

    public String getDataValueTypeId() {
        return this.getString(dataValueTypeId);
    }

    public void setDataValueTypeId(String v) {
        this.setString(dataValueTypeId, v, null);
    }

    public boolean getUseComposite() {
        return this.getBoolean(useComposite);
    }

    public void setUseComposite(boolean v) {
        this.setBoolean(useComposite, v, null);
    }

    public BKnxComObjectSizeEnum getComObjectSize() {
        return (BKnxComObjectSizeEnum)this.get(comObjectSize);
    }

    public void setComObjectSize(BKnxComObjectSizeEnum v) {
        this.set(comObjectSize, (BValue)v, null);
    }

    public BFacets getDeviceFacets() {
        return (BFacets)this.get(deviceFacets);
    }

    public void setDeviceFacets(BFacets v) {
        this.set(deviceFacets, (BValue)v, null);
    }

    public BEtsComObjectPriorityEnum getPriority() {
        return (BEtsComObjectPriorityEnum)this.get(priority);
    }

    public void setPriority(BEtsComObjectPriorityEnum v) {
        this.set(priority, (BValue)v, null);
    }

    public boolean getPollAfterWrite() {
        return this.getBoolean(pollAfterWrite);
    }

    public void setPollAfterWrite(boolean v) {
        this.setBoolean(pollAfterWrite, v, null);
    }

    @Override
    public boolean getReadFlag() {
        return this.getBoolean(readFlag);
    }

    @Override
    public void setReadFlag(boolean v) {
        this.setBoolean(readFlag, v, null);
    }

    @Override
    public boolean getWriteFlag() {
        return this.getBoolean(writeFlag);
    }

    @Override
    public void setWriteFlag(boolean v) {
        this.setBoolean(writeFlag, v, null);
    }

    @Override
    public boolean getCommunicationFlag() {
        return this.getBoolean(communicationFlag);
    }

    @Override
    public void setCommunicationFlag(boolean v) {
        this.setBoolean(communicationFlag, v, null);
    }

    @Override
    public boolean getTransmitFlag() {
        return this.getBoolean(transmitFlag);
    }

    @Override
    public void setTransmitFlag(boolean v) {
        this.setBoolean(transmitFlag, v, null);
    }

    @Override
    public boolean getUpdateFlag() {
        return this.getBoolean(updateFlag);
    }

    @Override
    public void setUpdateFlag(boolean v) {
        this.setBoolean(updateFlag, v, null);
    }

    @Override
    public boolean getReadOnInitFlag() {
        return this.getBoolean(readOnInitFlag);
    }

    @Override
    public void setReadOnInitFlag(boolean v) {
        this.setBoolean(readOnInitFlag, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BDiscoveredPoint makeGroup(String knxId, int depth, String groupRangeName) {
        BDiscoveredPoint discoveredPoint = new BDiscoveredPoint();
        discoveredPoint.setKnxId(knxId);
        discoveredPoint.setDepth(depth);
        discoveredPoint.setGroupName(groupRangeName);
        discoveredPoint.setIsGroup(true);
        return discoveredPoint;
    }

    public static BDiscoveredPoint make(String knxId, int depth, BKnxAddressStyleEnum groupAddressStyle, String groupAddressName, BGroupAddresses groupAddresses) {
        BDiscoveredPoint discoveredPoint = new BDiscoveredPoint();
        discoveredPoint.setKnxId(knxId);
        discoveredPoint.setDepth(depth);
        discoveredPoint.setGroupName(groupAddressName);
        discoveredPoint.setIsGroup(false);
        discoveredPoint.setGroupAddresses((BGroupAddresses)groupAddresses.newCopy(true));
        return discoveredPoint;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (prop.equals(dataValueTypeId)) {
            try {
                this.updateDeviceFacets();
            }
            catch (Throwable t) {
                CatchAll.throwable((Throwable)t);
            }
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps(TYPE.getTypeName() + " Spy Page");
        out.endProps();
    }

    private void updateDeviceFacets() {
        try {
            MgrTypeInfo[] mtInfos = BDiscoveredPoint.toTypes(this.getDataValueTypeDef(), false);
            if (mtInfos.length == 0) {
                System.out.println("No MgrTypeInfos found for dataValueTypeId '" + this.getDataValueTypeId() + "'");
                this.setDeviceFacets(BFacets.DEFAULT);
            } else {
                this.setDeviceFacets(this.getDataValueTypeDef().getDefinedFacets((Object)BDiscoveredPoint.toTypes(this.getDataValueTypeDef(), false)[0].newInstance()));
            }
        }
        catch (Throwable t) {
            CatchAll.throwable((Throwable)t);
        }
    }

    public BDataValueTypeDef getDataValueTypeDef() {
        return BKnxWbService.getService().getKnxDataDefs().getKnxDefs().getDataValueTypeDef(this.getDataValueTypeId());
    }

    public static MgrTypeInfo[] toTypes(BDataValueTypeDef def, boolean includeWrites) {
        if (def != null) {
            def.loadSlots();
            if (!def.isCompositeDataValueType() && !def.isAField()) {
                return BDiscoveredPoint.toTypes(def.getDataValueTypeFieldDefs()[0], includeWrites);
            }
        }
        Array mtInfos = new Array(MgrTypeInfo.class);
        if (def != null) {
            String sTypeNos = String.valueOf(def.getNPTA_ID());
            int count = sTypeNos.length();
            block10: for (int i = 0; i < count; ++i) {
                switch (sTypeNos.charAt(i)) {
                    case '1': {
                        if (includeWrites && i + 1 < count && sTypeNos.charAt(i + 1) == '2') {
                            mtInfos.add((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE));
                            ++i;
                        }
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BBooleanPoint.TYPE));
                        continue block10;
                    }
                    case '2': {
                        if (!includeWrites) continue block10;
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE));
                        continue block10;
                    }
                    case '3': {
                        if (includeWrites && i + 1 < count && sTypeNos.charAt(i + 1) == '4') {
                            mtInfos.add((Object)MgrTypeInfo.make((Type)BEnumWritable.TYPE));
                            ++i;
                        }
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BEnumPoint.TYPE));
                        continue block10;
                    }
                    case '4': {
                        if (!includeWrites) continue block10;
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BEnumWritable.TYPE));
                        continue block10;
                    }
                    case '5': {
                        if (includeWrites && i + 1 < count && sTypeNos.charAt(i + 1) == '6') {
                            mtInfos.add((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE));
                            ++i;
                        }
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BNumericPoint.TYPE));
                        continue block10;
                    }
                    case '6': {
                        if (!includeWrites) continue block10;
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE));
                        continue block10;
                    }
                    case '7': {
                        if (includeWrites && i + 1 < count && sTypeNos.charAt(i + 1) == '8') {
                            mtInfos.add((Object)MgrTypeInfo.make((Type)BStringWritable.TYPE));
                            ++i;
                        }
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BStringPoint.TYPE));
                        continue block10;
                    }
                    case '8': {
                        if (!includeWrites) continue block10;
                        mtInfos.add((Object)MgrTypeInfo.make((Type)BStringWritable.TYPE));
                    }
                }
            }
        }
        return (MgrTypeInfo[])mtInfos.trim();
    }
}

