/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets.job;

import com.tridiumX.knxnetIp.ets.BEtsImportableComponent;
import com.tridiumX.knxnetIp.ets.BEtsImportableSubFileComponent;
import com.tridiumX.knxnetIp.ets.BEtsProjectFile;
import com.tridiumX.knxnetIp.ets.BEtsSubFileEntry;
import com.tridiumX.knxnetIp.ets.EtsImportException;
import com.tridiumX.knxnetIp.ets.EtsUtil;
import com.tridiumX.knxnetIp.ets.enums.BEtsAttributeTypeEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsNameSpaceEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsProjectFileImportStateEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsProjectFileVerificationResultEnum;
import com.tridiumX.knxnetIp.ets.job.EtsProjectInterpreter;
import com.tridiumX.knxnetIp.ets.job.PreVersion20Interpreter;
import com.tridiumX.knxnetIp.ets.job.Version20Interpreter;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsManufacturerData;
import com.tridiumX.knxnetIp.ets.master.BEtsMasterData;
import com.tridiumX.knxnetIp.ets.master.importSpecs.BEtsMasterDataImportSpec;
import com.tridiumX.knxnetIp.ets.project.BEtsProject;
import com.tridiumX.knxnetIp.job.IDevicesJob;
import com.tridiumX.knxnetIp.knxDataDefs.IXmlImportableComponent;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.wb.BKnxWbServiceOptions;
import com.tridiumX.knxnetIp.xml.IXmlImporterHelper;
import com.tridiumX.knxnetIp.xml.ImportProblemReports;
import com.tridiumX.knxnetIp.xml.XmlImporter;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import com.tridiumX.knxnetIp.zip.EncryptedZipInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="etsProjectFileOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="useCachedData", type="boolean", defaultValue="false"), @NiagaraProperty(name="discoveredDevices", type="BVector", defaultValue="new BVector()", flags=1), @NiagaraProperty(name="discoveredPoints", type="BVector", defaultValue="new BVector()", flags=1)})
@NiagaraTopic(name="deviceLearned")
public final class BEtsProjectFileImportJob
extends BSimpleJob
implements IXmlImporterHelper,
IDevicesJob {
    public static final Property etsProjectFileOrd = BEtsProjectFileImportJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property useCachedData = BEtsProjectFileImportJob.newProperty((int)0, (boolean)false, null);
    public static final Property discoveredDevices = BEtsProjectFileImportJob.newProperty((int)1, (BValue)new BVector(), null);
    public static final Property discoveredPoints = BEtsProjectFileImportJob.newProperty((int)1, (BValue)new BVector(), null);
    public static final Topic deviceLearned = BEtsProjectFileImportJob.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BEtsProjectFileImportJob.class);
    private BImportedEtsProjectFile importedEtsProjectFile;
    private boolean discoverDevices;
    private boolean importNewerProjectVersions;
    private boolean includeUnassociatedGroupAdresses;
    private ImportProblemReports importProblemReports;
    private float progressOffset;
    private float progressScale;
    private boolean m_bFoundKnxMaster;
    private KnxFile m_knxFile_Master;
    private boolean m_bPasswordNeeded;
    private char[] m_sPassword;
    private Vector<KnxFileFolderPair> fileFolderPairs = new Vector(10, 10);
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".etsImportJob");
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final float ETS_PROJECT_IMPORT_PORTION = 0.7f;
    private static final float ETS_PROJECT_INTERPRET_PORTION = 0.15f;

    public BOrd getEtsProjectFileOrd() {
        return (BOrd)this.get(etsProjectFileOrd);
    }

    public void setEtsProjectFileOrd(BOrd v) {
        this.set(etsProjectFileOrd, (BValue)v, null);
    }

    public boolean getUseCachedData() {
        return this.getBoolean(useCachedData);
    }

    public void setUseCachedData(boolean v) {
        this.setBoolean(useCachedData, v, null);
    }

    public BVector getDiscoveredDevices() {
        return (BVector)this.get(discoveredDevices);
    }

    public void setDiscoveredDevices(BVector v) {
        this.set(discoveredDevices, (BValue)v, null);
    }

    public BVector getDiscoveredPoints() {
        return (BVector)this.get(discoveredPoints);
    }

    public void setDiscoveredPoints(BVector v) {
        this.set(discoveredPoints, (BValue)v, null);
    }

    public void fireDeviceLearned(BValue event) {
        this.fire(deviceLearned, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BEtsProjectFileImportJob make(BImportedEtsProjectFile etsProjectFile, boolean discoverDevices, BKnxWbServiceOptions importOptions) {
        return BEtsProjectFileImportJob.factory(etsProjectFile, discoverDevices, importOptions);
    }

    private static BEtsProjectFileImportJob factory(BImportedEtsProjectFile etsProjectFile, boolean discoverDevices, BKnxWbServiceOptions importOptions) {
        BEtsProjectFileImportJob job = new BEtsProjectFileImportJob();
        job.importedEtsProjectFile = etsProjectFile;
        job.discoverDevices = discoverDevices;
        job.importNewerProjectVersions = importOptions.getAttemptImportOfNewerProjectVersions();
        job.includeUnassociatedGroupAdresses = importOptions.getIncludeUnassociatedGroupAdresses();
        return job;
    }

    public void run(Context cx) throws Exception {
        try {
            this.progressOffset = 0.0f;
            if (!this.getUseCachedData()) {
                this.importEtsProjectFile();
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    if (this.importedEtsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importStarted)) {
                        this.importedEtsProjectFile.setImportState(BEtsProjectFileImportStateEnum.importCanceled);
                    }
                    this.canceled();
                }
                if (this.getJobState().isRunning() && this.importedEtsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importStarted)) {
                    this.importedEtsProjectFile.setImportState(BEtsProjectFileImportStateEnum.importComplete);
                }
                this.importedEtsProjectFile.doSaveToCache();
            } else {
                Thread.sleep(100L);
            }
            if (this.getJobState().isRunning() && this.importedEtsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importComplete)) {
                this.progressScale = (100.0f - this.progressOffset) / 100.0f;
                if (this.discoverDevices) {
                    this.importedEtsProjectFile.interpretImportedDevicesAsDiscoveryDevices(this);
                } else {
                    this.importedEtsProjectFile.interpretImportedPointsAsDiscoveryPoints(this);
                }
                ImportProblemReports importProblemReports = this.getImportProblemReports();
                if (importProblemReports != null && !importProblemReports.isEmpty()) {
                    this.failed(new Exception("Cannot validate source file" + importProblemReports.getImportProblemReportString()));
                }
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    this.canceled();
                }
            }
        }
        catch (Exception ex) {
            this.log().failed(ex.toString());
            ex.printStackTrace();
            throw new Exception(ex);
        }
    }

    public void success() {
        if (!this.getJobState().isComplete()) {
            super.success();
        }
    }

    public BVector getLearnedDevices() {
        return this.getDiscoveredDevices();
    }

    public boolean validateEtsProjectFile() throws EtsImportException {
        boolean contentValidated;
        BObject oSrcFile;
        BOrd etsProjectFileOrd = this.validateEtsProjectFileOrd();
        try {
            oSrcFile = etsProjectFileOrd.get();
        }
        catch (Exception ex) {
            this.getImportProblemReports().add("Import source file \"" + etsProjectFileOrd + "\" not found.");
            this.importedEtsProjectFile.setLastVerificationResult(BEtsProjectFileVerificationResultEnum.FileNotFound);
            return false;
        }
        BIFileStore srcFileStore = ((BIFile)oSrcFile).getStore();
        BZipFile zipEtsProjectFile = null;
        try {
            zipEtsProjectFile = this.getZipFile(srcFileStore);
            contentValidated = this.validateEtsProjectFileContent(zipEtsProjectFile);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.getClass().getSimpleName();
            }
            this.getImportProblemReports().add(message);
            throw this.logErrorAndGenerateException(message, ex);
        }
        finally {
            if (zipEtsProjectFile != null && zipEtsProjectFile.isOpen()) {
                zipEtsProjectFile.close();
            }
            zipEtsProjectFile = null;
        }
        return contentValidated;
    }

    private BOrd validateEtsProjectFileOrd() throws EtsImportException {
        if (this.importedEtsProjectFile == null || this.importedEtsProjectFile.getEtsProjectFileOrd() == null || this.importedEtsProjectFile.getEtsProjectFileOrd() == BOrd.NULL || this.importedEtsProjectFile.getEtsProjectFileOrd().toString().trim().equals("")) {
            throw this.logErrorAndGenerateException("No ETS project file specified to import.");
        }
        BOrd etsProjectFileOrd = this.importedEtsProjectFile.getEtsProjectFileOrd();
        if (!etsProjectFileOrd.isValue()) {
            throw this.logErrorAndGenerateException("The BOrd (of an ETS project file) is not a value.");
        }
        String etsProjectFileName = etsProjectFileOrd.asValue().toString();
        if (!EtsUtil.validEtsProjectFilename(etsProjectFileName)) {
            String error = EtsUtil.invalidEtsProjectFileName(etsProjectFileName);
            throw this.logErrorAndGenerateException(error);
        }
        this.logMessage("The etsProjectFileOrd filename DOES end with '.knxproj'.");
        return etsProjectFileOrd;
    }

    private boolean validateEtsProjectFileContent(BZipFile zipEtsProjectFile) throws Exception {
        boolean bRet = false;
        if (zipEtsProjectFile != null) {
            this.logMessage("The ETS project file supplied IS an 'instance of' BZipFile.");
            this.logMessage("zipEtsProjectFile.getFileName() = '" + zipEtsProjectFile.getFileName() + "'.");
            zipEtsProjectFile.open();
            BZipSpace zipSpace = zipEtsProjectFile.getZipSpace();
            bRet = this.validateEtsProjectFileRootFolder(zipSpace);
        } else {
            this.logMessage("The ETS project file supplied is NOT an 'instance of' BZipFile.");
        }
        return bRet;
    }

    private boolean validateEtsProjectFileRootFolder(BZipSpace zipSpace) throws Exception {
        this.m_bFoundKnxMaster = false;
        this.m_bPasswordNeeded = false;
        this.fileFolderPairs = new Vector(10, 10);
        boolean bFoundKnxMaster = false;
        ArrayList<KnxFileFolderPair> ffps = new ArrayList<KnxFileFolderPair>(10);
        BIFile[] files = zipSpace.listFiles();
        this.logMessage("Files in zip file : " + files.length);
        for (int i = 0; i < files.length; ++i) {
            BIFile f = files[i];
            this.logMessage("File " + (i + 1) + " name : " + f.getFileName());
            if (BEtsProjectFileImportJob.checkSkip(f)) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Skipping file" + f.getFileName());
                continue;
            }
            if (f.getFileName().equals("knx_master.xml")) {
                if (bFoundKnxMaster) continue;
                bFoundKnxMaster = true;
                this.m_bFoundKnxMaster = true;
                KnxFile knxFile = new KnxFile();
                knxFile.fileName = f.getFileName();
                knxFile.size = f.getSize();
                this.m_knxFile_Master = knxFile;
                continue;
            }
            if (f.isDirectory()) {
                KnxFileFolderPair kffp = null;
                for (KnxFileFolderPair loopKffp : ffps) {
                    if (!loopKffp.baseName.equals(f.getFileName())) continue;
                    loopKffp.foundFolder = true;
                    kffp = loopKffp;
                    break;
                }
                if (kffp == null) {
                    kffp = new KnxFileFolderPair();
                    kffp.baseName = f.getFileName();
                    kffp.foundFolder = true;
                    if (!ffps.contains(kffp)) {
                        ffps.add(kffp);
                    } else {
                        log.warning("Illegal State - file/folder pair: " + kffp.baseName);
                    }
                }
                BIFile[] subFiles = zipSpace.getChildren(f);
                ArrayList<KnxFile> vFiles = new ArrayList<KnxFile>(10);
                for (BIFile subFile : subFiles) {
                    if (subFile.isDirectory()) continue;
                    KnxFile knxFile = new KnxFile();
                    knxFile.fileName = subFile.getFileName();
                    knxFile.size = subFile.getSize();
                    vFiles.add(knxFile);
                }
                vFiles.trimToSize();
                kffp.files = vFiles.toArray(new KnxFile[0]);
                continue;
            }
            boolean bFoundIt = false;
            String fileName = f.getFileName();
            String baseName = FileUtil.getBase((String)fileName);
            for (KnxFileFolderPair fileFolderPair : ffps) {
                if (!fileFolderPair.baseName.equals(baseName)) continue;
                if (f.getExtension().equals("zip")) {
                    this.parseZipFile(f, fileFolderPair);
                }
                if (f.getExtension().equals("signature")) {
                    fileFolderPair.foundSignatureFile = true;
                }
                bFoundIt = true;
                break;
            }
            if (bFoundIt) continue;
            KnxFileFolderPair newKFFP = new KnxFileFolderPair();
            newKFFP.baseName = baseName;
            if (f.getExtension().equals("zip")) {
                this.parseZipFile(f, newKFFP);
            }
            if (f.getExtension().equals("signature")) {
                newKFFP.foundSignatureFile = true;
            }
            if (!ffps.contains(newKFFP)) {
                ffps.add(newKFFP);
                continue;
            }
            log.warning("Illegal State - file/folder pair: " + newKFFP.baseName);
        }
        ffps.trimToSize();
        if (bFoundKnxMaster && !ffps.isEmpty()) {
            boolean foundProblem = false;
            for (KnxFileFolderPair fileFolderPair : ffps) {
                if (fileFolderPair.baseName != null && !fileFolderPair.baseName.equals("")) {
                    if (fileFolderPair.baseName.length() == 6 && fileFolderPair.foundSignatureFile) {
                        if (fileFolderPair.baseName.startsWith("M-") && fileFolderPair.foundFolder) {
                            fileFolderPair.isManufacturer = true;
                            this.fileFolderPairs.add(fileFolderPair);
                        }
                        if (fileFolderPair.baseName.startsWith("P-") && (fileFolderPair.foundFolder || fileFolderPair.foundZipFile)) {
                            fileFolderPair.isProject = true;
                            this.fileFolderPairs.add(fileFolderPair);
                            if (fileFolderPair.foundZipFile) {
                                this.m_bPasswordNeeded = true;
                            }
                        }
                        if (fileFolderPair.isManufacturer || fileFolderPair.isProject) continue;
                        foundProblem = true;
                        continue;
                    }
                    foundProblem = true;
                    continue;
                }
                foundProblem = true;
            }
            this.fileFolderPairs.trimToSize();
            if (foundProblem) {
                return false;
            }
            return !this.m_bPasswordNeeded || this.m_sPassword != null;
        }
        return false;
    }

    private static boolean checkSkip(BIFile file) {
        return file.getFileName().equalsIgnoreCase(".validation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseZipFile(BIFile zipFile, KnxFileFolderPair fileFolderPair) throws IOException {
        fileFolderPair.foundZipFile = true;
        if (this.m_sPassword != null) {
            File tempFile = null;
            try {
                tempFile = BEtsProjectFileImportJob.extractFile(zipFile);
                try (FileInputStream fis = new FileInputStream(tempFile);
                     EncryptedZipInputStream zdis = new EncryptedZipInputStream(fis, this.m_sPassword);
                     ZipInputStream zis = new ZipInputStream(zdis);){
                    ZipEntry zipEntry;
                    ArrayList<KnxFile> vFiles = new ArrayList<KnxFile>(10);
                    while (zis.available() != 0 && (zipEntry = zis.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        KnxFile knxFile = new KnxFile();
                        knxFile.fileName = zipEntry.getName();
                        knxFile.size = zipEntry.getSize();
                        vFiles.add(knxFile);
                    }
                    vFiles.trimToSize();
                    fileFolderPair.files = vFiles.toArray(new KnxFile[0]);
                }
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void importEtsProjectFile() throws Exception {
        try {
            this.importedEtsProjectFile.doClearImportCache();
            etsProjectFileOrd = this.validateEtsProjectFileOrd();
            try {
                if (this.importedEtsProjectFile.getLastVerificationResult() != BEtsProjectFileVerificationResultEnum.FileOk || !this.importedEtsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importComplete)) {
                    if (BEtsProjectFileImportJob.log.isLoggable(Level.FINE)) {
                        BEtsProjectFileImportJob.log.fine(BEtsProjectFileImportJob.TYPE.getTypeName() + "::importEtsProjectFile - NOT Using Cached Import");
                        BEtsProjectFileImportJob.log.fine("\timportedEtsProjectFile.getLastVerificationResult().getTag() = " + this.importedEtsProjectFile.getLastVerificationResult().getTag());
                    }
                    this.importedEtsProjectFile.setImportState(BEtsProjectFileImportStateEnum.importStarted);
                    srcFileStore = ((BIFile)etsProjectFileOrd.get()).getStore();
                    zipEtsProjectFile = null;
                    try {
                        zipEtsProjectFile = this.getZipFile(srcFileStore);
                        bContentProcessed = this.processEtsProjectFileContent(zipEtsProjectFile);
                        if (!bContentProcessed || !this.importedEtsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importStarted)) ** GOTO lbl34
                        this.importedEtsProjectFile.setLastImportedFileModificationTime(zipEtsProjectFile.getLastModified());
                        this.importedEtsProjectFile.verifyEtsProjectFile();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        s = "ERROR: - An Exception occurred in function 'importEtsProjectFile()' in 'BEtsProjectFileImportJob.java'.\n\r" + ex.getMessage();
                        this.getImportProblemReports().add(s);
                        throw new Exception(s, ex);
                    }
                    finally {
                        if (zipEtsProjectFile != null && zipEtsProjectFile.isOpen()) {
                            zipEtsProjectFile.close();
                        }
                        zipEtsProjectFile = null;
                    }
                } else {
                    if (BEtsProjectFileImportJob.log.isLoggable(Level.FINE)) {
                        BEtsProjectFileImportJob.log.fine(BEtsProjectFileImportJob.TYPE.getTypeName() + "::importEtsProjectFile - Using Cached Import");
                        BEtsProjectFileImportJob.log.fine("\timportedEtsProjectFile.getLastVerificationResult().getTag() = " + this.importedEtsProjectFile.getLastVerificationResult().getTag());
                    }
                    bContentProcessed = true;
                }
lbl34:
                // 3 sources

                if (bContentProcessed) {
                    this.progressScale = 0.15f;
                    interpreter = this.getProjectInterpreter(this.importedEtsProjectFile);
                    interpreter.interpretEtsElementsAsImportedDevicesAndPoints(this);
                    this.progressOffset += this.progressScale * 100.0f;
                }
                if (this.getJobState().isRunning() && this.importProblemReports != null && !this.importProblemReports.isEmpty()) {
                    this.logError(this.importProblemReports.getImportProblemReportString());
                    this.failed(null);
                }
            }
            catch (Exception ex) {
                this.failed(ex);
                this.importedEtsProjectFile.setImportState(BEtsProjectFileImportStateEnum.importFailed);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(ex);
        }
    }

    private EtsProjectInterpreter getProjectInterpreter(BImportedEtsProjectFile importedEtsProjectFile) {
        int namespaceVer = importedEtsProjectFile.getEtsNamespace().getOrdinal();
        if (namespaceVer < 6) {
            return new PreVersion20Interpreter(importedEtsProjectFile.getEtsProjectFile(), this);
        }
        if (namespaceVer == 6) {
            return new Version20Interpreter(importedEtsProjectFile.getEtsProjectFile(), this);
        }
        return new EtsProjectInterpreter(importedEtsProjectFile.getEtsProjectFile(), this);
    }

    private boolean processEtsProjectFileContent(BZipFile zipEtsProjectFile) throws Exception {
        boolean bRet = false;
        if (zipEtsProjectFile != null) {
            KnxFile knxFile;
            int j;
            this.logMessage("The ETS project file supplied IS an 'instance of' BZipFile.");
            zipEtsProjectFile.open();
            BZipSpace zipSpace = zipEtsProjectFile.getZipSpace();
            long totalSize = this.m_knxFile_Master.size;
            for (KnxFileFolderPair fileFolderPair : this.fileFolderPairs) {
                for (j = 0; j < fileFolderPair.files.length; ++j) {
                    knxFile = fileFolderPair.files[j];
                    totalSize += knxFile.size;
                }
            }
            this.m_knxFile_Master.scale = 0.7f * (float)this.m_knxFile_Master.size / (float)totalSize;
            for (KnxFileFolderPair fileFolderPair : this.fileFolderPairs) {
                for (j = 0; j < fileFolderPair.files.length; ++j) {
                    knxFile = fileFolderPair.files[j];
                    knxFile.scale = 0.7f * (float)knxFile.size / (float)totalSize;
                }
            }
            if (!this.getJobState().isRunning()) {
                return false;
            }
            if (this.m_bFoundKnxMaster) {
                try {
                    if (!this.processEtsProjectFileMaster(zipSpace)) {
                        return false;
                    }
                }
                catch (Throwable t) {
                    throw new Exception("There was a problem loading/parsing the 'knx_master.xml' file.", t);
                }
            }
            if (!this.getJobState().isRunning()) {
                return false;
            }
            boolean bSubFoldersImported = false;
            boolean bSubFoldersImportedOK = true;
            if (this.m_bFoundKnxMaster && !this.fileFolderPairs.isEmpty()) {
                for (KnxFileFolderPair fileFolderPair : this.fileFolderPairs) {
                    if (fileFolderPair.isProject) {
                        try {
                            bSubFoldersImportedOK &= this.processEtsProjectFileSubFolder(zipSpace, fileFolderPair);
                        }
                        catch (Throwable t) {
                            bSubFoldersImportedOK = false;
                            throw new Exception("There was a problem parsing the '" + fileFolderPair.baseName + "' folder." + "\n\r" + t.getMessage(), t);
                        }
                    }
                    if (this.getJobState().isRunning()) continue;
                    return false;
                }
                for (KnxFileFolderPair fileFolderPair : this.fileFolderPairs) {
                    if (fileFolderPair.isManufacturer) {
                        try {
                            bSubFoldersImportedOK &= this.processEtsProjectFileSubFolder(zipSpace, fileFolderPair);
                        }
                        catch (Throwable t) {
                            bSubFoldersImportedOK = false;
                            throw new Exception("There was a problem parsing the '" + fileFolderPair.baseName + "' folder." + "\n\r" + t.getMessage(), t);
                        }
                    }
                    if (this.getJobState().isRunning()) continue;
                    return false;
                }
                bSubFoldersImported = true;
            }
            bSubFoldersImportedOK &= bSubFoldersImported;
            if (!this.getJobState().isRunning()) {
                return false;
            }
            bRet = bSubFoldersImportedOK;
        } else {
            this.logMessage("The ETS project file supplied is NOT an 'instance of' BZipFile.");
        }
        return bRet;
    }

    private boolean processEtsProjectFileMaster(BZipSpace zipSpace) throws Throwable {
        FilePath fp = new FilePath("knx_master.xml");
        BIFile biFile = zipSpace.findFile(fp);
        BEtsMasterData kmd = new BEtsMasterData();
        BEtsProjectFile etsProjectFile = this.importedEtsProjectFile.getEtsProjectFile();
        this.progressOffset = 0.0f;
        this.progressScale = this.m_knxFile_Master.scale;
        XmlImporter xmlImporter = new XmlImporter();
        boolean loaded = xmlImporter.loadFromInputStream(this, biFile.getInputStream(), biFile.getSize(), (IXmlImportableComponent)kmd, new BEtsMasterDataImportSpec());
        this.progressOffset += this.progressScale * 100.0f;
        if (loaded) {
            String xmlNameSpace = kmd.getXmlNameSpace();
            this.logMessage(lex.getText("importJob.masterNamespace", new Object[]{xmlNameSpace}));
            int iOrdinal = this.getNameSpaceOrdinal(xmlNameSpace);
            etsProjectFile.setTargetNamespace(BEtsNameSpaceEnum.make(iOrdinal));
            ((BImportedEtsProjectFile)etsProjectFile.getParent()).setEtsNamespace(BEtsNameSpaceEnum.make(iOrdinal));
            if (iOrdinal == 0) {
                this.getImportProblemReports().add(lex.getText("importJob.badXmlNamespace", new Object[]{xmlNameSpace}));
                loaded = false;
            }
            if (loaded) {
                XmlImporter.addChild((BComponent)etsProjectFile, (IXmlImportableComponent)kmd, new BEtsMasterDataImportSpec());
            }
        }
        return loaded;
    }

    private int getNameSpaceOrdinal(String xmlNameSpace) {
        int ordinal = BEtsNameSpaceEnum.DEFAULT.getOrdinal(xmlNameSpace);
        if (ordinal == 0 && this.importNewerProjectVersions && BEtsNameSpaceEnum.isNewerThanSupported(xmlNameSpace)) {
            ordinal = BEtsNameSpaceEnum.getHighestSupportedOrdinal();
            this.logMessage(lex.getText("importJob.attemptWithBadNamespace", new Object[]{xmlNameSpace}));
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFile(BIFile inputFile) throws IOException {
        File tempFile = null;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            int bytesRead;
            tempFile = File.createTempFile("ets", null);
            if (log.isLoggable(Level.FINEST)) {
                log.fine("tempFile = '" + tempFile.getAbsolutePath());
            }
            inStream = inputFile.getInputStream();
            FilePath tempFilePath = BFileSystem.INSTANCE.localFileToPath(tempFile);
            BIFile tempBIFile = BFileSystem.INSTANCE.findFile(tempFilePath);
            outStream = tempBIFile.getOutputStream();
            byte[] b = new byte[1024];
            long lngSize = inputFile.getSize();
            for (long i = 0L; i < lngSize; i += (long)bytesRead) {
                bytesRead = inStream.read(b);
                outStream.write(b, 0, bytesRead);
            }
            inStream.close();
            inStream = null;
            outStream.close();
            outStream = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
            if (outStream != null) {
                outStream.close();
                outStream = null;
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEtsProjectFileSubFolder(BZipSpace zipSpace, KnxFileFolderPair kffp) throws Throwable {
        FilePath folderPath;
        boolean r = false;
        if (kffp.isManufacturer) {
            folderPath = new FilePath(kffp.baseName);
            r = this.processEtsProjectFileSubFolder(zipSpace, folderPath, kffp, new BEtsManufacturerData());
        }
        if (kffp.isProject) {
            if (kffp.foundZipFile) {
                FilePath filePath = new FilePath(kffp.baseName + ".zip");
                BIFile bifFile = zipSpace.findFile(filePath);
                File tempFile = null;
                FileInputStream fis = null;
                EncryptedZipInputStream zdis = null;
                ZipInputStream zis = null;
                try {
                    tempFile = BEtsProjectFileImportJob.extractFile(bifFile);
                    fis = new FileInputStream(tempFile);
                    zdis = new EncryptedZipInputStream(fis, this.m_sPassword);
                    zis = new ZipInputStream(zdis);
                    r = this.processEtsProjectFileSubFolder(zis, kffp, new BEtsProject());
                    zis.close();
                    zis = null;
                    zdis.close();
                    zdis = null;
                    fis.close();
                    fis = null;
                }
                finally {
                    if (zis != null) {
                        zis.close();
                        zis = null;
                    }
                    if (zdis != null) {
                        zdis.close();
                        zdis = null;
                    }
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            } else {
                folderPath = new FilePath(kffp.baseName);
                r = this.processEtsProjectFileSubFolder(zipSpace, folderPath, kffp, new BEtsProject());
            }
        }
        return r;
    }

    private boolean processEtsProjectFileSubFolder(ZipInputStream zipInputStream, KnxFileFolderPair kffp, BEtsImportableSubFileComponent folderClass) throws Throwable {
        BEtsProjectFile etsProjectFile;
        BEtsImportableSubFileComponent kp;
        String projectFileName;
        boolean loadedOk = false;
        String sName = kffp.baseName;
        this.logMessage("Procesing folder - " + sName);
        if (log.isLoggable(Level.FINE)) {
            log.fine("sName = '" + sName + "'");
        }
        if ((projectFileName = (kp = folderClass).getFileNameInZip((etsProjectFile = this.importedEtsProjectFile.getEtsProjectFile()).getTargetNamespace())).equals("")) {
            throw new Throwable("No 'File name In Zip' provided by '" + folderClass.getTypeDisplayName(null) + "'.");
        }
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().equals(projectFileName)) {
                this.logMessage("Processing file - " + projectFileName);
                for (int i = 0; i < kffp.files.length; ++i) {
                    KnxFile knxFile = kffp.files[i];
                    if (!knxFile.fileName.equals(projectFileName)) continue;
                    this.progressScale = knxFile.scale;
                    break;
                }
                XmlImporter xmlImporter = new XmlImporter();
                loadedOk = xmlImporter.loadFromInputStream(this, zipInputStream, zipEntry.getSize(), (IXmlImportableComponent)kp);
                this.progressOffset += this.progressScale * 100.0f;
                if (loadedOk) {
                    XmlImporter.addChild((BComponent)etsProjectFile, (IXmlImportableComponent)kp, kp);
                }
            } else {
                BEtsSubFileEntry[] aSubFiles = kp.getSubFiles(etsProjectFile);
                if (aSubFiles != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("aSubFiles != null");
                        log.fine("aSubFiles.length = " + aSubFiles.length);
                    }
                    for (int i = 0; i < aSubFiles.length; ++i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("i = " + i);
                        }
                        BEtsSubFileEntry subFileEntry = aSubFiles[i];
                        String subFileName = subFileEntry.fileNameInZip;
                        if (subFileName.equals("")) {
                            throw new Throwable("No 'File name In Zip' provided by '" + folderClass.getTypeDisplayName(null) + "'.");
                        }
                        if (!zipEntry.getName().equals(subFileName)) continue;
                        this.logMessage("Processing file - " + subFileName);
                        BEtsImportableComponent component = (BEtsImportableComponent)kp.get(SlotPath.escape((String)subFileEntry.childId));
                        if (component == null) {
                            BTypeSpec oTS = BTypeSpec.make((Type)subFileEntry.etsType);
                            BObject oTSInstance = oTS.getInstance();
                            component = (BEtsImportableComponent)oTSInstance;
                        }
                        for (int j = 0; j < kffp.files.length; ++j) {
                            KnxFile knxFile = kffp.files[j];
                            if (!knxFile.fileName.equals(subFileName)) continue;
                            this.progressScale = knxFile.scale;
                            break;
                        }
                        XmlImporter xmlImporter = new XmlImporter();
                        boolean loadedEntry = xmlImporter.loadFromInputStream(this, zipInputStream, zipEntry.getSize(), (IXmlImportableComponent)component);
                        this.progressOffset += this.progressScale * 100.0f;
                        if (loadedEntry) {
                            XmlImporter.addChild((BComponent)kp, (IXmlImportableComponent)component, component);
                        }
                        loadedOk &= loadedEntry;
                        break;
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("aSubFiles == null");
                }
            }
            zipEntry = null;
        }
        return loadedOk;
    }

    private boolean processEtsProjectFileSubFolder(BZipSpace zipSpace, FilePath folderPath, KnxFileFolderPair kffp, BEtsImportableSubFileComponent folderClass) throws Throwable {
        boolean r = false;
        this.logMessage("Processing folder - " + folderPath);
        BIFile bifFolder = zipSpace.findFile(folderPath);
        if (bifFolder.isDirectory()) {
            BEtsProjectFile etsProjectFile;
            BEtsImportableSubFileComponent kp;
            String s;
            String sName = kffp.baseName;
            if (log.isLoggable(Level.FINE)) {
                log.fine("sName = '" + sName + "'");
            }
            if ((s = (kp = folderClass).getFileNameInZip((etsProjectFile = this.importedEtsProjectFile.getEtsProjectFile()).getTargetNamespace())).equals("")) {
                throw new Throwable("No 'File name In Zip' provided by '" + folderClass.getTypeDisplayName(null) + "'.");
            }
            FilePath filePath = folderPath.merge(s);
            BIFile bifFile = null;
            try {
                bifFile = zipSpace.findFile(filePath);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Throwable("The required file '" + filePath.getName() + "' was not found in folder '" + bifFolder.getFileName() + "'.");
            }
            if (bifFile == null) {
                throw new Throwable("The required file '" + filePath.getName() + "' was not found in folder '" + bifFolder.getFileName() + "'.");
            }
            this.logMessage("Processing file - " + bifFile.getFileName());
            for (int i = 0; i < kffp.files.length; ++i) {
                KnxFile knxFile = kffp.files[i];
                if (!knxFile.fileName.equals(s)) continue;
                this.progressScale = knxFile.scale;
                break;
            }
            XmlImporter xmlImporter = new XmlImporter();
            boolean b = xmlImporter.loadFromInputStream(this, bifFile.getInputStream(), bifFile.getSize(), (IXmlImportableComponent)kp);
            this.progressOffset += this.progressScale * 100.0f;
            if (b) {
                XmlImporter.addChild((BComponent)etsProjectFile, (IXmlImportableComponent)kp, kp);
            }
            int iSubFileIndex = 0;
            BEtsSubFileEntry[] aSubFiles = kp.getSubFiles(etsProjectFile);
            if (aSubFiles != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("aSubFiles != null");
                    log.fine("aSubFiles.length = " + aSubFiles.length);
                }
                int i = iSubFileIndex;
                while (i < aSubFiles.length) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("i = " + i);
                        log.fine("iSubFileIndex = " + iSubFileIndex);
                    }
                    BEtsSubFileEntry subFileEntry = aSubFiles[i];
                    this.logMessage("Processing file - " + subFileEntry.fileNameInZip);
                    FilePath fpSubFile = folderPath.merge(subFileEntry.fileNameInZip);
                    BIFile bifSubFile = zipSpace.findFile(fpSubFile);
                    BEtsImportableComponent component = (BEtsImportableComponent)kp.get(SlotPath.escape((String)subFileEntry.childId));
                    if (component == null) {
                        BTypeSpec oTS = BTypeSpec.make((Type)subFileEntry.etsType);
                        BObject oTSInstance = oTS.getInstance();
                        component = (BEtsImportableComponent)oTSInstance;
                    }
                    for (int j = 0; j < kffp.files.length; ++j) {
                        KnxFile knxFile = kffp.files[j];
                        if (!knxFile.fileName.equals(subFileEntry.fileNameInZip)) continue;
                        this.progressScale = knxFile.scale;
                        break;
                    }
                    boolean b2 = xmlImporter.loadFromInputStream(this, bifSubFile.getInputStream(), bifSubFile.getSize(), (IXmlImportableComponent)component);
                    this.progressOffset += this.progressScale * 100.0f;
                    if (b2) {
                        XmlImporter.addChild((BComponent)kp, (IXmlImportableComponent)component, component);
                    }
                    b &= b2;
                    ++i;
                    ++iSubFileIndex;
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("aSubFiles == null");
            }
            r = b;
        } else {
            this.logMessage("processEtsProjectFileSubFolder(...) found that 'kffp.baseName' ( = '" + kffp.baseName + "') does not refer to a directory in the zipSpace.");
        }
        return r;
    }

    private void updateJobPercent(int iPercent) {
        if (this.isAlive()) {
            this.progress(iPercent);
        }
    }

    private BZipFile getZipFile(BIFileStore srcFileStore) {
        String projectFilenameCharset = this.importedEtsProjectFile.getProjectFilenameCharset();
        if (!projectFilenameCharset.isEmpty()) {
            try {
                return new BZipFile(srcFileStore, Charset.forName(projectFilenameCharset));
            }
            catch (UnsupportedCharsetException e) {
                throw new IllegalArgumentException("Unsupported charset: [" + projectFilenameCharset + "], using default: " + Charset.defaultCharset());
            }
        }
        return new BZipFile(srcFileStore);
    }

    @Override
    public boolean isCancelled() {
        return !this.isAlive();
    }

    @Override
    public ImportProblemReports getImportProblemReports() {
        if (this.importProblemReports == null) {
            this.importProblemReports = new ImportProblemReports();
        }
        return this.importProblemReports;
    }

    @Override
    public void updateProgress(int progressValue) {
        if (this.progressScale != 0.0f) {
            int percent = (int)(this.progressOffset + (float)progressValue * this.progressScale);
            this.updateJobPercent(percent);
        }
    }

    @Override
    public String preProcessEnumImport(XmlPropertyImportSpec propertySpec, String sNewVal) {
        if (propertySpec.getAttributeType().equals((Object)BEtsAttributeTypeEnum.knx_ComObjectSize_t)) {
            if (sNewVal.contains(" ")) {
                return "_" + sNewVal.replace(' ', '_');
            }
            if (sNewVal.equals("LegacyVarData")) {
                return "legacyVarData";
            }
        }
        return sNewVal;
    }

    public BImportedEtsProjectFile getImportedEtsProjectFile() {
        return this.importedEtsProjectFile;
    }

    public boolean isPasswordNeeded() {
        return this.m_bPasswordNeeded;
    }

    public void setPassword(char[] password) {
        this.m_sPassword = password;
    }

    public boolean includeUnassociatedGroupAdresses() {
        return this.includeUnassociatedGroupAdresses;
    }

    public void logMessage(String msg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(msg);
        }
        this.log().message(msg);
    }

    private void logError(String msg) {
        log.log(Level.SEVERE, msg);
        this.log().failed(msg);
    }

    private EtsImportException logErrorAndGenerateException(String msg) {
        return this.logErrorAndGenerateException(msg, null);
    }

    private EtsImportException logErrorAndGenerateException(String msg, Exception e) {
        this.logError(msg);
        return new EtsImportException(msg, e);
    }

    private static class KnxFile {
        String fileName;
        long size;
        float scale = 1.0f;

        private KnxFile() {
        }
    }

    private static class KnxFileFolderPair {
        String baseName;
        boolean isProject;
        boolean isManufacturer;
        boolean foundFolder;
        boolean foundZipFile;
        boolean foundSignatureFile;
        KnxFile[] files;

        private KnxFileFolderPair() {
        }
    }
}

