/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.point;

import com.tridium.edgeIo.BEdgeIoDevice;
import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.platEdgeIo.BEdgeIoPlatformService;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class IoDefaultUtil {
    public static void exportIoDefaults(BEdgeIoNetwork net) {
        try {
            BEdgeIoPlatformService platSvc = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
            JSONArray jarray = IoDefaultUtil.readIoDefaults(platSvc);
            boolean changed = false;
            BEdgeIoDevice dev = net.getLocal();
            for (int i = 0; i < jarray.length(); ++i) {
                JSONObject jobj = jarray.getJSONObject(i);
                int pntId = Integer.parseInt(JSONUtil.getString((JSONObject)jobj, (String)"PointId"), 16);
                BEdgeIoProxyExt pext = dev.getPointExt(pntId);
                if (pext == null) {
                    if (!IoDefaultUtil.setDefault(jobj)) continue;
                    changed = true;
                    continue;
                }
                if (!pext.updateDefault(jobj)) continue;
                changed = true;
            }
            if (!changed) {
                return;
            }
            IoDefaultUtil.writeIoDefaults(platSvc, jarray);
        }
        catch (Throwable e) {
            net.log().log(Level.SEVERE, "Failed to export default io configuration", e);
        }
    }

    private static boolean setDefault(JSONObject jsonObj) {
        Comparable<Boolean> defVal;
        Object currVal = jsonObj.get("DefaultValue");
        if (currVal.equals(Boolean.FALSE)) {
            return false;
        }
        if (currVal.equals(Boolean.TRUE)) {
            defVal = Boolean.FALSE;
        } else {
            double currDef = ((Number)currVal).doubleValue();
            if (currDef == 0.0) {
                return false;
            }
            defVal = 0;
        }
        jsonObj.put("DefaultValue", (Object)defVal);
        return true;
    }

    private static JSONArray readIoDefaults(BEdgeIoPlatformService service) throws Exception {
        byte[] fileBuf = service.ioDefaultsFileRead();
        String jsonStr = new String(fileBuf, Charset.forName("UTF-8"));
        JSONTokener jsonTokener = new JSONTokener(jsonStr);
        JSONArray jsonArray = new JSONArray(jsonTokener);
        return jsonArray;
    }

    private static void writeIoDefaults(BEdgeIoPlatformService service, JSONArray jsonArray) throws Exception {
        byte[] fileBuf = jsonArray.toString().getBytes(Charset.forName("UTF-8"));
        service.ioDefaultsFileWrite(fileBuf);
    }
}

