/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.discover;

import com.tridium.edgeIo.discover.JPoints;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class JDescriptionFileReader {
    public static JPoints[] parse(InputStream is) throws IOException {
        JSONTokener tok = new JSONTokener((Reader)new InputStreamReader(is, Charset.forName("UTF-8")));
        JSONObject fileObj = new JSONObject(tok);
        ArrayList<JPoints> pnts = new ArrayList<JPoints>();
        if (!fileObj.has("points")) {
            return new JPoints[0];
        }
        JSONArray kits = fileObj.getJSONArray("points");
        for (int i = 0; i < kits.length(); ++i) {
            JSONObject kit = kits.getJSONObject(i);
            JPoints jps = new JPoints();
            jps.type = JSONUtil.getString((JSONObject)kit, (String)"type");
            String points = JSONUtil.getString((JSONObject)kit, (String)"idx");
            jps.idx = JDescriptionFileReader.getPointArray(points, 10);
            points = JSONUtil.getString((JSONObject)kit, (String)"ids");
            jps.ids = JDescriptionFileReader.getPointArray(points, 16);
            points = JSONUtil.getString((JSONObject)kit, (String)"modes");
            jps.modes = JDescriptionFileReader.getModeEnumArray(points);
            pnts.add(jps);
        }
        return pnts.toArray(new JPoints[pnts.size()]);
    }

    private static int[] getPointArray(String points, int radix) {
        int ndx = points.indexOf(45);
        if (ndx > 0) {
            int min = Integer.parseInt(points.substring(0, ndx), radix);
            int max = Integer.parseInt(points.substring(ndx + 1), radix);
            int[] a = new int[max - min + 1];
            for (int i = 0; i < a.length; ++i) {
                a[i] = min + i;
            }
            return a;
        }
        if (points.indexOf(44) > 0) {
            return JDescriptionFileReader.getIntArray(points, radix);
        }
        int[] a = new int[]{Integer.parseInt(points, radix)};
        return a;
    }

    public static int[] getIntArray(String s, int radix) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int tokCnt = st.countTokens();
        int[] b = new int[tokCnt];
        for (int i = 0; i < tokCnt; ++i) {
            b[i] = Integer.parseInt(st.nextToken().trim(), radix);
        }
        return b;
    }

    public static String getModeEnumArray(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, ",");
        int tokCnt = st.countTokens();
        StringBuilder modeStr = new StringBuilder();
        modeStr.append(st.nextToken().trim());
        for (int i = 1; i < tokCnt; ++i) {
            modeStr.append(",");
            modeStr.append(st.nextToken().trim());
        }
        return modeStr.toString();
    }
}

