/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import com.tridium.videoDriver.videoStream.fox.FoxVideoConnection;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoSession;
import com.tridium.videoDriver.videoStream.fox.VideoSessionsWatchdog;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

public class StationSideVideoCoordinator {
    protected HashMap<Integer, StationSideVideoSession> videoSessions;
    protected VideoSessionsWatchdog videoSessionsWatchdog;
    protected FoxVideoConnection connectionToClient;
    protected Logger log = Logger.getLogger("fox.videoCoordinator");

    protected StationSideVideoCoordinator() {
        this.videoSessionsWatchdog = new VideoSessionsWatchdog();
        this.videoSessions = new HashMap();
    }

    public void openStreamAsync(BPlaybackParams playbackParams, String videoClient, int videoStreamId) {
        BFoxVideoSource foxVideoSource;
        BObject videoSourceObject;
        String videoSourceOrdString;
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Opening a video stream for client.");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Video connection object = " + this.connectionToClient);
        }
        if (!(videoSourceOrdString = playbackParams.getVideoSourceOrd().toString()).startsWith("station:|")) {
            videoSourceOrdString = "station:|" + videoSourceOrdString;
        }
        BOrd videoSourceAbsOrd = BOrd.make((String)videoSourceOrdString);
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Video source ord:" + videoSourceAbsOrd);
        }
        if ((videoSourceObject = videoSourceAbsOrd.get()) instanceof BFoxVideoSource) {
            foxVideoSource = (BFoxVideoSource)videoSourceObject;
        } else if (videoSourceObject.isComponent()) {
            BFoxVideoSource[] foxVideoSources = (BFoxVideoSource[])videoSourceObject.asComponent().getChildren(BFoxVideoSource.class);
            if (foxVideoSources == null || foxVideoSources.length == 0) {
                foxVideoSource = new BFoxVideoSource();
                videoSourceObject.asComponent().add("FoxVideoSource", (BValue)foxVideoSource);
            } else {
                foxVideoSource = foxVideoSources[0];
            }
        } else {
            throw new BajaRuntimeException("Video source neither a BComponent nor a BFoxVideoSource. Unable to stream video over fox.");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Video source name:" + foxVideoSource.getName());
        }
        StationSideVideoSession newVideoSession = new StationSideVideoSession(this, foxVideoSource, playbackParams, videoClient, videoStreamId);
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Created StationSideVideoSession.");
        }
        this.videoSessions.put(videoStreamId, newVideoSession);
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Asking particular video driver for stream.");
        }
        foxVideoSource.getVideoSourceParent().streamToDestination(newVideoSession.getPlaybackParams(), newVideoSession);
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "Finished asking for stream. Stream will arrive or timeout shortly.");
        }
    }

    protected BPlaybackParams getPlaybackParamsForStream(String videoClient, int videoStreamId) {
        StationSideVideoSession vidSes;
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "getPlaybackParamsForStream.");
        }
        if ((vidSes = this.videoSessions.get(videoStreamId)) == null) {
            return null;
        }
        return vidSes.getPlaybackParams();
    }

    protected void pauseVideoStream(String videoClient, int videoStreamId) throws IOException {
        StationSideVideoSession videoSessionToPause;
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "pauseVideoStream.");
        }
        if ((videoSessionToPause = this.videoSessions.get(videoStreamId)) != null) {
            videoSessionToPause.pause();
        }
    }

    protected void resumeVideoStream(String videoClient, int videoStreamId) throws IOException {
        StationSideVideoSession videoSessionToResume;
        if (this.log.isLoggable(Level.FINE)) {
            this.trace(videoClient, videoStreamId, "resumeVideoStream.");
        }
        if ((videoSessionToResume = this.videoSessions.get(videoStreamId)) != null) {
            videoSessionToResume.resume();
        }
    }

    protected void closeVideoStream(String videoClient, int videoStreamId) throws IOException {
        StationSideVideoSession videoSessionToClose = this.videoSessions.remove(videoStreamId);
        if (videoSessionToClose != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.trace(videoClient, videoStreamId, "closeVideoStream. Calling videoSession.close()");
            }
            videoSessionToClose.close();
        }
    }

    public void stopCoordinating() {
        this.videoSessionsWatchdog.stopWatchdog();
        if (this.connectionToClient == null) {
            this.closedCircuitToClient("Client");
        } else {
            this.closedCircuitToClient(this.connectionToClient.getVideoClientId());
        }
    }

    protected void videoSessionTimeOut(StationSideVideoSession videoSession) throws Exception {
        this.connectionToClient.sendTimeout(videoSession);
        this.closeVideoStream(videoSession.getVideoClientId(), videoSession.getVideoStreamId());
    }

    protected boolean handshakeClient(FoxCircuit foxCircuit, StringBuffer videoClientId) throws Exception {
        String videoClient;
        FoxMessage helloBack;
        block4: {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Sending 'hello' to client: " + videoClientId);
            }
            FoxMessage helloMsg = new FoxMessage();
            helloMsg.add("msgType", "hello");
            foxCircuit.writeMessage(helloMsg);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Hoping to receive 'hello' back from client: " + videoClientId);
            }
            helloBack = foxCircuit.readMessage();
            videoClient = helloBack.getString("client", "Client");
            try {
                int intVideoClientId = helloBack.getInt("clientId");
                videoClient = videoClient + ':' + intVideoClientId;
            }
            catch (IOException ioe) {
                if (!this.log.isLoggable(Level.FINE)) break block4;
                this.log.fine("NOTE: This video client does not have a unique integer in this server. Assuming unique name: " + videoClient);
            }
        }
        videoClientId.append(videoClient);
        return "hello".equals(helloBack.getString("msgType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void holdCircuitOpen(FoxVideoConnection clientConnection, String videoClientId) {
        try {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Holding the circuit connection open = " + videoClientId);
            }
            while (clientConnection.circuit.isOpen()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!this.log.isLoggable(Level.FINE)) continue;
                    this.log.fine("Interupted while servicing client " + videoClientId);
                }
            }
        }
        finally {
            clientConnection.connectionClosed();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Done holding the circuit connection open = " + videoClientId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coordinateVideoForClient(FoxCircuit foxCircuit) throws Exception {
        String videoClientId = "Unknown";
        try {
            StringBuffer videoClientIdBuffer = new StringBuffer();
            if (this.handshakeClient(foxCircuit, videoClientIdBuffer)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Hankshake successful. client: " + videoClientIdBuffer);
                }
                videoClientId = videoClientIdBuffer.toString();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Starting video watchdog. client: " + videoClientIdBuffer);
                }
                this.videoSessionsWatchdog.startWatchdog(videoClientId);
                this.connectionToClient = new FoxVideoConnection(this, foxCircuit, videoClientId);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Video connection open to client: " + videoClientId);
                }
                this.holdCircuitOpen(this.connectionToClient, videoClientId);
                this.closedCircuitToClient(videoClientId);
            } else {
                String sessionId = "";
                if (foxCircuit.session() != null) {
                    sessionId = foxCircuit.session().getId();
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Hankshake unsuccessful. Session id: " + sessionId);
                }
            }
        }
        finally {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Circuit to Workbench client must close. Client: " + videoClientId + "[" + Clock.ticks() + "]");
            }
        }
    }

    public void closedCircuitToClient(String videoClientId) {
        for (StationSideVideoSession videoSession : this.videoSessions.values()) {
            try {
                if (this.log.isLoggable(Level.FINE)) {
                    this.trace(videoClientId, videoSession.getVideoStreamId(), "Close video session ");
                }
                videoSession.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, this.dtag(videoClientId, videoSession.getVideoStreamId()) + "Unable to close video session after circuit was closed.", e);
            }
        }
        this.videoSessions.clear();
    }

    private void trace(String videoClient, int videoStreamId, String traceStr) {
        this.log.fine(this.dtag(videoClient, videoStreamId) + " " + traceStr);
    }

    private String dtag(String videoClient, int videoStreamId) {
        return videoClient + "{vsId:" + videoStreamId + "}";
    }

    public VideoSessionsWatchdog getVideoSessionsWatchdog() {
        return this.videoSessionsWatchdog;
    }
}

