/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import com.tridium.videoDriver.videoStream.fox.ClientVideoInputStream;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BInteger;

public class ClientSideVideoReceiver
extends Thread {
    protected static Logger log = Logger.getLogger("fox.clientVideoReceivers");
    protected boolean running;
    protected boolean done;
    protected BFoxVideoChannel foxVideoChannel;
    protected String videoClientId;
    protected FoxCircuit foxCircuit;
    protected IntHashMap videoPlayerStreams;
    public static final long _256KB = 262144L;

    protected ClientSideVideoReceiver(BFoxVideoChannel foxVideoChannel, String videoClient, BInteger videoClientId) throws Exception {
        super("ClientSideVideoReceiver:" + videoClient);
        FoxMessage helloMsg;
        String msgType;
        this.foxVideoChannel = foxVideoChannel;
        this.videoClientId = videoClientId != null ? videoClient + ':' + videoClientId : videoClient;
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver: Opening video circuit with station.");
        }
        this.foxCircuit = foxVideoChannel.openCircuit("FoxVideoCircuit");
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver: Reading hello from station station.");
        }
        if ((msgType = (helloMsg = this.foxCircuit.readMessage()).getString("msgType").intern()) == "hello") {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClientSideVideoReceiver: Sending hello to station station.");
            }
            if (videoClientId != null) {
                helloMsg.add("clientId", videoClientId.getInt());
            }
            helloMsg.add("client", videoClient);
            this.foxCircuit.writeMessage(helloMsg);
            this.videoPlayerStreams = new IntHashMap();
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClientSideVideoReceiver: Successfully finished initializing ClientSideVideoReceiver");
            }
        } else {
            log.severe("Did not receive hello from station: " + helloMsg);
            throw new IOException("Unsuccessful handshake to station: " + helloMsg);
        }
    }

    protected ClientSideVideoReceiver() throws Exception {
    }

    public String getVideoClientId() {
        return this.videoClientId;
    }

    public ClientVideoInputStream getInputStream(int videoStreamId, IVideoDestination videoDestination, FoxVideoStream foxVideoStream) {
        ClientVideoInputStream cin = (ClientVideoInputStream)this.videoPlayerStreams.get(videoStreamId);
        if (cin == null) {
            cin = new ClientVideoInputStream(this, videoStreamId, videoDestination, foxVideoStream);
            this.videoPlayerStreams.put(videoStreamId, (Object)cin);
        } else {
            cin.reopen();
        }
        return cin;
    }

    public boolean isDone() {
        return this.done;
    }

    public void startVideoReceiver() {
        this.running = true;
        super.start();
    }

    public void stopVideoReceiver() {
        this.running = false;
        this.interrupt();
    }

    protected FoxMessage readVideoFrameMessage() {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClientSideVideoReceiver.readVideoFrameMessage : reading message");
            }
            return this.foxCircuit.readMessage();
        }
        catch (Exception e1) {
            log.log(Level.SEVERE, "ClientSideVideoReceiver.readVideoFrameMessage : caught Exception: " + e1);
            this.running = false;
            return null;
        }
    }

    final int getVideoStreamId(FoxMessage videoFrameFromStation) {
        return videoFrameFromStation.getInt("videoStreamId", -1);
    }

    final byte[] getVideoFrameBytes(FoxMessage videoFrameFromStation) {
        return videoFrameFromStation.getBlob("videoFrameChunk", null);
    }

    protected void dispatchTimeout(FoxMessage videoFrameFromStation) {
        int videoStreamId;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Timeout!");
        }
        if ((videoStreamId = this.getVideoStreamId(videoFrameFromStation)) < 0) {
            return;
        }
        ClientVideoInputStream clientVideoInputStream = this.getInputStream(videoStreamId, null, null);
        if (clientVideoInputStream == null) {
            return;
        }
        try {
            clientVideoInputStream.close();
        }
        catch (IOException ioe) {
            log.severe("Unable to close ClientVideoInputStream: " + ioe.getLocalizedMessage());
        }
    }

    protected void dispatchVideoFrameChunk(FoxMessage videoFrameFromStation) {
        byte[] videoFrameBytes;
        int videoStreamId;
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver.dispatchVideoFrameChunk");
        }
        if ((videoStreamId = this.getVideoStreamId(videoFrameFromStation)) < 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver.dispatchVideoFrameChunk videoStreamId = " + videoStreamId);
        }
        if (videoStreamId < 0) {
            return;
        }
        ClientVideoInputStream clientVideoInputStream = (ClientVideoInputStream)this.videoPlayerStreams.get(videoStreamId);
        if (clientVideoInputStream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Received a video frame chunk for a closed or non-existant video stream id videoStreamId " + videoStreamId + " Video client id = " + this.videoClientId);
            }
            try {
                this.foxVideoChannel.closeVideoStream(this.videoClientId, videoStreamId);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to close fox video stream. Video stream id = " + videoStreamId + " Video client id = " + this.videoClientId, e);
            }
            return;
        }
        BPlaybackParams pbp = null;
        if (!clientVideoInputStream.hasReceivedAnyBytes) {
            String playbackParamsXml = videoFrameFromStation.getString("playbackParams", null);
            try {
                if (playbackParamsXml != null) {
                    pbp = (BPlaybackParams)ValueDocDecoder.unmarshal((String)playbackParamsXml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((videoFrameBytes = this.getVideoFrameBytes(videoFrameFromStation)) == null) {
            return;
        }
        try {
            if (!clientVideoInputStream.isPaused() && clientVideoInputStream.isBackingUp()) {
                this.getFoxVideoChannel().pauseVideoStream(this.videoClientId, videoStreamId);
                clientVideoInputStream.streamPaused();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception while trying to pause video stream. Video stream id = " + videoStreamId, e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver.dispatchVideoFrameChunk chunk size = " + videoFrameBytes.length);
        }
        try {
            clientVideoInputStream.receiveFromStation(videoFrameBytes, pbp);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception while processing fox video stream bytes.", e);
        }
    }

    protected void dispatch(FoxMessage videoFrameFromStation) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver.dispatch");
        }
        String msgType = "";
        try {
            msgType = videoFrameFromStation.getString("msgType").intern();
        }
        catch (IOException ioe) {
            log.severe("ClientSideVideoReceiver: no 'msgType' in the FoxMessage that was received.");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClientSideVideoReceiver.dispatch msgType =" + msgType);
        }
        if (msgType == "videoStreamTimeout") {
            this.dispatchTimeout(videoFrameFromStation);
        } else if (msgType == "videoFrameData") {
            this.dispatchVideoFrameChunk(videoFrameFromStation);
        } else {
            log.severe("ClientSideVideoReceiver.dispatch unrecognized msgType: " + msgType);
        }
    }

    public void clientVideoInputStreamClosed(ClientVideoInputStream clientIn) throws Exception {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Client side video input stream closed. Video stream id = " + clientIn.getVideoStreamId() + " Video client id = " + this.getVideoClientId());
            }
            this.videoPlayerStreams.remove(clientIn.getVideoStreamId());
            this.foxVideoChannel.closeVideoStream(this.getVideoClientId(), clientIn.getVideoStreamId());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error closing video input stream", e);
            throw e;
        }
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("ClientSideVideoReceiver.run call readVideoFrameMessage");
                }
                FoxMessage videoFrameFromStation = this.readVideoFrameMessage();
                if (!this.running) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("ClientSideVideoReceiver.run call dispatch");
                }
                this.dispatch(videoFrameFromStation);
            }
        }
        finally {
            this.done = true;
        }
    }

    public BFoxVideoChannel getFoxVideoChannel() {
        return this.foxVideoChannel;
    }
}

