/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm.monitoring;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.videoDriver.alarm.monitoring.BAlarmConsoleTypeEnum;
import com.tridium.videoDriver.alarm.monitoring.BAlarmDialogScaleFactorEnum;
import com.tridium.videoDriver.alarm.monitoring.BAlarmNotification;
import com.tridium.videoDriver.alarm.monitoring.BAlarmTypeEnum;
import com.tridium.videoDriver.alarm.monitoring.BMonitor;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BConsoleRecipientMonitor
extends BMonitor {
    public static final Property sourceToMonitor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BOrd.make((String)"service:alarm:AlarmService"), null);
    public static final Property alarmTypeToMonitor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmTypeEnum.allAlarms, null);
    public static final Property alarmState = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmTransitionBits.DEFAULT, null);
    public static final Property ackState = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAckState.unacked, null);
    public static final Property alarmConsoleType = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmConsoleTypeEnum.alarmConsole, null);
    public static final Property dialogScaleFactor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmDialogScaleFactorEnum.seventy, null);
    public static final Type TYPE = Sys.loadType(BConsoleRecipientMonitor.class);
    private static final Type CONSOLE_RECIPIENT_TYPE = BTypeSpec.make((String)"alarm:ConsoleRecipient").getResolvedType();

    @Override
    public BOrd getSourceToMonitor() {
        return (BOrd)this.get(sourceToMonitor);
    }

    @Override
    public void setSourceToMonitor(BOrd v) {
        this.set(sourceToMonitor, (BValue)v, null);
    }

    public BAlarmTypeEnum getAlarmTypeToMonitor() {
        return (BAlarmTypeEnum)this.get(alarmTypeToMonitor);
    }

    public void setAlarmTypeToMonitor(BAlarmTypeEnum v) {
        this.set(alarmTypeToMonitor, (BValue)v, null);
    }

    public BAlarmTransitionBits getAlarmState() {
        return (BAlarmTransitionBits)this.get(alarmState);
    }

    public void setAlarmState(BAlarmTransitionBits v) {
        this.set(alarmState, (BValue)v, null);
    }

    public BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    public void setAckState(BAckState v) {
        this.set(ackState, (BValue)v, null);
    }

    public BAlarmConsoleTypeEnum getAlarmConsoleType() {
        return (BAlarmConsoleTypeEnum)this.get(alarmConsoleType);
    }

    public void setAlarmConsoleType(BAlarmConsoleTypeEnum v) {
        this.set(alarmConsoleType, (BValue)v, null);
    }

    public BAlarmDialogScaleFactorEnum getDialogScaleFactor() {
        return (BAlarmDialogScaleFactorEnum)this.get(dialogScaleFactor);
    }

    public void setDialogScaleFactor(BAlarmDialogScaleFactorEnum v) {
        this.set(dialogScaleFactor, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(sourceToMonitor)) {
            if (this.getSourceToMonitor().isNull()) {
                return;
            }
            BLink[] monitorLinks = this.getLinks((Slot)signalNotification);
            for (int i = 0; i < monitorLinks.length; ++i) {
                this.remove((BComplex)monitorLinks[i]);
            }
            BComponent monitorSource = this.getMonitorSource().asComponent();
            if (monitorSource.getType().is(BConsoleRecipient.TYPE)) {
                BConsoleRecipient recipient = (BConsoleRecipient)monitorSource;
                BLink link = this.makeLink((BComponent)recipient, (Slot)BConsoleRecipient.routeAlarm, (Slot)signalNotification, context);
                link.setSourceOrd(recipient.getHandleOrd());
                this.add("monitorSourceLink?", (BValue)link);
                link.activate();
            }
        }
    }

    public static boolean videoDriverAvailable() {
        try {
            Sys.loadModule((String)"videoDriver");
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public BAlarmRecord getLastAlarmRecord() {
        BValue record = this.getLastValueSignaled();
        return record instanceof BAlarmRecord ? (BAlarmRecord)record : null;
    }

    @Override
    public Type getMonitorSourceType() {
        return CONSOLE_RECIPIENT_TYPE;
    }

    @Override
    public Type getNotificationType() {
        return BAlarmNotification.TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return "Alarm Popup Settings";
    }
}

