/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.IOException;
import javax.baja.gx.BGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BRectGeom
extends BGeom
implements IRectGeom {
    public static final BRectGeom DEFAULT = new BRectGeom(0.0, 0.0, 0.0, 0.0);
    public static final BRectGeom NULL = new BRectGeom(0.0, 0.0, 0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BRectGeom.class);
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public static BRectGeom make(double x, double y, double width, double height) {
        return new BRectGeom(x, y, width, height);
    }

    public static BRectGeom make(IRectGeom r) {
        if (r instanceof BRectGeom) {
            return (BRectGeom)r;
        }
        return BRectGeom.make(r.x(), r.y(), r.width(), r.height());
    }

    public static BRectGeom make(String s) {
        Parser parser = new Parser(s);
        BRectGeom x = parser.parseRect();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BRectGeom(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getGeomCase() {
        return 2;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double width() {
        return this.width;
    }

    @Override
    public double height() {
        return this.height;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.x);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y);
        hash = hash * 37L + Double.doubleToRawLongBits(this.width);
        hash = hash * 37L + Double.doubleToRawLongBits(this.height);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BRectGeom) {
            BRectGeom r = (BRectGeom)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return false;
    }

    public String encodeToString() {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y)).append(',').append(BDouble.encode((double)this.width)).append(',').append(BDouble.encode((double)this.height));
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BRectGeom.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

