/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.IOException;
import javax.baja.gx.BGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLineGeom
extends BGeom
implements ILineGeom {
    public static final BLineGeom DEFAULT = new BLineGeom(0.0, 0.0, 0.0, 0.0);
    public static final BLineGeom NULL = new BLineGeom(0.0, 0.0, 0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BLineGeom.class);
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;

    public static BLineGeom make(double x1, double y1, double x2, double y2) {
        return new BLineGeom(x1, y1, x2, y2);
    }

    public static BLineGeom make(ILineGeom g) {
        if (g instanceof BLineGeom) {
            return (BLineGeom)g;
        }
        return BLineGeom.make(g.x1(), g.y1(), g.x2(), g.y2());
    }

    public static BLineGeom make(String s) {
        Parser parser = new Parser(s);
        BLineGeom x = parser.parseLine();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BLineGeom(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public int getGeomCase() {
        return 1;
    }

    @Override
    public double x1() {
        return this.x1;
    }

    @Override
    public double y1() {
        return this.y1;
    }

    @Override
    public double x2() {
        return this.x2;
    }

    @Override
    public double y2() {
        return this.y2;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.x1);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y1);
        hash = hash * 37L + Double.doubleToRawLongBits(this.x2);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y2);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLineGeom) {
            BLineGeom o = (BLineGeom)obj;
            return this.x1 == o.x1 && this.y1 == o.y1 && this.x2 == o.x2 && this.y2 == o.y2;
        }
        return false;
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BDouble.encode((double)this.x1)).append(',').append(BDouble.encode((double)this.y1)).append(' ').append(BDouble.encode((double)this.x2)).append(',').append(BDouble.encode((double)this.y2));
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BLineGeom.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

