/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import java.util.ArrayList;
import javax.baja.gx.RectGeom;

public class RectangleMap {
    private RectGeom bounds;
    private int bucketWidth;
    private int bucketHeight;
    private int xb;
    private int yb;
    private ArrayList<Group>[][] buckets;

    public RectangleMap(int boundsX, int boundsY, int boundsW, int boundsH, int bucketWidth, int bucketHeight) {
        this.bounds = new RectGeom(boundsX, boundsY, boundsW, boundsH);
        this.bucketWidth = bucketWidth;
        this.bucketHeight = bucketHeight;
        this.xb = (int)this.bounds.width / bucketWidth + 1;
        this.yb = (int)this.bounds.height / bucketHeight + 1;
        this.buckets = new ArrayList[this.xb][this.yb];
    }

    public void put(int rectX, int rectY, int rectW, int rectH, Object object) {
        RectGeom rect = new RectGeom(rectX, rectY, rectW, rectH);
        int a = (int)rect.x / this.bucketWidth;
        while ((double)a <= (rect.x + rect.width) / (double)this.bucketWidth) {
            int b = (int)rect.y / this.bucketHeight;
            while ((double)b <= (rect.y + rect.height) / (double)this.bucketHeight) {
                if (a >= 0 && a < this.xb && b >= 0 && b < this.yb) {
                    ArrayList<Group> bucket = this.buckets[a][b];
                    if (bucket == null) {
                        this.buckets[a][b] = bucket = new ArrayList();
                    }
                    bucket.add(new Group(rect, object));
                }
                ++b;
            }
            ++a;
        }
    }

    public Object[] get(int x, int y) {
        if (!this.bounds.contains(x, y)) {
            return null;
        }
        ArrayList<Group> bucket = this.buckets[x / this.bucketWidth][y / this.bucketHeight];
        if (bucket == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < bucket.size(); ++i) {
            Group g = bucket.get(i);
            if (!g.rect.contains(x, y)) continue;
            list.add(g.obj);
        }
        return list.size() == 0 ? null : list.toArray(new Object[list.size()]);
    }

    private static class Group {
        private RectGeom rect;
        private Object obj;

        private Group(RectGeom rect, Object obj) {
            this.rect = rect;
            this.obj = obj;
        }
    }
}

