/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.micro.MicroImageData;
import com.tridium.gx.micro.MicroImageInfo;
import com.tridium.sys.Nre;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public class MicroImageManager {
    static final long TRIM_AGE = 900000L;
    private static Logger log = Logger.getLogger("gx.image");
    private static HashMap<String, MicroImageData> cache = new HashMap();
    private static final Thread thread;
    private static boolean loggedUnresolvedWarning;

    public static synchronized MicroImageData fetchDimensions(BImage image) {
        BOrdList ordList = image.getAbsoluteOrdList();
        String key = ordList.encodeToString();
        MicroImageData data = cache.get(key);
        if (data != null) {
            if (data.hasFileBeenModified()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("out of date: " + key);
                }
                cache.remove(key);
            } else {
                data.lastUsedTicks = Clock.ticks();
                return data;
            }
        }
        data = new MicroImageData(image);
        data.ordList = ordList;
        data.cacheKey = key;
        data.lastUsedTicks = Clock.ticks();
        cache.put(key, data);
        if (log.isLoggable(Level.FINE)) {
            log.fine("load dimensions: " + key);
        }
        MicroImageManager.load(data);
        return data;
    }

    public static void trimAll() {
        log.warning("Entire cache cleared");
        cache = new HashMap();
        loggedUnresolvedWarning = false;
    }

    private static void load(MicroImageData data) {
        BOrdList list = data.ordList;
        if (list.size() == 0) {
            return;
        }
        MicroImageManager.loadFile(data, list.get(0));
        if (list.size() == 1) {
            return;
        }
    }

    private static void loadFile(MicroImageData data, BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        try {
            BIFile file = (BIFile)ord.resolve((BObject)BLocalHost.INSTANCE).get();
            MicroImageInfo info = new MicroImageInfo(file);
            data.dimensions = info.getDimensions();
            data.file = file;
            data.fileTime = file.getLastModified();
        }
        catch (UnresolvedException e) {
            if (!loggedUnresolvedWarning && !log.isLoggable(Level.FINE)) {
                log.warning("Cannot resolve image dimensions for \"" + ord + "\", set this log's level to FINE for more details");
                loggedUnresolvedWarning = true;
            } else if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Cannot resolve image dimensions for \"" + ord + "\"", e);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot resolve image dimensions for \"" + ord + "\"");
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot load image dimensions\"" + ord + "\"", e);
        }
    }

    static synchronized void trim() {
        log.fine("trim");
        long now = Clock.ticks();
        MicroImageData[] datas = cache.values().toArray(new MicroImageData[cache.size()]);
        for (int i = 0; i < datas.length; ++i) {
            MicroImageData data = datas[i];
            if (!data.trim(now)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("  trim: " + data.cacheKey);
            }
            cache.remove(data.cacheKey);
        }
    }

    static {
        loggedUnresolvedWarning = false;
        thread = new MicroImageManagerThread();
        thread.start();
        Spy.ROOT.add("microImageManager", (Spy)new MicroImageManagerSpy());
    }

    static class MicroImageManagerSpy
    extends SpyByKey {
        MicroImageManagerSpy() {
            this.add("byDimensions", (Spy)new SpyByDimensions());
            this.add("byLastUsed", (Spy)new SpyByLastUsed());
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"trimAll")) {
                return new TrimAllSpy();
            }
            return super.find(name);
        }
    }

    static class SpyByLastUsed
    extends AbstractSpy {
        SpyByLastUsed() {
        }

        @Override
        public int compare(MicroImageData a, MicroImageData b) {
            long aticks = a.lastUsedTicks;
            long bticks = b.lastUsedTicks;
            if (aticks < bticks) {
                return -1;
            }
            return 1;
        }
    }

    static class SpyByDimensions
    extends AbstractSpy {
        SpyByDimensions() {
        }

        @Override
        public int compare(MicroImageData a, MicroImageData b) {
            double bsize;
            double asize = a.getWidth() + a.getHeight();
            if (asize < (bsize = b.getWidth() + b.getWidth())) {
                return 1;
            }
            if (asize == bsize) {
                return 0;
            }
            return -1;
        }
    }

    static class SpyByKey
    extends AbstractSpy {
        SpyByKey() {
        }

        @Override
        public int compare(MicroImageData a, MicroImageData b) {
            return SortUtil.compare((Object)a.cacheKey, (Object)b.cacheKey);
        }
    }

    static abstract class AbstractSpy
    extends SpyDir
    implements Comparator<MicroImageData> {
        AbstractSpy() {
        }

        public void write(SpyWriter out) throws Exception {
            Object[] datas = cache.values().toArray(new MicroImageData[cache.size()]);
            SortUtil.sort((Object[])datas, (Object[])datas, (Comparator)this);
            out.w((Object)"<b>").mutatorButton("/microImageManager/trimAll", "Trim All").w((Object)"</b><br/><br/>");
            out.startTable(true);
            out.trTitle((Object)("Micro Image Cache [" + datas.length + "]"), 3);
            out.w((Object)"<tr>").th().w((Object)"<b>").a("/microImageManager", (Object)"Image").w((Object)"</b>").endTh().th().w((Object)"<b>").a("/microImageManager/byDimensions", (Object)"Dimensions").w((Object)"</b>").endTh().th().w((Object)"<b>").a("/microImageManager/byLastUsed", (Object)"Last Used").w((Object)"</b>").endTh().w((Object)"</tr>\n");
            for (int i = 0; i < datas.length; ++i) {
                Object data = datas[i];
                double width = ((MicroImageData)data).getWidth();
                double height = ((MicroImageData)data).getHeight();
                String lastUsed = BRelTime.toString((long)(Clock.ticks() - ((MicroImageData)data).lastUsedTicks));
                out.tr((Object)((MicroImageData)data).cacheKey, (Object)("" + width + " x " + height), (Object)lastUsed);
            }
            out.endTable();
        }
    }

    static class TrimAllSpy
    extends SpyDir {
        TrimAllSpy() {
        }

        public void write(SpyWriter out) throws Exception {
            MicroImageManager.trimAll();
            out.w((Object)"<b>Micro Image Manager Trim All Complete</b>");
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<b><a href='/microImageManager'>return to Micro Image Manager</a></b>");
        }
    }

    static class MicroImageManagerThread
    extends Thread {
        MicroImageManagerThread() {
            super(Nre.mainThreadGroup, "Ui:MicroImageManager");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long lastTrim = Clock.ticks();
            while (true) {
                try {
                    while (true) {
                        if (Clock.ticks() - lastTrim > 60000L) {
                            lastTrim = Clock.ticks();
                            MicroImageManager.trim();
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

