/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.se.AwtSeEnv;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.IGeom;

public class AwtSeGraphics
extends AwtGraphics {
    Line2D.Double line = new Line2D.Double();
    Rectangle2D.Double rect = new Rectangle2D.Double();
    boolean useAA = false;

    public AwtSeGraphics(Graphics2D g) {
        super(g);
    }

    public void useAntiAliasing(boolean b) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            this.g.addRenderingHints(map);
        } else {
            this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        this.setAntiAliasHints();
    }

    public void setBrush(BBrush b) {
        this.brush = b;
        this.g.setPaint(AwtSeEnv.peer(b));
        if (b.getPaint() instanceof BBrush.Inverse) {
            this.g.setXORMode(Color.white);
        } else {
            this.g.setPaintMode();
        }
    }

    public void setPen(BPen p) {
        this.pen = p;
        this.g.setStroke(AwtSeEnv.peer(p));
    }

    public void transform(BTransform transform) {
        this.g.transform(AwtSeEnv.peer(transform));
    }

    public void translate(double x, double y) {
        this.g.translate(x, y);
    }

    public void clip(double x, double y, double w, double h) {
        this.rect.setRect(x, y, w, h);
        this.g.clip(this.rect);
    }

    @Override
    public void drawString(String str, double x, double y) {
        this.setFontAntiAliasHints();
        super.drawString(str, x, y);
        this.setAntiAliasHints();
    }

    @Override
    public void drawString(char[] data, int offset, int length, double x, double y) {
        this.setFontAntiAliasHints();
        super.drawString(data, offset, length, x, y);
        this.setAntiAliasHints();
    }

    public void stroke(IGeom geom) {
        this.g.draw(AwtSeEnv.peer(geom).shape());
    }

    public void fill(IGeom geom) {
        this.g.fill(AwtSeEnv.peer(geom).shape());
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            this.fillRect(x1, y1, 1.0, 1.0);
        } else {
            this.line.setLine(x1, y1, x2, y2);
            this.g.draw(this.line);
        }
    }

    public void fillRect(double x, double y, double width, double height) {
        this.rect.setRect(x, y, width, height);
        this.g.fill(this.rect);
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.rect.setRect(x, y, width, height);
        this.g.draw(this.rect);
    }

    private void setFontAntiAliasHints() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.font.isAntiAliased()) {
            this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    private void setAntiAliasHints() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
    }
}

