/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import javax.baja.gx.BBrush;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class AwtLinearGradient
implements Paint,
PaintContext {
    private BBrush.LinearGradient gradient;
    private float[] frac;
    private Color[] cols;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private PaintContext context;

    public AwtLinearGradient(BBrush.LinearGradient gradient) {
        this.gradient = gradient;
        BBrush.Stop[] stops = gradient.getStops();
        this.frac = new float[stops.length];
        this.cols = new Color[stops.length];
        for (int i = 0; i < stops.length; ++i) {
            this.frac[i] = (float)stops[i].getOffset() / 100.0f;
            this.cols[i] = AwtEnv.peer(stops[i].getColor());
        }
        double deg = gradient.getAngle();
        double rad = deg / 180.0 * Math.PI + Math.PI;
        rad = -rad;
        double ax = Math.cos(rad) * 0.5;
        double ay = Math.sin(rad) * 0.5;
        this.x1 = Math.abs(ax);
        this.y1 = Math.abs(ay);
        if (this.x1 > this.y1) {
            this.y1 = this.y1 * 0.5 / this.x1;
            this.x1 = 0.5;
        } else {
            this.x1 = this.x1 * 0.5 / this.y1;
            this.y1 = 0.5;
        }
        if (ax < 0.0) {
            this.x1 = -this.x1;
        }
        if (ay < 0.0) {
            this.y1 = -this.y1;
        }
        this.x1 += 0.5;
        this.y1 += 0.5;
        this.x2 = 1.0 - this.x1;
        this.y2 = 1.0 - this.y1;
    }

    @Override
    public int getTransparency() {
        return 2;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        float tempX1 = (float)(userBounds.getX() + userBounds.getWidth() * this.x1);
        float tempY1 = (float)(userBounds.getY() + userBounds.getHeight() * this.y1);
        float tempX2 = (float)(userBounds.getX() + userBounds.getWidth() * this.x2);
        float tempY2 = (float)(userBounds.getY() + userBounds.getHeight() * this.y2);
        if (tempX1 == tempX2 && tempY1 == tempY2) {
            tempY2 = (float)((double)tempY2 + 0.1);
        }
        LinearGradientPaint paint = new LinearGradientPaint(tempX1, tempY1, tempX2, tempY2, this.frac, this.cols);
        this.context = paint.createContext(cm, deviceBounds, userBounds, xform, hints);
        return this;
    }

    @Override
    public void dispose() {
        this.context.dispose();
    }

    @Override
    public ColorModel getColorModel() {
        return this.context.getColorModel();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        return this.context.getRaster(x, y, w, h);
    }
}

