/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.Hatching;
import com.tridium.gx.awt.AwtGraphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;

public class AwtHatching
implements Hatching,
Paint,
PaintContext {
    private static final ColorModel COLOR_MODEL = ColorModel.getRGBdefault();
    private static final int size = 5;
    private int[] pixel = new int[4];
    private double dx;
    private double dy;
    private int width = 0;
    private int height = 0;
    private WritableRaster raster;
    private Raster blank;

    public void fillRect(Graphics g, double x, double y, double width, double height) {
        Graphics2D g2 = ((AwtGraphics)g).getAwtGraphics();
        g2.setPaint(this);
        g2.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    public void setColor(BColor color) {
        this.pixel[0] = color.getRed();
        this.pixel[1] = color.getGreen();
        this.pixel[2] = color.getBlue();
        this.pixel[3] = color.getAlpha();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        this.dx = xform.getTranslateX();
        this.dy = xform.getTranslateY();
        return this;
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return COLOR_MODEL;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (w > this.width || h > this.height) {
            this.width = w;
            this.height = h;
            this.raster = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
            this.blank = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
        } else {
            this.raster.setDataElements(0, 0, this.blank);
        }
        int x0 = (int)Math.round((double)x - this.dx);
        int y0 = (int)Math.round((double)y - this.dy);
        int x1 = x0 + w;
        int y1 = y0 + h;
        int n = x0 + y0;
        while (n % 5 != 4) {
            ++n;
        }
        int yy = y0 + Math.max(w, h) * 2;
        for (int i = n -= x0; i < yy; i += 5) {
            int a = x0;
            for (int b = i; a < x1 && b >= y0; ++a, --b) {
                if (a < x0 || b >= y1) continue;
                this.raster.setPixel(a - x0, b - y0, this.pixel);
            }
        }
        return this.raster;
    }
}

