/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.GifAnimator;
import com.tridium.gx.awt.ImageAnimator;
import com.tridium.gx.awt.ImageManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.gx.BTransform;

public class GifDecoder {
    private Image image;
    private GifAnimator animator = new GifAnimator();
    private static final boolean DEBUG = true;
    private static final int STACK_SIZE = 4096;
    private byte[] data;
    private int dataSize;
    private int pos;
    private int width;
    private int height;
    private int bgIndex;
    private ColorTable gct;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private boolean interlace;
    private int delay = -1;
    private int transIndex = -1;
    private int dispose = 0;
    private int lastDispose = 0;
    private int blockSize;
    private byte[] block = new byte[256];
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private byte[] lastDest;
    private byte[] lastLastDest;

    public void decode(byte[] data, BTransform.Scale scale) throws Exception {
        int i;
        this.data = data;
        this.dataSize = data.length;
        this.pos = 0;
        this.readHeader();
        ArrayList<GifAnimator.Frame> v = new ArrayList<GifAnimator.Frame>();
        boolean done = false;
        block5: while (!done) {
            int sep = this.u1();
            switch (sep) {
                case 44: {
                    v.add(this.readImage());
                    continue block5;
                }
                case 33: {
                    this.readExt();
                    continue block5;
                }
                case 59: {
                    done = true;
                    continue block5;
                }
            }
            throw this.err();
        }
        GifAnimator.Frame[] frames = v.toArray(new GifAnimator.Frame[v.size()]);
        if (scale != null) {
            for (i = 0; i < frames.length; ++i) {
                frames[i].image = ImageManager.rescaleImage(frames[i].image, scale);
            }
        }
        this.animator.frames = frames;
        this.image = this.animator.frames[0].image;
        this.animator.duration = 0.0;
        for (i = 0; i < this.animator.frames.length; ++i) {
            this.animator.duration += (double)this.animator.frames[i].delay;
        }
    }

    private void readHeader() throws Exception {
        if (this.data[0] != 71 || this.data[1] != 73 || this.data[2] != 70) {
            throw this.err();
        }
        this.pos = 6;
        this.width = this.u2();
        this.height = this.u2();
        int bits = this.u1();
        this.bgIndex = this.u1();
        int aspect = this.u1();
        boolean gctFlag = (bits >> 7 & 1) != 0;
        int gctSize = bits >> 0 & 7;
        if (gctFlag) {
            this.gct = this.readColorTable(gctSize);
        }
    }

    private ColorTable readColorTable(int size) throws Exception {
        ColorTable ct = new ColorTable();
        int length = ct.length = 1 << size + 1;
        ct.r = new byte[length];
        byte[] r = ct.r;
        ct.g = new byte[length];
        byte[] g = ct.g;
        ct.b = new byte[length];
        byte[] b = ct.b;
        if (this.pos + length * 3 >= this.dataSize) {
            throw new EOFException();
        }
        for (int i = 0; i < length; ++i) {
            r[i] = this.data[this.pos++];
            g[i] = this.data[this.pos++];
            b[i] = this.data[this.pos++];
        }
        return ct;
    }

    private GifAnimator.Frame readImage() throws Exception {
        GifAnimator.Frame frame = new GifAnimator.Frame();
        frame.delay = this.delay;
        this.ix = this.u2();
        this.iy = this.u2();
        this.iw = this.u2();
        this.ih = this.u2();
        int bits = this.u1();
        boolean lctFlag = (bits >> 7 & 1) != 0;
        this.interlace = (bits >> 6 & 1) != 0;
        int lctSize = bits >> 0 & 7;
        ColorTable ct = this.gct;
        if (lctFlag) {
            ct = this.readColorTable(lctSize);
        }
        this.readImageData();
        frame.image = ImageManager.sync(this.render(ct));
        this.skip();
        this.transIndex = -1;
        this.delay = -1;
        this.lastDispose = this.dispose;
        this.dispose = 1;
        return frame;
    }

    private void readImageData() throws Exception {
        int code;
        int NullCode = -1;
        int npix = this.iw * this.ih;
        this.pixels = new byte[npix];
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int data_size = this.u1();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)old_code;
                this.suffix[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = (byte)this.bgIndex;
        }
    }

    private Image render(ColorTable ct) {
        byte[] dest = new byte[this.width * this.height];
        if (this.lastDispose == 0 || this.lastDispose == 2) {
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = (byte)this.transIndex;
            }
        } else {
            if (this.lastDispose == 3) {
                this.lastDest = this.lastLastDest;
            }
            if (this.lastDest != null) {
                System.arraycopy(this.lastDest, 0, dest, 0, dest.length);
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.height) continue;
            int k = line * this.width;
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.width < dlim) {
                dlim = k + this.width;
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index = this.pixels[sx] & 0xFF;
                if (index != this.transIndex) {
                    dest[dx] = this.pixels[sx];
                }
                ++sx;
                ++dx;
            }
        }
        this.lastLastDest = this.lastDest;
        this.lastDest = dest;
        IndexColorModel cm = new IndexColorModel(8, ct.length, ct.r, ct.g, ct.b, this.transIndex);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)cm, dest, 0, this.width));
    }

    private void readExt() throws Exception {
        int code = this.u1();
        switch (code) {
            case 249: {
                this.readGraphicControlExt();
                break;
            }
            case 255: {
                this.readBlock();
                String app = "";
                for (int i = 0; i < 11; ++i) {
                    app = app + (char)this.block[i];
                }
                if (app.equals("NETSCAPE2.0")) {
                    this.readNetscapeExt();
                    break;
                }
                this.skip();
                break;
            }
            default: {
                this.skip();
            }
        }
    }

    private void readGraphicControlExt() throws Exception {
        boolean transFlag;
        int blockSize = this.u1();
        int bits = this.u1();
        this.delay = this.u2() * 10;
        int transIndex = this.u1();
        int terminator = this.u1();
        this.dispose = bits >> 2 & 3;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.delay = Math.max(100, this.delay);
        boolean bl = transFlag = (bits & 1) != 0;
        if (transFlag) {
            this.transIndex = transIndex;
        }
    }

    private void readNetscapeExt() throws Exception {
        this.readBlock();
        if (this.blockSize > 0 && this.block[0] == 1) {
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.animator.loopCount = b2 << 8 | b1;
        }
        int terminator = this.u1();
    }

    private void skip() throws Exception {
        int size;
        while ((size = this.u1()) != 0) {
            this.pos += size;
        }
    }

    private int u1() throws Exception {
        if (this.pos >= this.dataSize) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF;
    }

    private int u2() throws Exception {
        return this.u1() | this.u1() << 8;
    }

    private int rgb() throws Exception {
        return (this.u1() << 16) + (this.u1() << 8) + this.u1();
    }

    private int readBlock() throws Exception {
        this.blockSize = this.u1();
        int n = this.blockSize;
        if (n + this.pos >= this.dataSize) {
            throw new EOFException();
        }
        System.arraycopy(this.data, this.pos, this.block, 0, n);
        this.pos += n;
        return n;
    }

    private IOException err() {
        return new IOException("Invalid GIF format");
    }

    public Image getImage() {
        return this.image;
    }

    public ImageAnimator getAnimator() {
        return this.animator;
    }

    static class ColorTable {
        byte[] r;
        byte[] g;
        byte[] b;
        int length;

        ColorTable() {
        }
    }
}

