/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;

public class DisabledImageFactory
extends RGBImageFilter {
    static final DisabledImageFactory filter = new DisabledImageFactory();
    static final Component component = new Component(){
        private static final long serialVersionUID = 4208017902601162841L;
    };
    static final MediaTracker tracker = new MediaTracker(component);
    protected float[] hsb;
    protected int[][] pixels;
    protected int width;
    protected int height;
    protected static final int OUTLINE_COLOR = -10066330;
    private static final Logger LOG = Logger.getLogger("gx");

    public static synchronized Image convert(Image colorImage) {
        FilteredImageSource src = new FilteredImageSource(colorImage.getSource(), filter);
        Image disabledImage = component.createImage(src);
        tracker.addImage(disabledImage, 0);
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        tracker.waitForID(0, 0L);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (InterruptedException)e.getException();
            }
        }
        catch (InterruptedException e) {
            LOG.severe("DisabledImageFactory.convert -> interrupted");
        }
        tracker.removeImage(disabledImage, 0);
        return disabledImage;
    }

    private DisabledImageFactory() {
        this.canFilterIndexColorModel = false;
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.pixels = new int[width][height];
        this.width = width;
        this.height = height;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        alpha = alpha >> 1 & 0xFF;
        int n = alpha << 24 | rgb & 0xFFFFFF;
        this.pixels[x][y] = n;
        return n;
    }
}

