/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.FontPeer;
import com.tridium.gx.awt.AwtGraphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.WeakHashMap;
import javax.baja.gx.BFont;

public class AwtFontPeer
implements FontPeer {
    public final BFont font;
    public final Font awtFont;
    private static Map<Font, FontMetrics> metrics = new WeakHashMap<Font, FontMetrics>();
    private FontMetrics fm;

    public AwtFontPeer(BFont font) {
        this(font, font.getName());
    }

    AwtFontPeer(BFont font, String fontName) {
        int style = 0;
        if (font.isBold()) {
            style = 1;
        }
        if (font.isItalic()) {
            style |= 2;
        }
        this.font = font;
        this.awtFont = new Font(fontName, style, (int)font.getSize());
    }

    public double getLeading() {
        return this.fm().getLeading();
    }

    public double getAscent() {
        return this.fm().getAscent();
    }

    public double getDescent() {
        return this.fm().getDescent();
    }

    public double getHeight() {
        return this.fm().getHeight();
    }

    public double getMaxAscent() {
        return this.fm().getMaxAscent();
    }

    public double getMaxDescent() {
        return this.fm().getMaxDescent();
    }

    public double width(int c) {
        return this.width(new char[]{(char)c}, 0, 1);
    }

    public double width(String s) {
        AttributedString as = AwtGraphics.asAttributedString(this.font, s);
        if (as == null) {
            return this.fm().stringWidth(s);
        }
        double totalWidth = 0.0;
        AttributedCharacterIterator it = as.getIterator();
        int c = it.first();
        while (c != 65535) {
            Font font = (Font)it.getAttribute(TextAttribute.FONT);
            int codePoint = c;
            if (Character.isHighSurrogate((char)c)) {
                char c2 = it.next();
                if (Character.isLowSurrogate(c2)) {
                    codePoint = Character.toCodePoint((char)c, c2);
                } else {
                    it.previous();
                }
            }
            double width = this.fm(font).charWidth(codePoint);
            totalWidth += width;
            c = it.next();
        }
        return totalWidth;
    }

    public double width(char[] data, int off, int len) {
        return this.width(new String(data, off, len));
    }

    public FontMetrics fm() {
        if (this.fm == null) {
            this.fm = this.fm(this.awtFont);
        }
        return this.fm;
    }

    private FontMetrics fm(Font font) {
        FontMetrics fm = metrics.get(font);
        if (fm == null) {
            fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            metrics.put(font, fm);
        }
        return fm;
    }
}

