/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.app.ui;

import javax.baja.app.BApp;
import javax.baja.app.BAppFolder;
import javax.baja.app.BIAppComponent;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

public final class BAppManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BAppManager.class);
    private MgrColumn[] cols = new MgrColumn[]{new MgrColumn.Name(), new AppComponentDisplayNameMgrCol(), new MgrColumn.Type(0), new AppMgrCol(BApp.version), new AppMgrCol(BApp.status), new AppMgrCol(BApp.enabled, 1), new AppMgrCol(BApp.faultCause)};
    private static final Lexicon lex = Lexicon.make(BAppManager.class);

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model();
    }

    protected MgrController makeController() {
        return new Controller();
    }

    private static final class AppMgrCol
    extends MgrColumn.Prop {
        private AppMgrCol(Property prop) {
            super(prop);
        }

        private AppMgrCol(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return row instanceof BApp ? super.toDisplayString(row, value, cx) : " - ";
        }
    }

    private static final class AppComponentDisplayNameMgrCol
    extends MgrColumn {
        private AppComponentDisplayNameMgrCol() {
            super(lex.get("appManager.appName"), 0);
        }

        public Object get(Object row) {
            return ((BIAppComponent)row).getAppDisplayName(null);
        }
    }

    private class Controller
    extends FolderController {
        private Controller() {
            super((BFolderManager)BAppManager.this);
            this.allDescendants.setFlags(7);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = table.getComponentAt(row);
            BWbShell shell = BAppManager.this.getWbShell();
            if (comp != null && shell != null) {
                shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), (BInputEvent)event));
            }
        }
    }

    private class Model
    extends FolderModel {
        private Model() {
            super((BFolderManager)BAppManager.this);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return BAppManager.this.cols;
        }

        public Type getFolderType() {
            return BAppFolder.TYPE;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BApp.TYPE, BAppFolder.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BApp.TYPE);
        }
    }
}

