/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.ldap.v3.BKerberosConfig;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.util.Lexicon;
import javax.naming.directory.InitialDirContext;

class LdapKerberosAuthAction
implements PrivilegedExceptionAction<Object> {
    BKerberosConfig config;
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    public LdapKerberosAuthAction(BKerberosConfig config) {
        this.config = config;
    }

    @Override
    public Object run() throws Exception {
        String s;
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        h.put("java.naming.security.authentication", "GSSAPI");
        h.put("java.naming.referral", "follow");
        String url = this.config.getConnectionUrl();
        if (url.isEmpty()) {
            throw new Exception(lex.getText("ldap.error.emptyConnectionUrl"));
        }
        h.put("java.naming.provider.url", this.config.getAllConnectionUrls());
        if (!this.config.getEnableConnectionPooling()) {
            h.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.config.getSSL()) {
            h.put("java.naming.security.protocol", "ssl");
            if (CertManagerFactory.isCertManagerActive()) {
                h.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
            }
        }
        if (!(s = this.config.getReferral()).isEmpty()) {
            h.put("java.naming.referral", s);
        }
        String timeout = String.valueOf(this.config.getConnectionTimeout() * 1000);
        h.put("com.sun.jndi.ldap.connect.timeout", timeout);
        return new InitialDirContext(h);
    }
}

