/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.v3.AcquireHttpCredentialsAction;
import com.tridium.ldap.v3.KerberosCallback;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"ldap:KerberosAuthenticationScheme"})})
public class BWebKerberosCallbackHandler
extends BWebCallbackHandler {
    public static final Type TYPE = Sys.loadType(BWebKerberosCallbackHandler.class);
    private String username = null;
    private char[] password = null;
    private boolean readyForCallback = false;
    private String token = null;
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.readyForCallback) {
            throw new IllegalStateException("Not ready for callback");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof KerberosCallback) {
                BIUserCredentials cred;
                KerberosCallback kCallback = (KerberosCallback)callback;
                if (this.token != null) {
                    try {
                        cred = (BIUserCredentials)AccessController.doPrivileged(() -> Subject.doAs(kCallback.getSubject(), new AcquireHttpCredentialsAction(this.token)));
                        kCallback.setCredentials(cred);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = lex.getText("ldap.error.couldNotGetCreds");
                        BLdapConfig.logException(msg, e, Level.SEVERE);
                        throw new IOException(msg);
                    }
                }
                if (this.password != null && this.username != null) {
                    cred = new BUsernameAndPassword(this.username, BPassword.make((char[])this.password));
                    kCallback.setCredentials(cred);
                    continue;
                }
                throw new IOException("Could not acquire credentials.");
            }
            throw new UnsupportedCallbackException(callback, lex.getText("ldap.error.callbackUnsupported", new Object[]{callback.getClass()}));
        }
    }

    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(__J_PASSWORD) != null) {
            if (!req.isSecure()) {
                return 3;
            }
            this.username = req.getParameter(__J_USERNAME);
            this.password = req.getParameter(__J_PASSWORD).toCharArray();
            this.readyForCallback = true;
            return 0;
        }
        String header = req.getHeader("Authorization");
        if (header != null) {
            this.token = header.substring("Negotiate ".length());
            this.readyForCallback = true;
            return 0;
        }
        resp.addHeader("www-authenticate", "Negotiate");
        resp.sendError(401);
        return 1;
    }

    public String getUsername() {
        return this.username;
    }
}

