/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.file.BExporter;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.ExportOp;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbView;

public class BAppletExportDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BAppletExportDialog.class);
    static AgentFilter viewFilter = AgentFilter.is((TypeInfo)BWbView.TYPE.getTypeInfo());
    static BImage icon = BImage.make((String)"module://icons/x32/export.png");
    static UiLexicon lex = UiLexicon.bajaui();
    static final int VIEW_INTERNAL = 0;
    static final int VIEW_EXTERNAL = 1;
    static final int EMAIL = 2;
    static final int SAVE = 3;
    BWidget owner;
    BWbView view;
    OrdTarget target;
    ExporterItem[] exporters;
    ExporterItem cur;
    BListDropDown exporterField;
    BTextField email;
    BTextField saveOrd;
    ToggleCommandGroup action;
    ToggleCommand actionViewInternal = new ActionViewInternal((BWidget)this);
    ToggleCommand actionViewExternal = new ActionViewExternal((BWidget)this);
    ToggleCommand actionEmail = new ActionEmail((BWidget)this);
    ToggleCommand actionSave = new ActionSave((BWidget)this);
    Command saveBrowse = new SaveBrowse((BWidget)this);
    BBorderPane setupPane = new BBorderPane();
    BWbEditor setup;

    public Type getType() {
        return TYPE;
    }

    public static CommandArtifact invoke(BWbShell shell, boolean asPrint) throws Exception {
        BWbView view = shell.getActiveView();
        OrdTarget target = shell.getActiveOrdTarget();
        return BAppletExportDialog.invoke(new BAppletExportDialog((BWidget)shell, target, view, asPrint));
    }

    public static CommandArtifact invoke(BTable table, boolean asPrint) throws Exception {
        BITable itable = table.getModel().export();
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)itable, (Context)itable.getTableFacets());
        return BAppletExportDialog.invoke(new BAppletExportDialog((BWidget)table, target, null, asPrint));
    }

    public static CommandArtifact invoke(BAppletExportDialog dialog) throws Exception {
        while (true) {
            int r;
            if ((r = BDialog.open((BWidget)dialog.owner, (String)"Export", (Object)((Object)dialog), (int)3)) != 1) {
                return null;
            }
            try {
                dialog.setup.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)dialog.owner, (String)"Cannot save setup", (Object)e);
                continue;
            }
            break;
        }
        switch (dialog.getSelectedAction()) {
            case 0: {
                BAppletExportDialog.viewInternal(dialog);
                break;
            }
            case 1: {
                BAppletExportDialog.viewExternal(dialog);
                break;
            }
            case 2: {
                BAppletExportDialog.email(dialog);
                break;
            }
            case 3: {
                BAppletExportDialog.save(dialog);
            }
        }
        return null;
    }

    static void viewInternal(BAppletExportDialog dialog) throws Exception {
        File file = BAppletExportDialog.makeTempFile(dialog);
        BOrd ord = BFileSystem.INSTANCE.localFileToOrd(file);
        dialog.shell().hyperlink(ord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File makeTempFile(BAppletExportDialog dialog) throws Exception {
        BExporter exporter = dialog.cur.getInstance();
        OrdTarget target = dialog.cur.target;
        File dir = new File(Sys.getNiagaraUserHome(), "temp");
        dir.mkdirs();
        File file = File.createTempFile("temp", "." + exporter.getFileExtension(), dir);
        file.deleteOnExit();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            exporter.export(ExportOp.make((OrdTarget)target, (OutputStream)out));
        }
        return file;
    }

    static void viewExternal(BAppletExportDialog dialog) throws Exception {
        File file = BAppletExportDialog.makeTempFile(dialog);
        BAppletExportDialog.launchExternal(file);
    }

    public static void launchExternal(File file) throws Exception {
        String path = BAppletExportDialog.formatPath(file);
        Runtime.getRuntime().exec("cmd.exe /c start " + path);
    }

    static String formatPath(File file) throws Exception {
        String path = "";
        String[] s = TextUtil.split((String)file.getCanonicalPath(), (char)'\\');
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                path = path + "\\";
            }
            path = s[i].indexOf(" ") != -1 ? path + "\"" + s[i] + "\"" : path + s[i];
        }
        return path;
    }

    static void email(BAppletExportDialog dialog) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(BAppletExportDialog dialog) throws Exception {
        BExporter exporter = dialog.cur.getInstance();
        OrdTarget target = dialog.cur.target;
        String ext = exporter.getFileExtension();
        String path = dialog.saveOrd.getText();
        if (path.length() == 0) {
            BDialog.error((BWidget)dialog.owner, (Object)("Illegal filename: " + path));
            return;
        }
        if (!path.endsWith(ext)) {
            path = path + "." + ext;
        }
        BOrd ord = BOrd.make((String)path);
        BIFile file = null;
        try {
            file = (BIFile)ord.resolve().get();
            if (8 == BDialog.confirm((BWidget)dialog.owner, (Object)"File already exists.  Do you want to overwrite?")) {
                return;
            }
        }
        catch (UnresolvedException e) {
            OrdQuery[] q = ord.parse();
            FilePath filepath = (FilePath)q[q.length - 1];
            q[q.length - 1] = new FilePath("");
            BFileSpace space = (BFileSpace)BOrd.make((OrdQuery[])q).resolve().get();
            file = space.makeFile(filepath);
        }
        catch (SyntaxException e2) {
            BDialog.error((BWidget)dialog.owner, (Object)("Illegal filename: " + path));
            return;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(file.getOutputStream());){
            exporter.export(ExportOp.make((OrdTarget)target, (OutputStream)out));
        }
    }

    private BAppletExportDialog(BWidget owner, OrdTarget target, BWbView view, boolean asPrint) throws Exception {
        this.owner = owner;
        this.target = target;
        this.view = view;
        this.exporters = this.findExporters();
        if (this.exporters.length == 0) {
            throw new LocalizableException((Lexicon)lex, "exporter.noExporters");
        }
        this.setTop((BWidget)new BWizardHeader(icon, lex.getText("commands.export.label")));
        BTabbedPane tabs = new BTabbedPane();
        tabs.addPane(lex.getText("exporter.action"), this.buildAction());
        this.setCenter((BWidget)new BBorderPane((BWidget)tabs));
        int index = 0;
        if (asPrint) {
            TypeInfo pdfExporter = Sys.getRegistry().getType("pdf:PdfExporter");
            for (int i = 0; i < this.exporters.length; ++i) {
                if (!this.exporters[i].agent.getAgentType().is(pdfExporter)) continue;
                index = i;
                break;
            }
        }
        this.exporterField.getList().setSelectedIndex(index);
    }

    BWidget buildAction() {
        this.exporterField = new BListDropDown();
        this.exporterField.getList().setSelection((ListSelection)new ExporterListSelection());
        for (int i = 0; i < this.exporters.length; ++i) {
            ExporterItem item = this.exporters[i];
            this.exporterField.getList().addItem(item.icon, (Object)item.label);
        }
        BGridPane exporterPane = new BGridPane(2);
        exporterPane.add(null, (BValue)new BLabel(lex.getText("exporter.select.exporter")));
        exporterPane.add(null, (BValue)this.exporterField);
        ToggleCommandGroup actionGroup = new ToggleCommandGroup();
        actionGroup.add(this.actionViewExternal);
        actionGroup.add(this.actionEmail);
        actionGroup.add(this.actionSave);
        this.actionViewExternal.setSelected(true);
        this.email = new BTextField("", 55, false);
        this.saveOrd = new BTextField("", 55, false);
        BEdgePane savePane = new BEdgePane();
        savePane.setRight((BWidget)new BButton(this.saveBrowse));
        BGridPane actionPane = new BGridPane(1);
        actionPane.setColumnAlign(BHalign.fill);
        actionPane.add(null, (BValue)new BRadioButton(this.actionViewExternal));
        actionPane.add(null, (BValue)new BRadioButton(this.actionSave));
        actionPane.add(null, (BValue)new BBorderPane((BWidget)this.saveOrd, 0.0, 0.0, 0.0, 20.0));
        actionPane.add(null, (BValue)new BBorderPane((BWidget)savePane, 0.0, 0.0, 0.0, 20.0));
        BGridPane pane = new BGridPane(1);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.add(null, (BValue)exporterPane);
        pane.add(null, (BValue)new BBorderPane((BWidget)actionPane, 10.0, 0.0, 0.0, 0.0));
        return new BBorderPane((BWidget)pane);
    }

    ExporterItem[] findExporters() {
        Array acc = new Array(ExporterItem.class);
        if (this.view != null) {
            this.findViewExporters(acc, this.view);
        }
        if (this.view instanceof BIExportableTableView) {
            this.findTableViewExporters(acc, (BIExportableTableView)this.view);
        }
        if (this.target != null) {
            this.findOrdTargetExporters(acc, this.target);
        }
        return (ExporterItem[])acc.trim();
    }

    void findViewExporters(Array acc, BWbView view) {
        BOrd ord = BOrd.make((String)("view:" + view.getType()));
        OrdTarget target = ord.resolve((BObject)view);
        AgentFilter filter = AgentFilter.is((Type)BIWbViewExporter.TYPE);
        AgentList list = view.getAgents(null).filter(filter);
        this.addExporters(acc, list, target);
    }

    void findTableViewExporters(Array acc, BIExportableTableView view) {
        BITable itable = view.getExportTable().getModel().export();
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)itable, (Context)itable.getTableFacets());
        this.findOrdTargetExporters(acc, target);
    }

    void findOrdTargetExporters(Array acc, OrdTarget target) {
        AgentFilter filter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList list = target.get().getAgents(null).filter(filter);
        this.addExporters(acc, list, target);
    }

    void addExporters(Array acc, AgentList agents, OrdTarget target) {
        for (int i = 0; i < agents.size(); ++i) {
            acc.add((Object)new ExporterItem(agents.get(i), target));
        }
    }

    public BWbShell shell() {
        return BWbShell.getWbShell((BWidget)this.owner);
    }

    void updateExporter(ExporterItem item) {
        try {
            this.cur = item;
            BExporter exporter = item.getInstance();
            this.setup = (BWbEditor)exporter.getAgents().filter(viewFilter).getDefault().getInstance();
            this.setup.loadValue((BObject)exporter);
            this.setupPane.setContent((BWidget)this.setup);
            AgentList agents = exporter.getAgents().filter(viewFilter);
            this.actionViewInternal.setEnabled(agents.size() > 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setup = null;
            this.setupPane.setContent((BWidget)new BLabel("ERROR"));
        }
    }

    int getSelectedAction() {
        if (this.actionViewInternal.isSelected()) {
            return 0;
        }
        if (this.actionViewExternal.isSelected()) {
            return 1;
        }
        if (this.actionEmail.isSelected()) {
            return 2;
        }
        if (this.actionSave.isSelected()) {
            return 3;
        }
        throw new IllegalStateException();
    }

    static class ExporterItem {
        final AgentInfo agent;
        final OrdTarget target;
        final BImage icon;
        final String label;
        private BExporter instance;

        ExporterItem(AgentInfo agent, OrdTarget target) {
            this.agent = agent;
            this.target = target;
            this.icon = BImage.make((BIcon)agent.getIcon(null));
            this.label = agent.getDisplayName(null);
        }

        public BExporter getInstance() {
            if (this.instance == null) {
                this.instance = (BExporter)this.agent.getInstance();
            }
            return this.instance;
        }
    }

    class SaveBrowse
    extends Command {
        SaveBrowse(BWidget owner) {
            super(owner, (Lexicon)lex, "exporter.save.browse");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCreateFileOnSave(false);
            chooser.setConfirmOverwrite(false);
            BOrd ord = chooser.show();
            if (ord != null) {
                ord = ord.relativizeToSession();
                BAppletExportDialog.this.saveOrd.setText(ord.toString());
            }
            return null;
        }
    }

    class ActionSave
    extends ToggleCommand {
        ActionSave(BWidget owner) {
            super(owner, (Lexicon)lex, "exporter.action.save");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BAppletExportDialog.this.saveOrd.setEditable(this.isSelected());
            BAppletExportDialog.this.saveBrowse.setEnabled(this.isSelected());
        }
    }

    class ActionEmail
    extends ToggleCommand {
        ActionEmail(BWidget owner) {
            super(owner, (Lexicon)lex, "exporter.action.email");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BAppletExportDialog.this.email.setEditable(this.isSelected());
        }
    }

    class ActionViewExternal
    extends ToggleCommand {
        ActionViewExternal(BWidget owner) {
            super(owner, (Lexicon)lex, "exporter.action.viewExternal");
        }
    }

    class ActionViewInternal
    extends ToggleCommand {
        ActionViewInternal(BWidget owner) {
            super(owner, (Lexicon)lex, "exporter.action.viewInternal");
        }
    }

    class ExporterListSelection
    extends ListSelection {
        ExporterListSelection() {
        }

        public void updateList() {
            super.updateList();
            int index = this.getList().getSelectedIndex();
            if (index >= 0) {
                BAppletExportDialog.this.updateExporter(BAppletExportDialog.this.exporters[index]);
            }
        }
    }
}

