/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.ui;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridiumx.accessDriver.BAccess2ReaderModule;
import com.tridiumx.accessDriver.BAccessDeviceFolder;
import com.tridiumx.accessDriver.BAccessInputOutputModule;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BBase2ReaderModule;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BRemote2ReaderModule;
import com.tridiumx.accessDriver.enums.BDoorConfigureEnum;
import com.tridiumx.accessDriver.job.BAccessLearnDevicesJob;
import com.tridiumx.accessDriver.ui.AccessDeviceState;
import com.tridiumx.accessDriver.ui.AppletTableController;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BAccessDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType(BAccessDeviceManager.class);
    static String lexName = UiLexicon.bajaui().getText("name");
    DiscoveryListSubscriber discoveryListSubscriber;
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final UiLexicon lexicon = new UiLexicon(BAccessDeviceManager.class);
    static final Lexicon lex = Lexicon.make(BAccessDeviceManager.class);
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colDevType = new MgrColumn.Prop(BNrioDevice.deviceType, 5);
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnable = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    MgrColumn colAddress = new MgrColumn.Prop(BNrioDevice.address, 5);
    MgrColumn colUid = new BlobColumn(BNrioDevice.uid, 5);
    MgrColumn colInsVer = new MgrColumn.Prop(BNrioDevice.installedVersion);
    MgrColumn colAvaVer = new MgrColumn.Prop(BNrioDevice.availableVersion);
    MgrColumn colDoors = new PropLoc(BAccess2ReaderModule.initialDoors, 3);

    public Type getType() {
        return TYPE;
    }

    public BAccessDeviceManager() {
        this.discoveryListSubscriber = new DiscoveryListSubscriber();
    }

    public BAccessNetwork getAccessNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BAccessDeviceFolder) {
            return (BAccessNetwork)((BAccessDeviceFolder)owner).getNetwork();
        }
        if (owner instanceof BAccessNetwork) {
            return (BAccessNetwork)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        BAccessDeviceManager bAccessDeviceManager = this;
        synchronized (bAccessDeviceManager) {
            super.paint(g);
        }
    }

    void updateLearnData() {
        try {
            BAccessLearnDevicesJob learnJob = (BAccessLearnDevicesJob)this.getLearn().getJob();
            if (learnJob != null) {
                this.getLearn().updateRoots(learnJob.getLearnedDevices().getChildren(BNrioLearnDeviceEntry.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deactivated() {
        super.deactivated();
        Object[] learnEntries = this.getLearn().getRoots();
        for (int i = 0; i < learnEntries.length; ++i) {
            BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)learnEntries[i];
            entry.stopWink();
        }
    }

    public boolean isThisDeviceValid(BNrioLearnDeviceEntry disc) {
        int ordinal = disc.getDeviceType().getOrdinal();
        return ordinal != 4;
    }

    protected MgrModel makeModel() {
        return new AccessDeviceModel(this);
    }

    protected MgrLearn makeLearn() {
        return new AccessDeviceLearn();
    }

    protected MgrController makeController() {
        return new AccessDeviceController(this);
    }

    protected MgrState makeState() {
        return new AccessDeviceState();
    }

    public static class PropLoc
    extends MgrColumn.Prop {
        boolean isValid = true;
        Property prop;

        public PropLoc(String name, Property prop, int flags) {
            super(name, prop, flags);
            this.prop = prop;
        }

        public PropLoc(Property prop, int flags) {
            super(prop.getDefaultDisplayName(null), prop, flags);
            this.prop = prop;
        }

        public PropLoc(Property prop) {
            super(prop, 0);
            this.prop = prop;
        }

        public BValue load(MgrEditRow row) {
            this.isValid = true;
            try {
                BComponent target = row.getTarget();
                return target.getProperty(this.prop.getName()).getDefaultValue();
            }
            catch (Exception e) {
                this.isValid = false;
                return BString.make((String)"");
            }
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            try {
                BComponent target = row.getTarget();
                BValue old = target.get(this.prop);
                if (!old.equivalent((Object)value)) {
                    target.set(this.prop, value.newCopy(), cx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isEditable() {
            if (this.isValid) {
                return super.isEditable();
            }
            return false;
        }

        public boolean isUnseen() {
            if (this.isValid) {
                return super.isUnseen();
            }
            return true;
        }

        public boolean isReadonly() {
            if (this.isValid) {
                return super.isReadonly();
            }
            return true;
        }
    }

    public static class Name
    extends MgrColumn.Name {
        boolean isIo16 = false;

        public Name(int flags) {
            super(flags);
        }

        public Object get(Object row) {
            return ((BComponent)row).getName();
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return value.toString();
        }

        public BValue load(MgrEditRow row) {
            String name = row.getTarget().getName();
            this.isIo16 = ((BNrioDevice)row.getTarget()).getDeviceType().equals((Object)BNrioDeviceTypeEnum.io16);
            if (name != null) {
                return BString.make((String)name);
            }
            return BString.DEFAULT;
        }

        public boolean isReadonly() {
            if (!this.isIo16) {
                return super.isReadonly();
            }
            return false;
        }
    }

    class DiscoveryListSubscriber
    extends Subscriber {
        DiscoveryListSubscriber() {
        }

        public void event(BComponentEvent event) {
            BAccessDeviceManager.this.updateLearnData();
        }
    }

    public class AccessDeviceController
    extends DeviceController {
        public final MgrController.MgrCommand installFirmware;
        public final MgrController.MgrCommand addOfflineHardware;

        public AccessDeviceController(BDeviceManager manager) {
            super(manager);
            this.installFirmware = new InstallFirmware((BWidget)manager);
            this.installFirmware.setFlags(15);
            this.installFirmware.setEnabled(false);
            this.addOfflineHardware = new AddOfflineHardware((BWidget)manager);
            this.addOfflineHardware.setFlags(4);
            this.addOfflineHardware.setEnabled(false);
        }

        public BMenu makeOptionsMenu(BMgrTable table, BMenu menu) {
            menu = super.makeOptionsMenu(table, menu);
            menu = AppletTableController.replaceExport(menu, (BTable)table);
            return menu;
        }

        public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu) {
            if ((menu = super.makePopup(table, subject, menu)).get("views") != null) {
                menu.removeItem("views");
            }
            if (menu.get("find") != null) {
                menu.removeItem("find");
            }
            if (menu.get("composite") != null) {
                menu.removeItem("composite");
            }
            if (menu.get("linkMark") != null) {
                menu.removeItem("linkMark");
            }
            if (menu.get("linkFrom") != null) {
                menu.removeItem("linkFrom");
            }
            if (menu.get("linkTo") != null) {
                menu.removeItem("linkTo");
            }
            if (menu.get("cut") != null) {
                menu.removeItem("cut");
            }
            if (menu.get("copy") != null) {
                menu.removeItem("copy");
            }
            if (menu.get("duplicate") != null) {
                menu.removeItem("duplicate");
            }
            if (menu.get("paste") != null) {
                menu.removeItem("paste");
            }
            if (menu.get("rename") != null) {
                menu.removeItem("rename");
            }
            return menu;
        }

        public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
            BNrioLearnDeviceEntry subjectEntry;
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1 && (subjectEntry = (BNrioLearnDeviceEntry)subject.get(0)).getAddress() > 0) {
                boolean isInStation = this.getManager().getLearn().getExisting(subject.get(0)) != null;
                boolean isWinkActive = subjectEntry.isWinkActive();
                menu.add("wink", (Command)new Wink((BWidget)table, !isInStation & !isWinkActive, "wink"));
            }
            return menu;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.match, this.quickMatch, this.installFirmware, this.addOfflineHardware};
        }

        public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
            if (this.add.isEnabled()) {
                this.add.invoke();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCommands() {
            BAccessDeviceManager bAccessDeviceManager = BAccessDeviceManager.this;
            synchronized (bAccessDeviceManager) {
                BComponent entry;
                super.updateCommands();
                BAccessNetwork network = BAccessDeviceManager.this.getAccessNetwork();
                int maxDevicesCount = BAccessDeviceManager.this.getAccessNetwork().getMaxDevices();
                BComponent[] selectedRows = this.getSelectedComponents();
                boolean enableInstallFirmware = false;
                for (int i = 0; i < selectedRows.length; ++i) {
                    BNrioDevice device = (BNrioDevice)selectedRows[i];
                    if (device.isFault() || device.isDown()) continue;
                    String availVersion = device.getAvailableVersion().trim();
                    String installedVersion = device.getInstalledVersion();
                    if (availVersion.length() <= 0 || device.getInstalledVersion().equals(device.getAvailableVersion())) continue;
                    enableInstallFirmware = true;
                    break;
                }
                this.installFirmware.setEnabled(enableInstallFirmware);
                boolean enableAdd = false;
                if (this.getLearnTable() != null) {
                    Object[] disSelRows = this.getLearnTable().getSelectedObjects();
                    enableAdd = disSelRows.length > 0;
                    for (int i = 0; i < disSelRows.length; ++i) {
                        if (BAccessDeviceManager.this.getLearn().getExisting(disSelRows[i]) == null) continue;
                        enableAdd = false;
                        break;
                    }
                }
                int moduleCount = 0;
                if (this.getTable() != null && this.getTable().getComponentModel() != null) {
                    BComponent[] rows = this.getTable().getComponentModel().getRows();
                    for (int i = 0; i < rows.length; ++i) {
                        entry = rows[i];
                        ++moduleCount;
                    }
                }
                if (this.learnMode.isSelected()) {
                    Object[] disSelRows = this.getLearnTable().getSelectedObjects();
                    for (int i = 0; i < disSelRows.length; ++i) {
                        entry = (BNrioLearnDeviceEntry)disSelRows[i];
                        if (BAccessDeviceManager.this.isThisDeviceValid((BNrioLearnDeviceEntry)entry)) {
                            ++moduleCount;
                            continue;
                        }
                        enableAdd = false;
                    }
                    if (moduleCount > maxDevicesCount) {
                        enableAdd = false;
                    }
                }
                this.add.setEnabled(enableAdd);
                this.quickAdd.setEnabled(enableAdd);
                this.addOfflineHardware.setEnabled(moduleCount <= maxDevicesCount);
            }
        }

        public boolean canAdd(BObject[] values) {
            int moduleCount = 0;
            BComponent[] rows = this.getTable().getComponentModel().getRows();
            for (int i = 0; i < rows.length; ++i) {
                BComponent entry = rows[i];
                ++moduleCount;
            }
            boolean canAdd = true;
            for (int i = 0; i < values.length; ++i) {
                BComplex entry = (BComplex)values[i];
                ++moduleCount;
            }
            int maxDevicesCount = BAccessDeviceManager.this.getAccessNetwork().getMaxDevices();
            if (moduleCount > maxDevicesCount) {
                return false;
            }
            return canAdd;
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            try {
                BAbstractManager mgr = this.getManager();
                String data = (String)cx.getEnvelope().getData(TransferFormat.string);
                String learnData = "dragFromLearn:" + mgr.hashCode();
                if (data.trim().equals(learnData.trim())) {
                    if (!this.add.isEnabled()) {
                        return null;
                    }
                    return this.add.doInvoke();
                }
                Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
                BObject[] values = mark.getValues();
                if (this.canAdd(values)) {
                    return this.add.doInvoke();
                }
                return null;
            }
            catch (Exception exception) {
                return super.drop(table, cx);
            }
        }

        public CommandArtifact doInstallFirmware() throws Exception {
            BAccessNetwork accessNet = BAccessDeviceManager.this.getAccessNetwork();
            BOrd ordToUpgradeJob = accessNet.upgradeFirmware();
            BAccessDeviceManager.this.getLearn().setJob(ordToUpgradeJob);
            return null;
        }

        public CommandArtifact doAddOfflineHardware() throws Exception {
            MgrTypeInfo[] types = MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{BBase2ReaderModule.TYPE.getTypeInfo(), BRemote2ReaderModule.TYPE.getTypeInfo(), BAccessInputOutputModule.TYPE.getTypeInfo()});
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem(types[i].getIcon(), (Object)types[i]);
            }
            BListDropDown enumField = new BListDropDown();
            BEnumRange range = BDoorConfigureEnum.twoDoors.getRange();
            int[] ordinals = range.getOrdinals();
            for (int i = 0; i < ordinals.length; ++i) {
                enumField.getList().addItem((Object)range.get(ordinals[i]));
            }
            enumField.setSelectedIndex(0);
            typeField.setSelectedIndex(0);
            BTextField nameField = new BTextField("");
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("add.name")));
            grid.add(null, (BValue)nameField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.initialDoors")));
            grid.add(null, (BValue)enumField);
            String title = this.addOfflineHardware.getLabel();
            int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
            if (r == 2) {
                return null;
            }
            MgrTypeInfo type = (MgrTypeInfo)typeField.getSelectedItem();
            BDoorConfigureEnum doorConfig = (BDoorConfigureEnum)((Object)enumField.getSelectedItem());
            String name = nameField.getText();
            BNrioDevice device = (BNrioDevice)this.getManager().getModel().newInstance(type);
            if (device instanceof BIAccessDevice) {
                ((BIAccessDevice)device).setInitialDoors(doorConfig);
            }
            BAccessDeviceManager.this.getAccessNetwork().add(name, (BValue)device);
            return null;
        }

        public CommandArtifact doWink() throws Exception {
            BNrioLearnDeviceEntry discoveryDevice = (BNrioLearnDeviceEntry)this.getLearnTable().getSelectedObject();
            BAccessNetwork accessNet = BAccessDeviceManager.this.getAccessNetwork();
            discoveryDevice.doWinkDevice((BNrioNetwork)accessNet, BBoolean.make((boolean)true));
            this.getManager().getLearn().updateTable();
            return null;
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BTextField startAddressField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel(lexicon.getText("devManager.add.startAddress")));
            grid.add(null, (BValue)startAddressField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            int startAddress = 1;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = Integer.parseInt(startAddressField.getText());
                if (count > 247) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.invalidCount"));
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                if (startAddress < 1 || startAddress > 247) {
                    startAddress = 1;
                }
                BComponent comp = ((AccessDeviceModel)this.getManager().getModel()).newInstance(type, startAddress);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + startAddress)));
                ++startAddress;
            }
            return edit;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BAccessNetwork network = BAccessDeviceManager.this.getAccessNetwork();
            if (network.isDisabled() || network.isFault()) {
                throw new RuntimeException("Network is disabled or configured incorrectly");
            }
            try {
                Object[] learnEntries = BAccessDeviceManager.this.getLearn().getRoots();
                for (int i = 0; i < learnEntries.length; ++i) {
                    BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)learnEntries[i];
                    entry.stopWink();
                }
            }
            catch (Exception learnEntries) {
                // empty catch block
            }
            super.doDiscover(cx);
            BAccessNetwork accessNet = BAccessDeviceManager.this.getAccessNetwork();
            BOrd ordToDiscoveryJob = accessNet.submitDeviceDiscoveryJob();
            BAccessDeviceManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            for (int i = 0; i < discovery.length; ++i) {
                ((BNrioLearnDeviceEntry)discovery[i]).stopWink();
            }
            return super.doAdd(discovery, cx);
        }

        public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) {
            BNrioLearnDeviceEntry discoverComp = (BNrioLearnDeviceEntry)discovery;
            BNrioDevice stationComp = (BNrioDevice)database;
            stationComp.setUid(discoverComp.getUid());
            stationComp.setDeviceType(discoverComp.getDeviceType());
            if (stationComp.getAddress() == 0) {
                stationComp.setAddress(discoverComp.getAddress());
            }
            try {
                this.doDiscover(cx);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        class Wink
        extends MgrController.MgrCommand {
            Wink(BWidget owner, boolean enable, String label) {
                super(owner, (Lexicon)lexicon, label);
                this.setEnabled(enable);
            }

            public CommandArtifact doInvoke() throws Exception {
                return AccessDeviceController.this.doWink();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class AddOfflineHardware
        extends MgrController.MgrCommand {
            AddOfflineHardware(BWidget owner) {
                super(owner, (Lexicon)lexicon, "addOfflineHardware");
            }

            public CommandArtifact doInvoke() throws Exception {
                return AccessDeviceController.this.doAddOfflineHardware();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class InstallFirmware
        extends MgrController.MgrCommand {
            InstallFirmware(BWidget owner) {
                super(owner, (Lexicon)lexicon, "upgradeFirmware");
            }

            public CommandArtifact doInvoke() throws Exception {
                return AccessDeviceController.this.doInstallFirmware();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }
    }

    class AccessDeviceLearn
    extends MgrLearn {
        AccessDeviceLearn() {
            super((BAbstractManager)BAccessDeviceManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNrioLearnDeviceEntry.address), new MgrColumn.Prop(BNrioLearnDeviceEntry.deviceType), new BlobColumn(BNrioLearnDeviceEntry.uid, 0), new MgrColumn.Prop(BNrioLearnDeviceEntry.version), new MgrColumn.Prop(BNrioLearnDeviceEntry.usedBy)};
        }

        public BImage getIcon(Object dis) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)dis;
            if (BAccessDeviceManager.this.isThisDeviceValid(learnEntry)) {
                return stationIcon;
            }
            return stationIcon.getDisabledImage();
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)discovery;
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.baseBoardReader)) {
                return MgrTypeInfo.makeArray((Type)BBase2ReaderModule.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
                return MgrTypeInfo.makeArray((Type)BAccessInputOutputModule.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.io16)) {
                return MgrTypeInfo.makeArray((Type)BNrio16Module.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
                return MgrTypeInfo.makeArray((Type)BRemote2ReaderModule.TYPE);
            }
            return new MgrTypeInfo[0];
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)discovery;
            row.setDefaultName(learnEntry.getDeviceType().getTag() + learnEntry.getAddress());
            row.setCell(BAccessDeviceManager.this.colAddress, (BValue)BInteger.make((int)learnEntry.getAddress()));
            row.setCell(BAccessDeviceManager.this.colDevType, (BValue)learnEntry.getDeviceType());
            row.setCell(BAccessDeviceManager.this.colUid, (BValue)learnEntry.getUid());
        }

        public boolean isExisting(Object dis, BComponent comp) {
            try {
                BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)dis;
                if (learnEntry.isWinkActive()) {
                    return true;
                }
                BNrioDevice d = (BNrioDevice)comp;
                return d.getUid().equals((Object)learnEntry.getUid());
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean isMatchable(Object dis, BComponent db) {
            try {
                BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)dis;
                return entry.isMatchable(db);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BAccessLearnDevicesJob) {
                BAccessDeviceManager.this.updateLearnData();
            }
        }
    }

    class BlobColumn
    extends MgrColumn.Prop {
        BlobColumn(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BBlob) {
                byte[] temp = ((BBlob)value).copyBytes();
                byte[] bytes = new byte[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    bytes[temp.length - 1 - i] = temp[i];
                }
                return ByteArrayUtil.toHexString((byte[])bytes);
            }
            return super.toDisplayString(row, value, cx);
        }
    }

    public class AccessDeviceModel
    extends DeviceModel {
        AccessDeviceModel(BAccessDeviceManager mgr) {
            super((BDeviceManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BAccessDeviceManager.this.colName, BAccessDeviceManager.this.colDevType, BAccessDeviceManager.this.colStatus, BAccessDeviceManager.this.colEnable, BAccessDeviceManager.this.colHealth, BAccessDeviceManager.this.colAddress, BAccessDeviceManager.this.colUid, BAccessDeviceManager.this.colInsVer, BAccessDeviceManager.this.colAvaVer, BAccessDeviceManager.this.colDoors};
        }

        public BComponent newInstance(MgrTypeInfo type, int address) throws Exception {
            BNrioDevice device = (BNrioDevice)this.newInstance(type);
            device.setAddress(address);
            return device;
        }
    }
}

