/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.components;

import com.tridiumx.accessDriver.BAccessAuxOutput;
import com.tridiumx.accessDriver.enums.BReaderOutputEnum;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BReaderOutputConfig
extends BComponent {
    public static final Property auxType = BReaderOutputConfig.newProperty((int)0, (BValue)BReaderOutputEnum.inactive, null);
    public static final Property customTime = BReaderOutputConfig.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)200L)));
    public static final Property initialBursts = BReaderOutputConfig.newProperty((int)0, (int)2, null);
    public static final Property currentBursts = BReaderOutputConfig.newProperty((int)4, (int)-1, null);
    public static final Property burstOffTime = BReaderOutputConfig.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)200L)));
    public static final Type TYPE = Sys.loadType(BReaderOutputConfig.class);
    public static BReaderOutputConfig active = new BReaderOutputConfig(BReaderOutputEnum.active);
    public static BReaderOutputConfig auto = new BReaderOutputConfig(BReaderOutputEnum.auto);
    public static BReaderOutputConfig burstBeep = new BReaderOutputConfig(BReaderOutputEnum.burstBeep);
    public static BReaderOutputConfig burstFlash = new BReaderOutputConfig(BReaderOutputEnum.burstFlash);

    public BReaderOutputEnum getAuxType() {
        return (BReaderOutputEnum)this.get(auxType);
    }

    public void setAuxType(BReaderOutputEnum v) {
        this.set(auxType, (BValue)v, null);
    }

    public BRelTime getCustomTime() {
        return (BRelTime)this.get(customTime);
    }

    public void setCustomTime(BRelTime v) {
        this.set(customTime, (BValue)v, null);
    }

    public int getInitialBursts() {
        return this.getInt(initialBursts);
    }

    public void setInitialBursts(int v) {
        this.setInt(initialBursts, v, null);
    }

    public int getCurrentBursts() {
        return this.getInt(currentBursts);
    }

    public void setCurrentBursts(int v) {
        this.setInt(currentBursts, v, null);
    }

    public BRelTime getBurstOffTime() {
        return (BRelTime)this.get(burstOffTime);
    }

    public void setBurstOffTime(BRelTime v) {
        this.set(burstOffTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReaderOutputConfig() {
    }

    public BReaderOutputConfig(BReaderOutputEnum e) {
        this.setAuxType(e);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(auxType)) {
            if (this.getParent() instanceof BAccessAuxOutput) {
                BAccessAuxOutput aux = (BAccessAuxOutput)this.getParent();
                aux.initUnlockLink();
            }
        } else {
            super.changed(p, cx);
        }
    }

    public BRelTime getDuration(boolean on) {
        if (this.getAuxType().equals((Object)BReaderOutputEnum.unlockTime)) {
            return BRelTime.DEFAULT;
        }
        if (this.getAuxType().equals((Object)BReaderOutputEnum.burst) && !on) {
            return this.getBurstOffTime();
        }
        if (this.getAuxType().equals((Object)BReaderOutputEnum.burstFlash)) {
            return BRelTime.makeSeconds((int)1);
        }
        if (this.getAuxType().equals((Object)BReaderOutputEnum.burstBeep) && !on && BRelTime.makeSeconds((int)(this.getCurrentBursts() * 2)).compareTo((Object)this.getBurstOffTime()) < 0) {
            return BRelTime.makeSeconds((int)1);
        }
        if (this.getAuxType().equals((Object)BReaderOutputEnum.burstBeep) && !on && BRelTime.makeSeconds((int)(this.getCurrentBursts() * 2)).compareTo((Object)this.getBurstOffTime()) >= 0) {
            return BRelTime.makeSeconds((int)4);
        }
        return this.getCustomTime();
    }
}

