/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.messages.NrioMessageConst;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessRex;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BIAccessDriverService;
import com.tridiumx.accessDriver.BRexActivation;
import com.tridiumx.accessDriver.BTimedOverride;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.enums.BAutoRelockEnum;
import com.tridiumx.accessDriver.enums.BRexAuditEnum;
import com.tridiumx.accessDriver.enums.BUnlockScheduleEnum;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;

public class BAccessStrike
extends BBooleanWritable
implements NrioMessageConst,
BIValidator {
    public static final Property out = BAccessStrike.newProperty((int)-2147483381, (BValue)new BStatusBoolean(), null);
    public static final Property autoRelock = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)BAutoRelockEnum.relockOnDoorOpen, null);
    public static final Property scheduleOperation = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)BUnlockScheduleEnum.normal, null);
    public static final Property followStrike = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:StrikeChooserFE"));
    public static final Property unlockSchedule = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property overrideSchedule = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartOverrideScheduleLinkFE"));
    public static final Property scheduleOut = BAccessStrike.newProperty((int)1, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property sensorInput = BAccessStrike.newProperty((int)0, (BValue)new BStatusBoolean(), null);
    public static final Property unlockInput = BAccessStrike.newProperty((int)0, (BValue)new BStatusBoolean(), null);
    public static final Property accessUnlockTime = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    public static final Property proxyExt = BAccessStrike.newProperty((int)-2147483584, (BValue)new BNullProxyExt(), null);
    public static final Property logExitRequests = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (BValue)BRexAuditEnum.none, null);
    public static final Property logScheduleActivity = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (boolean)true, null);
    public static final Property threatLevelGroup = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (int)-1, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ThreatLevelGroupLinkFE"));
    public static final Property scheduleLockdownThreatLevel = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE")), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("none"))));
    public static final Property unlockThreatLevel = BAccessStrike.newProperty((int)Integer.MIN_VALUE, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE")), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("none"))), (BFacets)BFacets.make((String)"validator", (String)"accessDriver:AccessStrike")));
    public static final Action accessValidated = BAccessStrike.newAction((int)0, (BValue)new BValidationInfo(), null);
    public static final Action exitRequest = BAccessStrike.newAction((int)0, (BValue)new BRexActivation(), null);
    public static final Action lockOutSchedule = BAccessStrike.newAction((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Action clearScheduleLockOut = BAccessStrike.newAction((int)0, null);
    public static final Action clearGrantedButNotUsed = BAccessStrike.newAction((int)4, null);
    public static final Action delayOpenAutoLockForDebounce = BAccessStrike.newAction((int)4, null);
    public static final Action delayCloseAutoLockForDebounce = BAccessStrike.newAction((int)4, null);
    public static final Action emergencyRexAuto = BAccessStrike.newAction((int)4, null);
    public static final Topic inhibitAlarm = BAccessStrike.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAccessStrike.class);
    private boolean lastAudit = false;
    private boolean lookingForDoorNotUsed = false;
    private boolean started = false;
    private boolean locked = true;
    private boolean open = false;
    private boolean scheduled = false;
    private boolean scheduleLinked = false;
    private boolean unlockOnFirstValidation = false;
    private boolean unlockAndLock = false;
    private Array validationInfos = new Array(BValidationInfo.class);
    private BRexActivation rexAudit = null;
    private boolean scheduleLockOut = false;
    private Clock.Ticket emergencyTicket;
    private Clock.Ticket emergencyRexTicket;
    private Clock.Ticket clearGrantedButNotUsedTicket;
    private Clock.Ticket scheduleLockOutTicket;
    private Clock.Ticket delayOpenAutoLockForDebounceTicket;
    private Clock.Ticket delayCloseAutoLockForDebounceTicket;
    private int threatLevel = -1;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BAutoRelockEnum getAutoRelock() {
        return (BAutoRelockEnum)this.get(autoRelock);
    }

    public void setAutoRelock(BAutoRelockEnum v) {
        this.set(autoRelock, (BValue)v, null);
    }

    public BUnlockScheduleEnum getScheduleOperation() {
        return (BUnlockScheduleEnum)this.get(scheduleOperation);
    }

    public void setScheduleOperation(BUnlockScheduleEnum v) {
        this.set(scheduleOperation, (BValue)v, null);
    }

    public BStatusBoolean getFollowStrike() {
        return (BStatusBoolean)this.get(followStrike);
    }

    public void setFollowStrike(BStatusBoolean v) {
        this.set(followStrike, (BValue)v, null);
    }

    public BStatusBoolean getUnlockSchedule() {
        return (BStatusBoolean)this.get(unlockSchedule);
    }

    public void setUnlockSchedule(BStatusBoolean v) {
        this.set(unlockSchedule, (BValue)v, null);
    }

    public BStatusBoolean getOverrideSchedule() {
        return (BStatusBoolean)this.get(overrideSchedule);
    }

    public void setOverrideSchedule(BStatusBoolean v) {
        this.set(overrideSchedule, (BValue)v, null);
    }

    public BStatusBoolean getScheduleOut() {
        return (BStatusBoolean)this.get(scheduleOut);
    }

    public void setScheduleOut(BStatusBoolean v) {
        this.set(scheduleOut, (BValue)v, null);
    }

    public BStatusBoolean getSensorInput() {
        return (BStatusBoolean)this.get(sensorInput);
    }

    public void setSensorInput(BStatusBoolean v) {
        this.set(sensorInput, (BValue)v, null);
    }

    public BStatusBoolean getUnlockInput() {
        return (BStatusBoolean)this.get(unlockInput);
    }

    public void setUnlockInput(BStatusBoolean v) {
        this.set(unlockInput, (BValue)v, null);
    }

    public BRelTime getAccessUnlockTime() {
        return (BRelTime)this.get(accessUnlockTime);
    }

    public void setAccessUnlockTime(BRelTime v) {
        this.set(accessUnlockTime, (BValue)v, null);
    }

    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    public void setProxyExt(BAbstractProxyExt v) {
        this.set(proxyExt, (BValue)v, null);
    }

    public BRexAuditEnum getLogExitRequests() {
        return (BRexAuditEnum)this.get(logExitRequests);
    }

    public void setLogExitRequests(BRexAuditEnum v) {
        this.set(logExitRequests, (BValue)v, null);
    }

    public boolean getLogScheduleActivity() {
        return this.getBoolean(logScheduleActivity);
    }

    public void setLogScheduleActivity(boolean v) {
        this.setBoolean(logScheduleActivity, v, null);
    }

    public int getThreatLevelGroup() {
        return this.getInt(threatLevelGroup);
    }

    public void setThreatLevelGroup(int v) {
        this.setInt(threatLevelGroup, v, null);
    }

    public int getScheduleLockdownThreatLevel() {
        return this.getInt(scheduleLockdownThreatLevel);
    }

    public void setScheduleLockdownThreatLevel(int v) {
        this.setInt(scheduleLockdownThreatLevel, v, null);
    }

    public int getUnlockThreatLevel() {
        return this.getInt(unlockThreatLevel);
    }

    public void setUnlockThreatLevel(int v) {
        this.setInt(unlockThreatLevel, v, null);
    }

    public void accessValidated(BValidationInfo event) {
        this.invoke(accessValidated, (BValue)event, null);
    }

    public void exitRequest(BRexActivation event) {
        this.invoke(exitRequest, (BValue)event, null);
    }

    public void lockOutSchedule(BRelTime event) {
        this.invoke(lockOutSchedule, (BValue)event, null);
    }

    public void clearScheduleLockOut() {
        this.invoke(clearScheduleLockOut, null, null);
    }

    public void clearGrantedButNotUsed() {
        this.invoke(clearGrantedButNotUsed, null, null);
    }

    public void delayOpenAutoLockForDebounce() {
        this.invoke(delayOpenAutoLockForDebounce, null, null);
    }

    public void delayCloseAutoLockForDebounce() {
        this.invoke(delayCloseAutoLockForDebounce, null, null);
    }

    public void emergencyRexAuto() {
        this.invoke(emergencyRexAuto, null, null);
    }

    public void fireInhibitAlarm(BRelTime event) {
        this.fire(inhibitAlarm, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAccessStrike() {
    }

    public boolean getScheduled() {
        if (!this.getOverrideSchedule().getStatus().isNull()) {
            return this.getOverrideSchedule().getValue();
        }
        return this.getUnlockSchedule().getValue();
    }

    public BStatusBoolean getScheduledResult() {
        return new BStatusBoolean(this.getScheduled());
    }

    public void setScheduleOut() {
        BStatusBoolean result = this.getScheduledResult();
        this.setScheduleOut((BStatusBoolean)result.newCopy());
    }

    public void started() throws Exception {
        super.started();
        this.locked = !this.getOut().getValue();
        this.open = this.getSensorInput().getValue();
        this.scheduled = this.getScheduled();
        if (this.scheduled) {
            this.setScheduleOut();
            this.setIn16(this.getScheduledResult());
            this.linkScheduledInhibits();
            if (this.getScheduleOperation() == BUnlockScheduleEnum.followAnotherStrike) {
                this.updateFollowStrike();
            }
        }
        this.scheduleLinked = !this.getScheduleOut().getStatus().isNull();
        this.lastAudit = this.getOut().getValue();
        boolean bl = this.unlockOnFirstValidation = this.scheduled && this.getScheduleOperation() != BUnlockScheduleEnum.normal && this.getScheduleOperation() != BUnlockScheduleEnum.followAnotherStrike;
        if (this.unlockOnFirstValidation) {
            this.getIn15().setValue(false);
            this.getIn15().setStatusNull(false);
            this.unlinkScheduledInhibits();
        }
        this.getIn14().setValue(false);
        this.getIn14().setStatusNull(true);
        this.getIn14().setStatusOverridden(false);
        this.proxyInit();
        this.started = true;
        if (this.isEmergency()) {
            this.emergencyAuto();
        }
        this.setFlags((Slot)proxyExt, this.getFlags((Slot)proxyExt) | Integer.MIN_VALUE);
        this.threatLevel = this.getThreatLevelGroup();
        this.updateThreatLevel();
    }

    public void proxyInit() {
        if (this.getProxyExt() instanceof BAccessProxyExt) {
            return;
        }
        boolean enabled = false;
        int instance = 0;
        if (this.getParent() instanceof BAccessDoor) {
            instance = ((BAccessDoor)this.getParent()).getInitialAddress((BBooleanPoint)this);
        }
        if (instance > 0) {
            enabled = true;
        }
        String locked = this.getLexicon().getText("strike.status.locked");
        String unlocked = this.getLexicon().getText("strike.status.unlocked");
        this.getFallback().setValue(false);
        this.getFallback().setStatusNull(false);
        AccessPointDeviceExtUtil.initBooleanProxyExt((BBooleanPoint)this, instance, true, false, unlocked, locked, false, false, false, enabled, "");
        this.initLinks();
    }

    public void initLinks() {
        if (this.getParent() instanceof BAccessDoor) {
            BLink link;
            LinkCheck check;
            BAccessDoor door = (BAccessDoor)this.getParent();
            BAccessReader[] readers = (BAccessReader[])door.getChildren(BAccessReader.class);
            for (int i = 0; i < readers.length; ++i) {
                LinkCheck check2 = this.checkLink(readers[i], (Slot)BAccessReader.accessValidated, (Slot)accessValidated, null);
                if (!check2.isValid()) continue;
                BLink link2 = this.makeLink(readers[i], (Slot)BAccessReader.accessValidated, (Slot)accessValidated, null);
                this.add(null, (BValue)link2);
            }
            BAccessRex[] rexs = door.getExitRequests();
            for (int i = 0; i < rexs.length; ++i) {
                check = this.checkLink((BComponent)rexs[i], (Slot)BAccessRex.exitRequest, (Slot)exitRequest, null);
                if (!check.isValid()) continue;
                link = this.makeLink((BComponent)rexs[i], (Slot)BAccessRex.exitRequest, (Slot)exitRequest, null);
                this.add(null, (BValue)link);
            }
            BAccessSdi sensor = door.getSensor();
            if (sensor != null) {
                check = this.checkLink((BComponent)sensor, (Slot)BAccessSdi.out, (Slot)sensorInput, null);
                if (check.isValid()) {
                    link = this.makeLink((BComponent)sensor, (Slot)BAccessSdi.out, (Slot)sensorInput, null);
                    this.add(null, (BValue)link);
                }
                if ((check = sensor.checkLink((BComponent)this, (Slot)inhibitAlarm, (Slot)BAccessSdi.inhibit, null)).isValid()) {
                    link = sensor.makeLink((BComponent)this, (Slot)inhibitAlarm, (Slot)BAccessSdi.inhibit, null);
                    sensor.add(null, (BValue)link);
                }
            }
        }
    }

    public BAccessStrike(BBooleanWritable oldStrike) {
        this.setFacets(oldStrike.getFacets());
        BAbstractProxyExt proxyExt = oldStrike.getProxyExt();
        oldStrike.setProxyExt((BAbstractProxyExt)new BNullProxyExt());
        this.setProxyExt(proxyExt);
        this.getFallback().setValue(false);
        this.getFallback().setStatusNull(false);
    }

    public void doExitRequest(BRexActivation rexActivation) {
        BRelTime time = rexActivation.getTime().abs();
        if (time.equals((Object)BRelTime.DEFAULT)) {
            time = this.getAccessUnlockTime();
        }
        this.fire(inhibitAlarm, (BValue)time, null);
        if (rexActivation.getUnlock()) {
            this.rexAudit = null;
            BOverride override = new BOverride();
            override.setDuration(time);
            if (time.equals((Object)BTimedOverride.cancelTime)) {
                if (!rexActivation.getIsManualOverride()) {
                    this.cancelTimer(this.emergencyRexTicket);
                    this.getIn2().setStatusOverridden(false);
                    this.getIn2().setStatusNull(true);
                    this.getIn2().setValue(false);
                    override.setDuration(this.getAccessUnlockTime());
                } else if (this.isEmergency()) {
                    this.cancelTimer(this.emergencyTicket);
                    this.doEmergencyAuto();
                }
                if (!this.isEmergency()) {
                    this.invoke(active, (BValue)override, null);
                }
                if (rexActivation.getAuthorization().length() > 0) {
                    this.accessAudit(rexActivation.getAuthorization(), BBadgeActivity.canceled, BAccessNetwork.lex.getText("overrideAuthorization", new Object[]{BAccessNetwork.lex.getText("manualUnlock")}));
                }
                return;
            }
            if (rexActivation.getEmergencyOverride()) {
                this.invoke(emergencyActive, (BValue)override, null);
                this.emergencyTicket = this.setTimer(this.emergencyTicket, time, emergencyAuto);
            } else if (!rexActivation.getIsManualOverride() && !rexActivation.getStopEmergencyOverride()) {
                this.getIn2().setStatusOverridden(true);
                this.getIn2().setStatusNull(false);
                this.getIn2().setValue(true);
                this.emergencyRexTicket = this.setTimer(this.emergencyRexTicket, time, emergencyRexAuto);
            } else {
                this.invoke(active, (BValue)override, null);
            }
            if (rexActivation.getStopEmergencyOverride()) {
                this.cancelTimer(this.emergencyRexTicket);
                this.doEmergencyRexAuto();
            }
            if (this.getLogExitRequests() == BRexAuditEnum.opened) {
                this.rexAudit = rexActivation;
            } else {
                String details = "";
                BBadgeActivity activity = BBadgeActivity.exitRequest;
                if (rexActivation.getIsManualOverride()) {
                    activity = BBadgeActivity.manualOverride;
                    details = BAccessNetwork.lex.getText("overrideAuthorization", new Object[]{BAccessNetwork.lex.getText("manualUnlock")});
                }
                this.accessAudit(rexActivation.getAuthorization(), activity, details);
            }
        } else if (!(this.open || this.getLogExitRequests() != BRexAuditEnum.unlockedOrOpened && this.getLogExitRequests() != BRexAuditEnum.opened)) {
            this.rexAudit = rexActivation;
        }
    }

    public void doLockOutSchedule(BRelTime time, Context cx) {
        if (time.getMillis() <= 0L) {
            return;
        }
        this.scheduleLockOut = true;
        this.getIn14().setValue(false);
        this.getIn14().setStatusNull(false);
        this.getIn14().setStatusOverridden(true);
        this.unlinkScheduledInhibits();
        this.setTimer(this.scheduleLockOutTicket, time, clearScheduleLockOut);
        String authorization = "";
        if (cx != null && cx.getUser() != null) {
            authorization = BAccessNetwork.lex.getText("userAuthorization", new Object[]{cx.getUser()});
        }
        this.accessAudit(authorization, BBadgeActivity.manualOverride, BAccessNetwork.lex.getText("scheduleAuthorization", new Object[]{BAccessNetwork.lex.getText("manualLock")}));
    }

    public void doClearScheduleLockOut(Context cx) {
        this.scheduleLockOut = false;
        this.getIn14().setValue(false);
        this.getIn14().setStatusNull(true);
        this.getIn14().setStatusOverridden(false);
        if (!this.unlockOnFirstValidation) {
            this.linkScheduledInhibits();
        }
        if (cx != null && cx.getUser() != null) {
            String authorization = BAccessNetwork.lex.getText("userAuthorization", new Object[]{cx.getUser()});
            this.accessAudit(authorization, BBadgeActivity.canceled, BAccessNetwork.lex.getText("overrideAuthorization", new Object[]{BAccessNetwork.lex.getText("manualLock")}));
        }
    }

    public boolean isEmergency() {
        return !this.getIn1().getStatus().isNull();
    }

    public boolean isRexLevelEmergency() {
        return !this.getIn2().getStatus().isNull();
    }

    public void doAccessValidated(BValidationInfo validationInfo) {
        if (this.unlockOnFirstValidation) {
            this.getIn15().setValue(false);
            this.getIn15().setStatusNull(true);
            this.unlockOnFirstValidation = false;
            if (!this.scheduleLockOut) {
                this.linkScheduledInhibits();
                this.auditScheduleChange(this.getScheduleOut().getValue());
            }
        } else if (!this.unlockAndLock && !this.getScheduleOut().getStatus().isNull() && this.getScheduleOut().getValue() && this.getScheduleOperation().equals((Object)BUnlockScheduleEnum.unlockAndRelock)) {
            this.getIn15().setValue(false);
            this.getIn15().setStatusNull(false);
            this.unlockAndLock = true;
            this.unlinkScheduledInhibits();
            if (!this.open) {
                this.fire(inhibitAlarm, (BValue)this.getAccessUnlockTime(), null);
            }
            this.auditScheduleChange(false);
        } else if (this.unlockAndLock && !this.getScheduleOut().getStatus().isNull() && this.getScheduleOut().getValue() && this.getScheduleOperation().equals((Object)BUnlockScheduleEnum.unlockAndRelock)) {
            this.getIn15().setValue(false);
            this.getIn15().setStatusNull(true);
            this.unlockAndLock = false;
            if (!this.scheduleLockOut) {
                this.linkScheduledInhibits();
                this.auditScheduleChange(true);
            }
        }
        if (!this.open) {
            boolean bl = this.lookingForDoorNotUsed = !this.scheduled;
            if (validationInfo.getReaderHandle().length() > 0) {
                this.validationInfos.add((Object)validationInfo);
                if (this.scheduled) {
                    this.clearGrantedButNotUsedTicket = this.setTimer(this.clearGrantedButNotUsedTicket, this.getAccessUnlockTime(), clearGrantedButNotUsed);
                }
            }
        } else {
            BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
            service.badgeHolderEntered(validationInfo);
            this.lookingForDoorNotUsed = false;
        }
        BOverride override = new BOverride();
        override.setDuration(this.getAccessUnlockTime());
        if (!this.scheduled) {
            if (this.open) {
                this.fire(inhibitAlarm, (BValue)BRelTime.DEFAULT, null);
            } else {
                this.fire(inhibitAlarm, (BValue)this.getAccessUnlockTime(), null);
            }
        }
        this.invoke(active, (BValue)override, null);
    }

    public void doClearGrantedButNotUsed() {
        this.validationInfos.clear();
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == out) {
            return BAccessNetwork.lex.getText("AccessStrike.out");
        }
        if (slot == proxyExt) {
            return BAccessNetwork.lex.getText("AccessStrike.proxyExt");
        }
        return super.getDisplayName(slot, cx);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || !this.started) {
            return;
        }
        if (p.equals(out)) {
            boolean newLocked;
            boolean bl = newLocked = !this.getOut().getValue();
            if (newLocked != this.locked) {
                this.locked = newLocked;
                if (this.locked && this.lookingForDoorNotUsed) {
                    if (this.getParent() instanceof BAccessDoor && ((BAccessDoor)this.getParent()).getSensor() != null) {
                        BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
                        for (int i = 0; i < this.validationInfos.size(); ++i) {
                            BValidationInfo validationInfo = (BValidationInfo)((Object)this.validationInfos.get(i));
                            service.badgeHolderDidNotEnter(validationInfo);
                        }
                    }
                    this.validationInfos.clear();
                }
            }
        } else if (p.equals(scheduleOperation)) {
            if (this.getScheduleOperation() == BUnlockScheduleEnum.normal) {
                this.getIn15().setValue(false);
                this.getIn15().setStatusNull(true);
                if (this.unlockOnFirstValidation && !this.scheduleLockOut) {
                    this.linkScheduledInhibits();
                }
            }
            this.updateFollowStrike();
            if (this.unlockAndLock && this.getScheduleOperation() != BUnlockScheduleEnum.unlockAndRelock) {
                this.getIn15().setValue(false);
                this.getIn15().setStatusNull(true);
                this.unlockAndLock = false;
                if (this.scheduled && !this.scheduleLockOut) {
                    this.linkScheduledInhibits();
                }
            }
            this.unlockOnFirstValidation = this.unlockOnFirstValidation && this.getScheduleOperation() != BUnlockScheduleEnum.normal && this.getScheduleOperation() != BUnlockScheduleEnum.followAnotherStrike ? this.scheduled : false;
        } else if (p.equals(sensorInput)) {
            boolean newOpen = this.getSensorInput().getValue();
            if (newOpen != this.open) {
                this.open = newOpen;
                if (this.open) {
                    if (this.getAutoRelock().equals((Object)BAutoRelockEnum.relockOnDoorOpen) && (BAccessStrike.getSensor((BComponent)this) == null || BAccessStrike.getSensor((BComponent)this).getDebounceTime().equals((Object)BRelTime.DEFAULT))) {
                        this.invoke(auto, null);
                    }
                    this.lookingForDoorNotUsed = false;
                    BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
                    if (this.rexAudit != null) {
                        String details = "";
                        BBadgeActivity activity = BBadgeActivity.exitRequest;
                        if (this.rexAudit.getIsManualOverride()) {
                            activity = BBadgeActivity.manualOverride;
                            details = BAccessNetwork.lex.getText("overrideAuthorization", new Object[]{BAccessNetwork.lex.getText("manualUnlock")});
                        }
                        this.accessAudit(this.rexAudit.getAuthorization(), activity, details);
                        this.rexAudit = null;
                    }
                    for (int i = 0; i < this.validationInfos.size(); ++i) {
                        BValidationInfo validationInfo = (BValidationInfo)((Object)this.validationInfos.get(i));
                        service.badgeHolderEntered(validationInfo);
                    }
                    this.validationInfos.clear();
                } else if (BAccessStrike.getSensor((BComponent)this) == null && this.getAutoRelock().equals((Object)BAutoRelockEnum.relockOnDoorClose)) {
                    this.invoke(auto, null);
                }
            }
        } else if (p.equals(in1)) {
            if (this.isEmergency() && this.getIn1().getValue()) {
                this.linkEmergencyScheduledInhibits();
            } else {
                this.unlinkEmergencyScheduledInhibits();
            }
        } else if (p.equals(in2)) {
            if (this.isRexLevelEmergency() && this.getIn2().getValue()) {
                this.linkRexEmergencyScheduledInhibits();
            } else {
                this.unlinkRexEmergencyScheduledInhibits();
            }
        } else if (p.equals(unlockSchedule)) {
            this.setScheduleOut();
        } else if (p.equals(overrideSchedule)) {
            this.setScheduleOut();
        } else if (p.equals(scheduleOut)) {
            boolean newScheduleLinked;
            boolean newScheduled = this.getScheduleOut().getValue();
            boolean bl = newScheduleLinked = !this.getScheduleOut().getStatus().isNull();
            if (newScheduleLinked != this.scheduleLinked) {
                this.scheduleLinked = newScheduleLinked;
                if (this.scheduleLinked) {
                    this.auditScheduleChange(false);
                }
            }
            if (newScheduled != this.scheduled || this.getScheduleOut().getStatus().isNull()) {
                this.scheduled = newScheduled;
                if (this.scheduled && !this.getScheduleOut().getStatus().isNull()) {
                    this.setIn16((BStatusBoolean)this.getScheduleOut().newCopy());
                    if (this.getScheduleOperation() != BUnlockScheduleEnum.normal && this.getScheduleOperation() != BUnlockScheduleEnum.followAnotherStrike) {
                        this.getIn15().setValue(false);
                        this.getIn15().setStatusNull(false);
                        this.unlockOnFirstValidation = true;
                        this.auditScheduleChange(false);
                    } else {
                        if (!this.scheduleLockOut) {
                            this.linkScheduledInhibits();
                        }
                        if (this.getScheduleOperation() == BUnlockScheduleEnum.followAnotherStrike) {
                            this.updateFollowStrike();
                        } else {
                            this.auditScheduleChange(this.getScheduleOut().getValue());
                        }
                    }
                } else {
                    this.setIn16((BStatusBoolean)this.getScheduleOut().newCopy());
                    this.unlinkScheduledInhibits();
                    this.getIn15().setValue(false);
                    this.getIn15().setStatusNull(true);
                    this.unlockAndLock = false;
                    this.unlockOnFirstValidation = false;
                    if (!this.getScheduleOut().getStatus().isNull()) {
                        this.auditScheduleChange(false);
                    }
                }
            }
        } else if (p.equals(followStrike)) {
            this.updateFollowStrike();
        } else if (p.equals(threatLevelGroup)) {
            if (this.getThreatLevelGroup() != this.threatLevel) {
                this.threatLevel = this.getThreatLevelGroup();
                this.updateThreatLevel();
            }
        } else if (p.equals(scheduleLockdownThreatLevel)) {
            this.updateThreatLevel();
        } else if (p.equals(unlockThreatLevel)) {
            try {
                this.validate(this.getUnlockThreatLevel(), this.getScheduleLockdownThreatLevel(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setUnlockThreatLevel(-1);
            }
            this.updateThreatLevel();
        }
    }

    public void doDelayOpenAutoLockForDebounce() {
        if (!this.open) {
            return;
        }
        this.invoke(auto, null);
        this.cancelTimer(this.delayOpenAutoLockForDebounceTicket);
    }

    public void doDelayCloseAutoLockForDebounce() {
        if (this.open) {
            return;
        }
        this.invoke(auto, null);
        this.cancelTimer(this.delayOpenAutoLockForDebounceTicket);
    }

    private void updateThreatLevel() {
        if (this.threatLevel == -1) {
            this.getIn12().setValue(false);
            this.getIn12().setStatusNull(true);
            return;
        }
        if (this.threatLevel >= this.getScheduleLockdownThreatLevel() && this.getScheduleLockdownThreatLevel() != -1) {
            this.getIn12().setValue(false);
            this.getIn12().setStatusNull(false);
        } else if (this.threatLevel <= this.getUnlockThreatLevel() && this.getUnlockThreatLevel() != -1) {
            this.getIn12().setValue(true);
            this.getIn12().setStatusNull(false);
        } else {
            this.getIn12().setValue(false);
            this.getIn12().setStatusNull(true);
        }
    }

    private void accessAudit(String authorization, BBadgeActivity activity, String details) {
        if (BBadgeActivity.exitRequest == activity && this.getLogExitRequests() == BRexAuditEnum.none) {
            return;
        }
        try {
            BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
            service.accessAudit(this.getParent().asComponent(), activity, authorization, details, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditScheduleChange(boolean granted) {
        BAccessStrike bAccessStrike = this;
        synchronized (bAccessStrike) {
            if (granted == this.lastAudit) {
                return;
            }
            this.lastAudit = granted;
        }
        if (!this.getLogScheduleActivity()) {
            return;
        }
        try {
            BLink link;
            if (this.getLinks((Slot)overrideSchedule).length > 0 && this.getLinks((Slot)overrideSchedule)[0].isActive() && !this.getOverrideSchedule().getStatus().isNull()) {
                link = this.getLinks((Slot)overrideSchedule)[0];
                if (this.get(link.getTargetSlotName()).equivalent((Object)link.getSourceComponent().get(link.getSourceSlotName()))) {
                    String description = BAccessNetwork.lex.getText("overrideScheduleAuthorization", new Object[]{this.getOverrideSchedule().getValue() ? this.getScheduleOperation().getDisplayTag(null) : BAccessNetwork.lex.getText("inactive")});
                    String scheduleName = this.getLinks((Slot)overrideSchedule)[0].getSourceComponent().getDisplayName(null);
                    BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
                    service.accessAudit(this.getParent().asComponent(), BBadgeActivity.manualOverride, scheduleName, description, granted);
                }
            } else if (this.getLinks((Slot)unlockSchedule).length > 0 && this.getLinks((Slot)unlockSchedule)[0].isActive() && !this.getUnlockSchedule().getStatus().isNull() && this.get((link = this.getLinks((Slot)unlockSchedule)[0]).getTargetSlotName()).equivalent((Object)link.getSourceComponent().get(link.getSourceSlotName()))) {
                String description = BAccessNetwork.lex.getText("scheduleAuthorization", new Object[]{this.getUnlockSchedule().getValue() ? this.getScheduleOperation().getDisplayTag(null) : BAccessNetwork.lex.getText("inactive")});
                String scheduleName = this.getLinks((Slot)unlockSchedule)[0].getSourceComponent().getDisplayName(null);
                BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
                service.accessAudit(this.getParent().asComponent(), BBadgeActivity.manualOverride, scheduleName, description, granted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void linkScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)inhibitAlarm);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            LinkCheck check = sensor.checkLink((BComponent)this, (Slot)scheduleOut, (Slot)BAccessSdi.unlockSchedule, null);
            if (!check.isValid() || !(sensor instanceof BAccessSdi) || sensor == null) continue;
            BLink bLink = sensor.makeLink((BComponent)this, (Slot)scheduleOut, (Slot)BAccessSdi.unlockSchedule, null);
            sensor.add(null, (BValue)bLink);
        }
    }

    private void unlinkScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)scheduleOut);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            if (!(sensor instanceof BAccessSdi) || sensor == null) continue;
            sensor.remove(knobs[i].getLink().getName());
        }
    }

    private void linkEmergencyScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)inhibitAlarm);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            LinkCheck check = sensor.checkLink((BComponent)this, (Slot)in1, (Slot)BAccessSdi.unlockOverride, null);
            if (!check.isValid() || !(sensor instanceof BAccessSdi) || sensor == null) continue;
            BLink bLink = sensor.makeLink((BComponent)this, (Slot)in1, (Slot)BAccessSdi.unlockOverride, null);
            sensor.add(null, (BValue)bLink);
        }
    }

    private void unlinkEmergencyScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)in1);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            if (!(sensor instanceof BAccessSdi) || sensor == null) continue;
            sensor.remove(knobs[i].getLink().getName());
        }
    }

    private void linkRexEmergencyScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)inhibitAlarm);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            LinkCheck check = sensor.checkLink((BComponent)this, (Slot)in2, (Slot)BAccessSdi.unlockRexOverride, null);
            if (!check.isValid() || !(sensor instanceof BAccessSdi) || sensor == null) continue;
            BLink bLink = sensor.makeLink((BComponent)this, (Slot)in2, (Slot)BAccessSdi.unlockRexOverride, null);
            sensor.add(null, (BValue)bLink);
        }
    }

    private void unlinkRexEmergencyScheduledInhibits() {
        Knob[] knobs = this.getKnobs((Slot)in2);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent sensor = knobs[i].getTargetComponent();
            if (!(sensor instanceof BAccessSdi) || sensor == null) continue;
            sensor.remove(knobs[i].getLink().getName());
        }
    }

    public void doEmergencyRexAuto() {
        this.getIn2().setStatusOverridden(false);
        this.getIn2().setStatusNull(true);
        this.getIn2().setValue(false);
    }

    private void updateFollowStrike() {
        if (this.scheduled && this.getScheduleOperation() == BUnlockScheduleEnum.followAnotherStrike) {
            this.getIn15().setValue(false);
            this.getIn15().setStatusNull(true);
            if (this.getScheduleOut().getStatus().isValid() && this.getFollowStrike().getStatus().isValid() && this.getScheduleOut().getValue() && this.getFollowStrike().getValue()) {
                this.setIn16(new BStatusBoolean(true));
                this.auditScheduleChange(true);
                this.linkScheduledInhibits();
            } else {
                this.setIn16(new BStatusBoolean(false));
                this.auditScheduleChange(false);
                this.unlinkScheduledInhibits();
            }
        } else if (this.scheduled) {
            this.setIn16((BStatusBoolean)this.getScheduleOut().newCopy());
            this.auditScheduleChange(this.getScheduleOut().getValue());
        }
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        this.cancelTimer(ticket);
        return Clock.schedule((BComponent)this, (BRelTime)time.abs(), (Action)action, null);
    }

    private void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
        ticket = null;
    }

    public static boolean isOpenDebounceInEffect(BComponent c) {
        BAccessDoor door;
        BAccessSdi sensor;
        if (c.getParent() instanceof BAccessDoor && (sensor = (door = (BAccessDoor)c.getParent()).getSensor()) != null) {
            return sensor.isOpenDebounceInEffect();
        }
        return false;
    }

    public static boolean isCloseDebounceInEffect(BComponent c) {
        BAccessDoor door;
        BAccessSdi sensor;
        if (c.getParent() instanceof BAccessDoor && (sensor = (door = (BAccessDoor)c.getParent()).getSensor()) != null) {
            return sensor.isCloseDebounceInEffect();
        }
        return false;
    }

    public static BRelTime getDebounceTime(BComponent c) {
        BAccessDoor door;
        BAccessSdi sensor;
        if (c.getParent() instanceof BAccessDoor && (sensor = (door = (BAccessDoor)c.getParent()).getSensor()) != null) {
            return sensor.getDebounceTime();
        }
        return BRelTime.DEFAULT;
    }

    public static BAccessSdi getSensor(BComponent c) {
        if (c.getParent() instanceof BAccessDoor) {
            BAccessDoor door = (BAccessDoor)c.getParent();
            BAccessSdi sensor = door.getSensor();
            return sensor;
        }
        return null;
    }

    public static BRelTime getAccessUnlockTime(BComponent c) {
        BAccessDoor door;
        BAccessStrike strike;
        if (c.getParent() instanceof BAccessDoor && (strike = (door = (BAccessDoor)c.getParent()).getStrike()) != null) {
            return strike.getAccessUnlockTime();
        }
        return (BRelTime)accessUnlockTime.getDefaultValue();
    }

    public void validate(BObject value, Context cx) throws CannotValidateException {
        if (cx instanceof OrdTarget && value instanceof BInteger) {
            OrdTarget target = (OrdTarget)cx;
            BAccessStrike strike = (BAccessStrike)target.getComponent();
            int unlockThreatLevel = ((BInteger)value).getInt();
            int lockdownThreatLevel = strike.getScheduleLockdownThreatLevel();
            this.validate(unlockThreatLevel, lockdownThreatLevel, cx);
        }
    }

    public void validate(int unlockThreatLevelInt, int lockdownThreatLevelInt, Context cx) throws CannotValidateException {
        if (unlockThreatLevelInt != -1 && lockdownThreatLevelInt != -1 && unlockThreatLevelInt >= lockdownThreatLevelInt) {
            throw new CannotValidateException("Schedule Lockdown Threat Level must be greater than Unlock Threat Level:" + lockdownThreatLevelInt + " <= " + unlockThreatLevelInt);
        }
    }
}

