/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.messages.NrioMessageConst;
import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessAuxOutput;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessRex;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.accessDriver.enums.BAutoRelockEnum;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAccessSdi
extends BBooleanPoint
implements NrioMessageConst {
    public static final Property out = BAccessSdi.newProperty((int)-2147483381, (BValue)new BStatusBoolean(), null);
    public static final Property activeTimeLimit = BAccessSdi.newProperty((int)Integer.MIN_VALUE, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    public static final Property unlockSchedule = BAccessSdi.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property unlockOverride = BAccessSdi.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property unlockRexOverride = BAccessSdi.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property debounceTime = BAccessSdi.newProperty((int)Integer.MIN_VALUE, (BValue)BRelTime.makeSeconds((int)1), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)5))), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:DebounceTimeFE")), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property proxyExt = BAccessSdi.newProperty((int)64, (BValue)new BNullProxyExt(), null);
    public static final Action inhibit = BAccessSdi.newAction((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Action stopInhibit = BAccessSdi.newAction((int)0, null);
    public static final Action stopActiveLimitInhibit = BAccessSdi.newAction((int)0, null);
    public static final Action sendWarning = BAccessSdi.newAction((int)4, (BValue)new BAccessAuxOutput(), null);
    public static final Action stopInhibitAfterDebounce = BAccessSdi.newAction((int)4, null);
    public static final Action delayCloseForDebounce = BAccessSdi.newAction((int)4, null);
    public static final Action delayOpenForDebounce = BAccessSdi.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAccessSdi.class);
    private Clock.Ticket activeTooLongTicket;
    private Clock.Ticket normalTicket;
    private Clock.Ticket debounceTicket;
    private Clock.Ticket delayCloseTicket;
    private Clock.Ticket delayOpenTicket;
    private boolean open = false;
    private boolean scheduled = false;
    private boolean emergencyOverride = false;
    private boolean emergencyRexOverride = false;
    private Array warnings;
    private boolean justClosedForDebounce = false;
    private boolean justOpenedForDebounce = false;
    private boolean debounceWaitingOnClose = false;
    private boolean debounceWaitingOnOpen = false;
    private BAbsTime debounceOpened = BAbsTime.DEFAULT;
    private BAbsTime debounceClosed = BAbsTime.DEFAULT;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BRelTime getActiveTimeLimit() {
        return (BRelTime)this.get(activeTimeLimit);
    }

    public void setActiveTimeLimit(BRelTime v) {
        this.set(activeTimeLimit, (BValue)v, null);
    }

    public BStatusBoolean getUnlockSchedule() {
        return (BStatusBoolean)this.get(unlockSchedule);
    }

    public void setUnlockSchedule(BStatusBoolean v) {
        this.set(unlockSchedule, (BValue)v, null);
    }

    public BStatusBoolean getUnlockOverride() {
        return (BStatusBoolean)this.get(unlockOverride);
    }

    public void setUnlockOverride(BStatusBoolean v) {
        this.set(unlockOverride, (BValue)v, null);
    }

    public BStatusBoolean getUnlockRexOverride() {
        return (BStatusBoolean)this.get(unlockRexOverride);
    }

    public void setUnlockRexOverride(BStatusBoolean v) {
        this.set(unlockRexOverride, (BValue)v, null);
    }

    public BRelTime getDebounceTime() {
        return (BRelTime)this.get(debounceTime);
    }

    public void setDebounceTime(BRelTime v) {
        this.set(debounceTime, (BValue)v, null);
    }

    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    public void setProxyExt(BAbstractProxyExt v) {
        this.set(proxyExt, (BValue)v, null);
    }

    public void inhibit(BRelTime event) {
        this.invoke(inhibit, (BValue)event, null);
    }

    public void stopInhibit() {
        this.invoke(stopInhibit, null, null);
    }

    public void stopActiveLimitInhibit() {
        this.invoke(stopActiveLimitInhibit, null, null);
    }

    public void sendWarning(BAccessAuxOutput event) {
        this.invoke(sendWarning, (BValue)event, null);
    }

    public void stopInhibitAfterDebounce() {
        this.invoke(stopInhibitAfterDebounce, null, null);
    }

    public void delayCloseForDebounce() {
        this.invoke(delayCloseForDebounce, null, null);
    }

    public void delayOpenForDebounce() {
        this.invoke(delayOpenForDebounce, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.open = this.getOut().getValue();
        this.scheduled = this.getUnlockSchedule().getValue();
        this.emergencyOverride = this.getUnlockOverride().getValue();
        this.emergencyRexOverride = this.getUnlockRexOverride().getValue();
        this.proxyInit();
        if (this.scheduled || this.emergencyOverride || this.emergencyRexOverride) {
            BAccessSdi.alarmEnable(this.getIntrusionTimeoutExt());
        } else {
            BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
            BAccessSdi.alarmDisable(this.getIntrusionTimeoutExt());
        }
    }

    public void proxyInit() {
        if (this.getProxyExt() instanceof BAccessProxyExt && ((BAlarmSourceExt[])this.getChildren(BAlarmSourceExt.class)).length >= 4) {
            return;
        }
        boolean enabled = false;
        int instance = 0;
        if (this.getParent() instanceof BAccessDoor) {
            instance = ((BAccessDoor)this.getParent()).getInitialAddress(this);
        }
        if (instance > 0) {
            enabled = true;
        }
        String doorOpened = this.getLexicon().getText("door.status.opened");
        String doorClosed = this.getLexicon().getText("door.status.closed");
        AccessPointDeviceExtUtil.initBooleanProxyExt(this, instance, false, true, doorOpened, doorClosed, true, true, true, enabled, "%parent.parent.getDisplayName%.%parent.displayName%");
        this.initLinks();
    }

    public void initLinks() {
        BAccessDoor door;
        BAccessStrike strike;
        if (this.getParent() instanceof BAccessDoor && (strike = (door = (BAccessDoor)this.getParent()).getStrike()) != null) {
            BLink link;
            LinkCheck check = strike.checkLink((BComponent)this, (Slot)out, (Slot)BAccessStrike.sensorInput, null);
            if (check.isValid()) {
                link = strike.makeLink((BComponent)this, (Slot)out, (Slot)BAccessStrike.sensorInput, null);
                strike.add(null, (BValue)link);
            }
            if ((check = this.checkLink((BComponent)strike, (Slot)BAccessStrike.inhibitAlarm, (Slot)inhibit, null)).isValid()) {
                link = this.makeLink((BComponent)strike, (Slot)BAccessStrike.inhibitAlarm, (Slot)inhibit, null);
                this.add(null, (BValue)link);
            }
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == out) {
            return BAccessNetwork.lex.getText("AccessSdi.out");
        }
        if (slot == proxyExt) {
            return BAccessNetwork.lex.getText("AccessSdi.proxyExt");
        }
        if (slot == activeTimeLimit) {
            return BAccessNetwork.lex.getText("AccessSdi.activeTimeLimit");
        }
        return super.getDisplayName(slot, cx);
    }

    public void doDelayCloseForDebounce() {
        boolean newOpen = this.getOut().getValue();
        if (this.open && !newOpen) {
            this.open = newOpen;
            this.justClosed();
        }
    }

    public void doDelayOpenForDebounce() {
        BAccessDoor door;
        if (this.open && this.getParent() instanceof BAccessDoor && (door = (BAccessDoor)this.getParent()).getStrike() != null && door.getStrike().getAutoRelock().equals((Object)BAutoRelockEnum.relockOnDoorOpen)) {
            door.getStrike().invoke(BAccessStrike.auto, null);
        }
    }

    public void justClosed() {
        BAccessDoor door;
        this.cancelTimer(this.activeTooLongTicket);
        BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
        if (this.getParent() instanceof BAccessDoor && (door = (BAccessDoor)this.getParent()).getStrike() != null && door.getStrike().getAutoRelock().equals((Object)BAutoRelockEnum.relockOnDoorClose)) {
            door.getStrike().invoke(BAccessStrike.auto, null);
        }
        this.stopInhibit();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || !this.getOut().getStatus().isValid()) {
            return;
        }
        if (!this.scheduled && !this.emergencyOverride && !this.emergencyRexOverride && p.equals(out)) {
            boolean newOpen = this.getOut().getValue();
            if (newOpen != this.open) {
                if (!newOpen && this.isOpenDebounceInEffect()) {
                    if (this.delayCloseTicket != null && !this.delayCloseTicket.isExpired()) {
                        return;
                    }
                    this.delayCloseTicket = this.setTimer(this.delayCloseTicket, this.getDebounceTime(), delayCloseForDebounce);
                    return;
                }
                this.open = newOpen;
                if (this.open) {
                    BAccessStrike strike;
                    if (this.debounceWaitingOnOpen) {
                        BAccessDoor door;
                        this.debounceWaitingOnOpen = false;
                        this.justOpenedForDebounce = true;
                        this.debounceOpened = BAbsTime.now();
                        this.debounceWaitingOnClose = true;
                        if (this.getParent() instanceof BAccessDoor && (door = (BAccessDoor)this.getParent()).getStrike() != null && door.getStrike().getAutoRelock().equals((Object)BAutoRelockEnum.relockOnDoorOpen)) {
                            this.delayOpenTicket = this.setTimer(this.delayOpenTicket, this.getDebounceTime(), delayOpenForDebounce);
                        }
                    }
                    this.cancelTimer(this.normalTicket);
                    this.activeTooLongTicket = this.setTimer(this.activeTooLongTicket, this.getActiveTimeLimit(), stopActiveLimitInhibit);
                    if (this.getParent() instanceof BAccessDoor && (strike = ((BAccessDoor)this.getParent()).getStrike()) != null && strike.getAutoRelock() == BAutoRelockEnum.relockOnDoorClose && strike.getOut().getBoolean() && strike.getOut().getStatus().isOverridden()) {
                        strike.invoke(BBooleanWritable.active, (BValue)new BOverride(), null);
                    }
                } else {
                    if (this.delayCloseTicket != null && !this.delayCloseTicket.isExpired()) {
                        this.cancelTimer(this.delayCloseTicket);
                    }
                    if (this.debounceWaitingOnClose) {
                        this.debounceWaitingOnClose = false;
                        this.justClosedForDebounce = true;
                        this.debounceClosed = BAbsTime.now();
                    }
                    this.justClosed();
                }
            }
        } else if (p.equals(unlockSchedule) || p.equals(unlockOverride) || p.equals(unlockRexOverride)) {
            boolean newScheduled = this.getUnlockSchedule().getValue();
            boolean newEmergencyOverride = this.getUnlockOverride().getValue();
            boolean newEmergencyRexOverride = this.getUnlockRexOverride().getValue();
            boolean hasChange = false;
            if (newScheduled != this.scheduled) {
                this.scheduled = newScheduled;
                hasChange = true;
            }
            if (newEmergencyOverride != this.emergencyOverride) {
                this.emergencyOverride = newEmergencyOverride;
                hasChange = true;
            }
            if (newEmergencyRexOverride != this.emergencyRexOverride) {
                this.emergencyRexOverride = newEmergencyRexOverride;
                hasChange = true;
            }
            if (hasChange) {
                this.open = this.getOut().getValue();
                if (this.scheduled || this.emergencyOverride || this.emergencyRexOverride) {
                    this.cancelTimer(this.normalTicket);
                    this.cancelTimer(this.activeTooLongTicket);
                    BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
                    BAccessSdi.alarmDisable(this.getAlarmExt());
                    BAccessSdi.alarmEnable(this.getIntrusionTimeoutExt());
                } else {
                    if (this.open) {
                        BRelTime time = this.getActiveTimeLimit();
                        this.activeTooLongTicket = this.setTimer(this.activeTooLongTicket, time, stopActiveLimitInhibit);
                    } else {
                        BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
                        this.stopInhibit();
                    }
                    BAccessSdi.alarmDisable(this.getIntrusionTimeoutExt());
                }
            }
        }
    }

    public static void alarmEnable(BAlarmSourceExt ext) {
        if (ext == null) {
            return;
        }
        if (ext.getAlarmClass().toString().equals(BOffAlarmClass.getAlarmClassName())) {
            ext.setAlarmEnable(BAlarmTransitionBits.toNormal);
        } else {
            ext.setAlarmEnable(BAlarmTransitionBits.make((int)7));
        }
    }

    public static void alarmDisable(BAlarmSourceExt ext) {
        if (ext == null) {
            return;
        }
        ext.setAlarmEnable(BAlarmTransitionBits.toNormal);
    }

    public boolean isOpenDebounceInEffect() {
        return !this.getDebounceTime().equals((Object)BRelTime.DEFAULT) && BAbsTime.now().getMillis() - this.debounceOpened.getMillis() < this.getDebounceTime().getMillis();
    }

    public boolean isCloseDebounceInEffect() {
        return !this.getDebounceTime().equals((Object)BRelTime.DEFAULT) && BAbsTime.now().getMillis() - this.debounceClosed.getMillis() < this.getDebounceTime().getMillis();
    }

    public void doInhibit(BRelTime time) {
        if (this.scheduled || this.emergencyOverride || this.emergencyRexOverride) {
            return;
        }
        if (!this.getDebounceTime().equals((Object)BRelTime.DEFAULT)) {
            this.justClosedForDebounce = false;
            this.justOpenedForDebounce = false;
            this.debounceOpened = BAbsTime.DEFAULT;
            this.debounceClosed = BAbsTime.DEFAULT;
            this.debounceWaitingOnClose = this.open;
            boolean bl = this.debounceWaitingOnOpen = !this.open;
        }
        if (time != null && time.equals((Object)BRelTime.DEFAULT)) {
            time = this.getActiveTimeLimit();
            this.cancelTimer(this.normalTicket);
            this.activeTooLongTicket = this.setTimer(this.activeTooLongTicket, time, stopActiveLimitInhibit);
            BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
            BAccessSdi.alarmDisable(this.getAlarmExt());
            BAccessSdi.alarmEnable(this.getIntrusionTimeoutExt());
        } else if (!this.open) {
            this.cancelTimer(this.activeTooLongTicket);
            this.normalTicket = this.setTimer(this.normalTicket, time, stopInhibit);
            BAccessSdi.alarmDisable(this.getAlarmActiveLimitExt());
            BAccessSdi.alarmDisable(this.getAlarmExt());
            BAccessSdi.alarmEnable(this.getIntrusionTimeoutExt());
        }
    }

    public void doStopInhibit() {
        if (this.isExitRequestActive()) {
            this.normalTicket = this.setTimer(this.normalTicket, BAccessStrike.getAccessUnlockTime((BComponent)this), stopInhibit);
            return;
        }
        BAccessSdi.alarmDisable(this.getIntrusionTimeoutExt());
        if (!this.isCloseDebounceInEffect()) {
            BAccessSdi.alarmEnable(this.getAlarmExt());
            this.resetDebounceState();
        } else if (this.debounceTicket != null && !this.debounceTicket.isExpired()) {
            BAccessSdi.alarmEnable(this.getAlarmExt());
            this.cancelTimer(this.debounceTicket);
            this.resetDebounceState();
        } else {
            this.debounceTicket = this.setTimer(this.debounceTicket, this.getDebounceTime(), stopInhibitAfterDebounce);
        }
    }

    public void resetDebounceState() {
        this.justClosedForDebounce = false;
        this.justOpenedForDebounce = false;
        this.debounceWaitingOnClose = false;
        this.debounceWaitingOnOpen = false;
        this.debounceOpened = BAbsTime.DEFAULT;
        this.debounceClosed = BAbsTime.DEFAULT;
    }

    public void doStopInhibitAfterDebounce() {
        BAccessSdi.alarmEnable(this.getAlarmExt());
        this.cancelTimer(this.debounceTicket);
        this.resetDebounceState();
    }

    public void doStopActiveLimitInhibit() {
        BAccessSdi.alarmEnable(this.getAlarmActiveLimitExt());
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        return this.setTimer(ticket, time, action, null);
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action, BValue arg) {
        this.cancelTimer(ticket);
        if (action == stopActiveLimitInhibit) {
            this.setupWarnings(time);
        }
        return Clock.schedule((BComponent)this, (BRelTime)time.abs(), (Action)action, (BValue)arg);
    }

    private void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
        if (ticket == this.activeTooLongTicket) {
            this.cancelWarnings();
        }
        ticket = null;
    }

    private void cancelWarnings() {
        if (this.warnings != null) {
            boolean expired = false;
            for (int i = 0; i < this.warnings.size(); ++i) {
                Clock.Ticket ticket = (Clock.Ticket)this.warnings.get(i);
                if (ticket.isExpired()) {
                    expired = true;
                }
                if (ticket != null) {
                    ticket.cancel();
                }
                ticket = null;
            }
            this.warnings.clear();
            this.warnings = null;
            if (expired) {
                Knob[] knobs = this.getAlarmActiveLimitExt().getKnobs((Slot)BAlarmSourceExt.alarmState);
                for (int i = 0; i < knobs.length; ++i) {
                    BComponent c = knobs[i].getTargetComponent();
                    if (c == null || !(c instanceof BAccessAuxOutput)) continue;
                    BAccessAuxOutput aux = (BAccessAuxOutput)c;
                    aux.auto();
                }
            }
        }
    }

    private void setupWarnings(BRelTime time) {
        Array warnings = new Array(Clock.Ticket.class);
        Knob[] knobs = this.getAlarmActiveLimitExt().getKnobs((Slot)BAlarmSourceExt.alarmState);
        for (int i = 0; i < knobs.length; ++i) {
            BAccessAuxOutput aux;
            BRelTime warningTime;
            BComponent c = knobs[i].getTargetComponent();
            if (c == null || !(c instanceof BAccessAuxOutput) || (warningTime = (aux = (BAccessAuxOutput)c).getWarningTime()).getMillis() <= 0L) continue;
            BRelTime diff = BRelTime.make((long)(time.getMillis() - warningTime.getMillis()));
            Clock.Ticket warning = null;
            if (diff.getMillis() > 0L) {
                warning = this.setTimer(warning, diff, sendWarning, (BValue)aux);
                warnings.add((Object)warning);
                continue;
            }
            this.sendWarning(aux);
        }
        if (warnings.size() > 0) {
            this.warnings = warnings;
        }
    }

    public void doSendWarning(BAccessAuxOutput aux) {
        BOverride override = new BOverride();
        override.setDuration(aux.getWarningTime());
        aux.active(override);
    }

    public BAccessAlarmSourceExt getAlarmExt() {
        BAccessAlarmSourceExt[] exts = (BAccessAlarmSourceExt[])this.getChildren(BAccessAlarmSourceExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (exts[i].getSecurityAlgorithm() != BSecurityAlgorithmEnum.doorForced) continue;
            return exts[i];
        }
        throw new IllegalStateException("missing door forced alarm");
    }

    public BAccessAlarmSourceExt getAlarmActiveLimitExt() {
        BAccessAlarmSourceExt[] exts = (BAccessAlarmSourceExt[])this.getChildren(BAccessAlarmSourceExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (exts[i].getSecurityAlgorithm() != BSecurityAlgorithmEnum.doorHeldOpen) continue;
            return exts[i];
        }
        throw new IllegalStateException("missing door held open alarm");
    }

    public BAccessAlarmSourceExt getIntrusionTimeoutExt() {
        BAccessAlarmSourceExt[] exts = (BAccessAlarmSourceExt[])this.getChildren(BAccessAlarmSourceExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (exts[i].getSecurityAlgorithm() != BSecurityAlgorithmEnum.intrusionTimeout) continue;
            return exts[i];
        }
        throw new IllegalStateException("missing intrusionTimeout");
    }

    public boolean isExitRequestActive() {
        if (this.getParent() instanceof BAccessDoor) {
            BAccessDoor door = (BAccessDoor)this.getParent();
            BAccessRex[] rexes = door.getExitRequests();
            for (int i = 0; i < rexes.length; ++i) {
                BAccessRex rex = rexes[i];
                if (!rex.getInhibitSensor().getBoolean()) continue;
                return true;
            }
        }
        return false;
    }
}

