/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.messages.NrioMessageConst;
import com.tridiumx.accessDriver.AccessNetworkUpgrade;
import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BRexActivation;
import com.tridiumx.accessDriver.BTimedOverride;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BAccessRex
extends BBooleanPoint
implements NrioMessageConst {
    protected static Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BAccessReader.class).getModuleName());
    public static final Property out = BAccessRex.newProperty((int)-2147483381, (BValue)new BStatusBoolean(), null);
    public static final Property inhibitSensor = BAccessRex.newProperty((int)-2147483645, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)lex.getText("inhibitSensorTrue")), (BFacets)BFacets.make((String)"falseText", (String)lex.getText("inhibitSensorFalse"))));
    public static final Property requestableSchedule = BAccessRex.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusBoolean(true), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property proxyExt = BAccessRex.newProperty((int)-2147483584, (BValue)new BNullProxyExt(), null);
    public static final Property unlockOnExitRequest = BAccessRex.newProperty((int)Integer.MIN_VALUE, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)lex.getText("yes")), (BFacets)BFacets.make((String)"falseText", (String)lex.getText("no"))));
    public static final Property exitRequestTimeout = BAccessRex.newProperty((int)Integer.MIN_VALUE, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ExitRequestTimeoutFE")), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    public static final Property exitRequestTimeoutRelock = BAccessRex.newProperty((int)Integer.MIN_VALUE, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)lex.getText("yes")), (BFacets)BFacets.make((String)"falseText", (String)lex.getText("no"))));
    public static final Property exitRequestTimeoutAlarmExt = BAccessRex.newProperty((int)Integer.MIN_VALUE, (BValue)new BAccessAlarmSourceExt(BSecurityAlgorithmEnum.exitRequestTimeout), null);
    public static final Action stopInhibitSensor = BAccessRex.newAction((int)5, null);
    public static final Action exitRequestExpired = BAccessRex.newAction((int)5, null);
    public static final Topic exitRequest = BAccessRex.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAccessRex.class);
    private boolean activeOut = false;
    private boolean activeSchedule = false;
    private boolean effective = false;
    private boolean waitForSendRequest = false;
    private Clock.Ticket effectiveTicket = null;
    private Clock.Ticket exitRequestExpiredTicket = null;
    private BAbsTime accessUnlockExpiredTime;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getInhibitSensor() {
        return (BStatusBoolean)this.get(inhibitSensor);
    }

    public void setInhibitSensor(BStatusBoolean v) {
        this.set(inhibitSensor, (BValue)v, null);
    }

    public BStatusBoolean getRequestableSchedule() {
        return (BStatusBoolean)this.get(requestableSchedule);
    }

    public void setRequestableSchedule(BStatusBoolean v) {
        this.set(requestableSchedule, (BValue)v, null);
    }

    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    public void setProxyExt(BAbstractProxyExt v) {
        this.set(proxyExt, (BValue)v, null);
    }

    public boolean getUnlockOnExitRequest() {
        return this.getBoolean(unlockOnExitRequest);
    }

    public void setUnlockOnExitRequest(boolean v) {
        this.setBoolean(unlockOnExitRequest, v, null);
    }

    public BRelTime getExitRequestTimeout() {
        return (BRelTime)this.get(exitRequestTimeout);
    }

    public void setExitRequestTimeout(BRelTime v) {
        this.set(exitRequestTimeout, (BValue)v, null);
    }

    public boolean getExitRequestTimeoutRelock() {
        return this.getBoolean(exitRequestTimeoutRelock);
    }

    public void setExitRequestTimeoutRelock(boolean v) {
        this.setBoolean(exitRequestTimeoutRelock, v, null);
    }

    public BAccessAlarmSourceExt getExitRequestTimeoutAlarmExt() {
        return (BAccessAlarmSourceExt)this.get(exitRequestTimeoutAlarmExt);
    }

    public void setExitRequestTimeoutAlarmExt(BAccessAlarmSourceExt v) {
        this.set(exitRequestTimeoutAlarmExt, (BValue)v, null);
    }

    public void stopInhibitSensor() {
        this.invoke(stopInhibitSensor, null, null);
    }

    public void exitRequestExpired() {
        this.invoke(exitRequestExpired, null, null);
    }

    public void fireExitRequest(BRexActivation event) {
        this.fire(exitRequest, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAccessRex() {
    }

    public BAccessRex(BBooleanPoint oldRex) {
        this.setFacets(oldRex.getFacets());
        BAbstractProxyExt proxyExt = oldRex.getProxyExt();
        oldRex.setProxyExt((BAbstractProxyExt)new BNullProxyExt());
        this.setProxyExt(proxyExt);
        AccessNetworkUpgrade.upgradeFaultExt((BControlPoint)oldRex, (BControlPoint)this);
    }

    public void started() throws Exception {
        super.started();
        this.activeOut = this.getOut().getValue();
        this.activeSchedule = this.getRequestableSchedule().getValue();
        this.handleEffectiveness();
        this.proxyInit();
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        network.setSourceName((BComponent)this.getExitRequestTimeoutAlarmExt());
        if (!this.activeOut) {
            BAccessSdi.alarmDisable(this.getExitRequestTimeoutAlarmExt());
        }
    }

    public void proxyInit() {
        if (this.getProxyExt() instanceof BAccessProxyExt) {
            return;
        }
        boolean enabled = false;
        int instance = 0;
        if (this.getParent() instanceof BAccessDoor) {
            instance = ((BAccessDoor)this.getParent()).getInitialAddress(this);
        }
        if (instance > 0) {
            enabled = true;
        }
        String active = this.getLexicon().getText("rte.status.active");
        String inactive = this.getLexicon().getText("rte.status.inactive");
        AccessPointDeviceExtUtil.initBooleanProxyExt(this, instance, false, true, active, inactive, false, false, true, enabled, "%parent.parent.getDisplayName%.%parent.displayName%");
        this.initLinks();
    }

    public void initLinks() {
        LinkCheck check;
        BAccessDoor door;
        BAccessStrike strike;
        if (this.getParent() instanceof BAccessDoor && (strike = (door = (BAccessDoor)this.getParent()).getStrike()) != null && (check = strike.checkLink((BComponent)this, (Slot)exitRequest, (Slot)BAccessStrike.exitRequest, null)).isValid()) {
            BLink link = strike.makeLink((BComponent)this, (Slot)exitRequest, (Slot)BAccessStrike.exitRequest, null);
            strike.add(null, (BValue)link);
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == out) {
            return BAccessNetwork.lex.getText("AccessRex.out");
        }
        if (slot == proxyExt) {
            return BAccessNetwork.lex.getText("AccessRex.proxyExt");
        }
        return super.getDisplayName(slot, cx);
    }

    public void handleEffectiveness() {
        if (this.activeOut && this.activeSchedule && !this.getInhibitSensor().getBoolean()) {
            this.cancelTimer(this.effectiveTicket);
            this.setInhibitSensor(new BStatusBoolean(true));
        } else if (!(!this.getInhibitSensor().getBoolean() || this.activeOut && this.activeSchedule || this.effectiveTicket != null && !this.effectiveTicket.isExpired())) {
            this.effectiveTicket = this.setTimer(this.effectiveTicket, BAccessStrike.getAccessUnlockTime((BComponent)this), stopInhibitSensor);
        }
    }

    public void doStopInhibitSensor() {
        if (!this.activeOut || !this.activeSchedule) {
            this.setInhibitSensor(new BStatusBoolean(false));
        }
    }

    public void exitRequestInactive() {
        if (!this.activeOut) {
            BAccessSdi.alarmDisable(this.getExitRequestTimeoutAlarmExt());
        }
        if (this.waitForSendRequest) {
            return;
        }
        this.cancelTimer(this.exitRequestExpiredTicket);
        BAbsTime now = BAbsTime.now();
        if (this.accessUnlockExpiredTime != null && now.isBefore(this.accessUnlockExpiredTime)) {
            BRexActivation rA = new BRexActivation();
            rA.setUnlock(this.getUnlockOnExitRequest());
            rA.setAuthorization(this.getDisplayName(null));
            rA.setTime(this.accessUnlockExpiredTime.delta(now));
            rA.setStopEmergencyOverride(true);
            this.fireExitRequest(rA);
            return;
        }
        BRexActivation rA = new BRexActivation();
        rA.setUnlock(this.getUnlockOnExitRequest());
        rA.setTime(BTimedOverride.cancelTime);
        this.fireExitRequest(rA);
    }

    public void doExitRequestExpired() {
        if (this.activeOut && this.activeSchedule) {
            BAccessSdi.alarmEnable(this.getExitRequestTimeoutAlarmExt());
            if (this.getExitRequestTimeoutRelock()) {
                this.exitRequestInactive();
                this.waitForSendRequest = true;
            }
        }
    }

    public void changed(Property p, Context cx) {
        boolean newActiveSchedule;
        if (!this.isRunning() || !this.getOut().getStatus().isValid()) {
            return;
        }
        if (p.equals(out)) {
            boolean newActiveOut = this.getOut().getValue();
            if (newActiveOut != this.activeOut) {
                this.activeOut = newActiveOut;
                if (this.activeOut && this.activeSchedule) {
                    this.sendRequest();
                } else if (!this.activeOut && this.activeSchedule) {
                    this.exitRequestInactive();
                }
                this.handleEffectiveness();
            }
        } else if (p.equals(requestableSchedule) && (newActiveSchedule = this.getRequestableSchedule().getValue()) != this.activeSchedule) {
            this.activeSchedule = newActiveSchedule;
            if (this.activeOut && this.activeSchedule) {
                this.sendRequest();
            } else if (!this.activeSchedule && this.activeOut) {
                this.exitRequestInactive();
            }
            this.handleEffectiveness();
        }
    }

    public void sendRequest() {
        BAccessSdi sensor;
        BAccessDoor door;
        BAccessStrike strike;
        this.waitForSendRequest = false;
        BRexActivation rA = new BRexActivation();
        rA.setUnlock(this.getUnlockOnExitRequest());
        rA.setAuthorization(this.getDisplayName(null));
        if (this.getUnlockOnExitRequest() && this.getExitRequestTimeout().getMillis() > 0L) {
            rA.setTime(BRelTime.DAY);
            this.exitRequestExpiredTicket = this.setTimer(this.exitRequestExpiredTicket, this.getExitRequestTimeout(), exitRequestExpired);
            this.accessUnlockExpiredTime = BAbsTime.now().add(BAccessStrike.getAccessUnlockTime((BComponent)this));
        }
        this.fireExitRequest(rA);
        if (this.getParent() instanceof BAccessDoor && (strike = (door = (BAccessDoor)this.getParent()).getStrike()) == null && (sensor = door.getSensor()) != null) {
            sensor.inhibit(BAccessStrike.getAccessUnlockTime((BComponent)this));
        }
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        return this.setTimer(ticket, time, action, null);
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action, BValue arg) {
        this.cancelTimer(ticket);
        return Clock.schedule((BComponent)this, (BRelTime)time.abs(), (Action)action, (BValue)arg);
    }

    private void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
        ticket = null;
    }
}

