/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridiumx.accessDriver.AccessBacnetUtil;
import com.tridiumx.accessDriver.AccessNetworkUpgrade;
import com.tridiumx.accessDriver.BAccess2ReaderModule;
import com.tridiumx.accessDriver.BAccessDeviceFolder;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessWorker;
import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.BBase2ReaderModule;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BValidationWorker;
import com.tridiumx.accessDriver.enums.BDoorConfigureEnum;
import com.tridiumx.accessDriver.job.BAccessLearnDevicesJob;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BIAccessPointDeviceExt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class BAccessNetwork
extends BNrioNetwork
implements NrioMessageConst {
    private static String DEFAULT_VALUE_FOR_NETWORK_VERSION = AccessNetworkUpgrade.phaseII.toString();
    public static final Property keypadEntryTime = BAccessNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))));
    public static final Property showResultsTime = BAccessNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)10))));
    public static final Property validationTimeout = BAccessNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))));
    public static final Property baseBoardAvailVersion = BAccessNetwork.newProperty((int)1, (String)"", null);
    public static final Property remoteReaderAvailVersion = BAccessNetwork.newProperty((int)1, (String)"", null);
    public static final Property remoteIoAvailVersion = BAccessNetwork.newProperty((int)1, (String)"", null);
    public static final Property networkVersion = BAccessNetwork.newProperty((int)1, (String)DEFAULT_VALUE_FOR_NETWORK_VERSION, null);
    public static final Property maxReaders = BAccessNetwork.newProperty((int)7, (int)0, null);
    public static final Property maxDevices = BAccessNetwork.newProperty((int)7, (int)0, null);
    public static final Property hasBacnetDoorControl = BAccessNetwork.newProperty((int)5, (boolean)false, null);
    public static final Property bacnetDoorControl = BAccessNetwork.newProperty((int)5, (boolean)false, null);
    public static final Property accessWorker = BAccessNetwork.newProperty((int)5, (BValue)new BAccessWorker(), null);
    public static final Property validationWorker = BAccessNetwork.newProperty((int)5, (BValue)new BValidationWorker(), null);
    public static final Action rebuildBacnetTable = BAccessNetwork.newAction((int)16, null);
    public static final Action asyncAdded = BAccessNetwork.newAction((int)20, (BValue)new BComponent(), null);
    public static final Action asyncStarted = BAccessNetwork.newAction((int)20, (BValue)new BComponent(), null);
    public static final Type TYPE = Sys.loadType(BAccessNetwork.class);
    private boolean isStarted = false;
    public static final String ALARM_MODULE_DISPLAY = "alarmModuleDisplay";
    public static final String TO_NORMAL_FIX = "toNormalFix";
    private static byte[] NULL_BA = new byte[0];
    public static Lexicon lex = Lexicon.make(BAccessNetwork.class);

    public BRelTime getKeypadEntryTime() {
        return (BRelTime)this.get(keypadEntryTime);
    }

    public void setKeypadEntryTime(BRelTime v) {
        this.set(keypadEntryTime, (BValue)v, null);
    }

    public BRelTime getShowResultsTime() {
        return (BRelTime)this.get(showResultsTime);
    }

    public void setShowResultsTime(BRelTime v) {
        this.set(showResultsTime, (BValue)v, null);
    }

    public BRelTime getValidationTimeout() {
        return (BRelTime)this.get(validationTimeout);
    }

    public void setValidationTimeout(BRelTime v) {
        this.set(validationTimeout, (BValue)v, null);
    }

    public String getBaseBoardAvailVersion() {
        return this.getString(baseBoardAvailVersion);
    }

    public void setBaseBoardAvailVersion(String v) {
        this.setString(baseBoardAvailVersion, v, null);
    }

    public String getRemoteReaderAvailVersion() {
        return this.getString(remoteReaderAvailVersion);
    }

    public void setRemoteReaderAvailVersion(String v) {
        this.setString(remoteReaderAvailVersion, v, null);
    }

    public String getRemoteIoAvailVersion() {
        return this.getString(remoteIoAvailVersion);
    }

    public void setRemoteIoAvailVersion(String v) {
        this.setString(remoteIoAvailVersion, v, null);
    }

    public String getNetworkVersion() {
        return this.getString(networkVersion);
    }

    public void setNetworkVersion(String v) {
        this.setString(networkVersion, v, null);
    }

    public int getMaxReaders() {
        return this.getInt(maxReaders);
    }

    public void setMaxReaders(int v) {
        this.setInt(maxReaders, v, null);
    }

    public int getMaxDevices() {
        return this.getInt(maxDevices);
    }

    public void setMaxDevices(int v) {
        this.setInt(maxDevices, v, null);
    }

    public boolean getHasBacnetDoorControl() {
        return this.getBoolean(hasBacnetDoorControl);
    }

    public void setHasBacnetDoorControl(boolean v) {
        this.setBoolean(hasBacnetDoorControl, v, null);
    }

    public boolean getBacnetDoorControl() {
        return this.getBoolean(bacnetDoorControl);
    }

    public void setBacnetDoorControl(boolean v) {
        this.setBoolean(bacnetDoorControl, v, null);
    }

    public BAccessWorker getAccessWorker() {
        return (BAccessWorker)this.get(accessWorker);
    }

    public void setAccessWorker(BAccessWorker v) {
        this.set(accessWorker, (BValue)v, null);
    }

    public BValidationWorker getValidationWorker() {
        return (BValidationWorker)this.get(validationWorker);
    }

    public void setValidationWorker(BValidationWorker v) {
        this.set(validationWorker, (BValue)v, null);
    }

    public void rebuildBacnetTable() {
        this.invoke(rebuildBacnetTable, null, null);
    }

    public void asyncAdded(BValue event) {
        this.invoke(asyncAdded, event, null);
    }

    public void asyncStarted(BValue event) {
        this.invoke(asyncStarted, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BINavNode[] getNavChildren() {
        this.loadSlots();
        BComponent[] temp = new BComponent[this.getSlotCount()];
        SlotCursor c = this.getProperties();
        int count = 0;
        while (c.nextComponent()) {
            BComponent kid = (BComponent)c.get();
            if (Flags.isHidden((BComplex)this, (Slot)c.property()) || !kid.isNavChild() || kid.getPropertyInParent().isFrozen() && !(kid instanceof BIAccessDevice)) continue;
            temp[count++] = kid;
            kid = null;
        }
        BComponent[] result = new BComponent[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        c = null;
        return result;
    }

    public Type getDeviceType() {
        return BNrioDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BAccessDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setBaseBoardAvailVersion(this.getVersion("T2029"));
        this.setRemoteReaderAvailVersion(this.getVersion("T2030"));
        this.setRemoteIoAvailVersion(this.getVersion("T2034"));
        this.setMaxReaders(this.getLicenseMaxReaders());
        this.setMaxDevices(this.getLicenseMaxDevices());
        this.setHasBacnetDoorControl(this.getLicenseBacnetDoorControl());
        if (this.getHasBacnetDoorControl()) {
            this.setFlags((Slot)bacnetDoorControl, this.getFlags((Slot)bacnetDoorControl) & 0xFFFFFFFE);
        } else {
            this.setBacnetDoorControl(false);
            this.setFlags((Slot)bacnetDoorControl, this.getFlags((Slot)bacnetDoorControl) | 1);
        }
        this.isStarted = true;
    }

    public void descendantsStarted() {
        if (this.get(ALARM_MODULE_DISPLAY) == null) {
            this.add(ALARM_MODULE_DISPLAY, (BValue)BBoolean.TRUE);
            this.configureAlarmModuleDisplay();
        }
        if (this.get(TO_NORMAL_FIX) == null) {
            this.add(TO_NORMAL_FIX, (BValue)BBoolean.TRUE, 4);
            this.configureToNormalFix();
        }
    }

    public void stationStarted() throws Exception {
        AccessBacnetUtil.removeInvalidOrds();
        String networkVersion = this.getNetworkVersion();
        Version version = new Version(networkVersion);
        if (version.compareTo(AccessNetworkUpgrade.CURRENT_NETWORK_VERSION) < 0) {
            try {
                AccessNetworkUpgrade.upgrade(this, version, AccessNetworkUpgrade.CURRENT_NETWORK_VERSION);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getLog().error("Error during upgrade from " + version + " to " + AccessNetworkUpgrade.CURRENT_NETWORK_VERSION + ".", (Throwable)e);
            }
        }
    }

    private String getVersion(String name) {
        try {
            return ((BString)this.get(name)).getString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(bacnetDoorControl)) {
            if (this.getBacnetDoorControl()) {
                BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)TYPE);
                BIAccessDevice[] devices = (BIAccessDevice[])accessNetwork.getChildren(BIAccessDevice.class);
                for (int i = 0; i < devices.length; ++i) {
                    AccessBacnetUtil.addBacnetWritablePoints((BComponent)((BDevice)devices[i]));
                }
            } else {
                AccessBacnetUtil.removeWritableBacnetTable();
            }
        } else if (prop.getName().equals(ALARM_MODULE_DISPLAY)) {
            this.configureAlarmModuleDisplay();
        } else {
            super.changed(prop, cx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value instanceof BBase2ReaderModule) {
            if (((BBase2ReaderModule[])this.getChildren(BBase2ReaderModule.class)).length <= 0) return;
            if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "Only 1 Base Board Reader");
            this.getLog().warning("Only 1 Base Board Reader");
            return;
        } else {
            if (!(value instanceof BNrioDevice) || ((BNrioDevice[])this.getChildren(BNrioDevice.class)).length <= this.getLicenseMaxDevices() - 1) return;
            if (context != Context.decoding) throw new LocalizableRuntimeException("accessDriver", "License limit reached:" + this.getLicenseMaxDevices());
            this.getLog().warning("License limit reached:" + this.getLicenseMaxDevices());
        }
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BAccessLearnDevicesJob job = new BAccessLearnDevicesJob(this);
        return job.submit(null);
    }

    public final int getLicenseMaxReaders() {
        String limit = this.getLicenseFeature().get("reader.limit");
        if (limit == null) {
            return 0;
        }
        if (limit.equals("none")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(limit);
    }

    public final boolean getLicenseBacnetDoorControl() {
        return this.getLicenseFeature().getb("bacnetWrite", false);
    }

    public void configureAlarmModuleDisplay() {
        BComponent[] alarms = BAccessNetwork.getAllAlarms();
        for (int i = 0; i < alarms.length; ++i) {
            this.setSourceName(alarms[i]);
        }
    }

    public void configureToNormalFix() {
        BComponent[] alarms = BAccessNetwork.getAllAlarms();
        for (int i = 0; i < alarms.length; ++i) {
            BAlarmSourceExt ext;
            if (!(alarms[i] instanceof BAlarmSourceExt) || (ext = (BAlarmSourceExt)alarms[i]).getAlarmEnable().isToNormal()) continue;
            ext.setAlarmEnable(BAlarmTransitionBits.make((int)(ext.getAlarmEnable().getBits() | 4)));
        }
    }

    public void setSourceName(BComponent alarm) {
        BFormat sourceName = this.getSourceName(alarm);
        alarm.set("sourceName", (BValue)sourceName);
    }

    public BFormat getSourceName(BComponent alarm) {
        boolean includeModule = this.get(ALARM_MODULE_DISPLAY) == null || ((BBoolean)this.get(ALARM_MODULE_DISPLAY)).getBoolean();
        int depth = 2;
        BComponent parent = (BComponent)alarm.getParent();
        String sourceName = "";
        if (alarm instanceof BAlarmSourceExt) {
            sourceName = "%parent.displayName%";
        } else {
            if (alarm.getParent() instanceof BIAccessDevice) {
                return BFormat.make((String)"%parent.parent.displayName%.%parent.displayName%");
            }
            if (alarm.getParent() instanceof BAccessNetwork) {
                return BFormat.make((String)"%parent.displayName%");
            }
            if (alarm.getParent() instanceof BActivityAlertExt && alarm.getParent() != null && alarm.getParent().getParent() instanceof BAccessReader) {
                return BActivityAlertExt.SOURCE_NAME;
            }
            sourceName = "%parent.parent.displayName%";
            parent = (BComponent)parent.getParent();
            ++depth;
        }
        while (!(parent instanceof BIAccessDevice)) {
            String parentFormat = "displayName%.";
            for (int i = 0; i < depth; ++i) {
                parentFormat = "parent." + parentFormat;
            }
            parent = (BComponent)parent.getParent();
            if (!includeModule && parent instanceof BIAccessDevice) {
                return BFormat.make((String)sourceName);
            }
            if (parent instanceof BAccessNetwork) {
                return BFormat.make((String)sourceName);
            }
            if (!(parent instanceof BIAccessPointDeviceExt)) {
                sourceName = "%" + parentFormat + sourceName;
            }
            ++depth;
        }
        return BFormat.make((String)sourceName);
    }

    public static BComponent[] getAllAlarms() {
        String accessNetwork = "station:|slot:/Drivers/AccessNetwork";
        String bql = "|bql:select * from alarm:AlarmSourceInfo";
        BOrd bqlOrd = BOrd.make((String)(accessNetwork + bql)).normalize();
        TableCursor points = ((BITable)bqlOrd.resolve().get()).cursor();
        Array arr = new Array(BComponent.class);
        while (points.next()) {
            arr.add((Object)((BComponent)points.get()));
        }
        bql = "|bql:select * from alarm:AlarmSourceExt";
        bqlOrd = BOrd.make((String)(accessNetwork + bql)).normalize();
        points = ((BITable)bqlOrd.resolve().get()).cursor();
        while (points.next()) {
            arr.add((Object)((BComponent)points.get()));
        }
        return (BComponent[])arr.trim();
    }

    public void doRebuildBacnetTable() {
        AccessBacnetUtil.rebuildBacnetTable();
    }

    public BAccessReader[] getReaders() {
        return BAccessNetwork.getReaders((BComponent)this);
    }

    public static BAccessReader[] getReaders(BComponent root) {
        BogCursor cursor = new BogCursor((BComplex)root, 10, new Type[]{BAccessReader.TYPE}, true, null);
        Array readers = new Array(BAccessReader.class);
        while (cursor.next()) {
            readers.add((Object)cursor.get());
        }
        return (BAccessReader[])readers.trim();
    }

    public void initLogicalAddressMap() {
        for (int i = 1; i <= 16; ++i) {
            if (this.getDevice(i) != null) {
                this.logicalAddressMap |= 1 << i;
                continue;
            }
            this.logicalAddressMap &= ~(1 << i);
        }
    }

    public int getLogicalAddress(byte[] uid) {
        BNrioDevice temp = this.getDevice(uid);
        if (temp == null) {
            return -1;
        }
        return temp.getAddress();
    }

    public int getFreeAddress(boolean isReader) {
        int i;
        int start = 1;
        int maxAddress = 16;
        for (i = start; i <= maxAddress; ++i) {
            if ((this.logicalAddressMap & 1 << i) != 0) continue;
            this.logicalAddressMap |= 1 << i;
            return i;
        }
        maxAddress = 16;
        for (i = start; i <= maxAddress; ++i) {
            if (this.getDevice(i) == null) {
                System.out.println("getDevice(" + i + ") is not mounted yet");
                return -1;
            }
            System.out.println("getDevice(" + i + ").isDown() =  " + this.getDevice(i).isDown());
            if (!this.getDevice(i).isDown() || (!(this.getDevice(i) instanceof BAccess2ReaderModule) || !isReader) && (!(this.getDevice(i) instanceof BNrioInputOutputModule) || isReader)) continue;
            return i;
        }
        return -1;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat /dev/actrl");
            InputStream in = process.getInputStream();
            InputStreamReader inr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(inr);
            out.startTable(false);
            out.trTitle((Object)"AccessNetwork", 1);
            out.endTable();
            out.w((Object)"<pre>\n");
            String line = this.convertBogusChars(br.readLine());
            while (line != null) {
                out.safe((Object)line).w((Object)"\n");
                line = this.convertBogusChars(br.readLine());
            }
            out.w((Object)"</pre>\n");
            br.close();
            inr.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.endProps();
    }

    private String convertBogusChars(String src) {
        StringBuffer buf = new StringBuffer();
        char[] chars = src.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\t') {
                buf.append("        ");
                continue;
            }
            if (chars[i] == '\u0000') continue;
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    public void addDoors(BIAccessDevice device) {
        if (device.isSkipInit()) {
            return;
        }
        boolean addReaders = device instanceof BAccess2ReaderModule;
        int doorLength = ((BAccessDoor[])device.getPoints().getChildren(BAccessDoor.class)).length;
        BDoorConfigureEnum doorAmount = device.getInitialDoors();
        if (doorAmount.equals((Object)BDoorConfigureEnum.twoDoors)) {
            if (doorLength == 0) {
                BAccessDoor door1 = new BAccessDoor();
                device.getPoints().add(lex.getText("door", new Object[]{"1"}) + "?", (BValue)door1);
                if (!device.getPoints().isRunning()) {
                    AccessPointDeviceExtUtil.added(device.getPoints(), door1.getPropertyInParent(), null);
                }
            }
            if (doorLength < 2) {
                BAccessDoor door2 = new BAccessDoor();
                device.getPoints().add(lex.getText("door", new Object[]{"2"}) + "?", (BValue)door2);
                if (!device.getPoints().isRunning()) {
                    AccessPointDeviceExtUtil.added(device.getPoints(), door2.getPropertyInParent(), null);
                }
            }
        } else if (doorAmount.equals((Object)BDoorConfigureEnum.oneDoor) && doorLength == 0) {
            BAccessDoor door1 = new BAccessDoor();
            device.getPoints().add(lex.getText("door", new Object[]{"1"}) + "?", (BValue)door1);
            if (!device.getPoints().isRunning()) {
                AccessPointDeviceExtUtil.added(device.getPoints(), door1.getPropertyInParent(), null);
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        this.getAccessWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void doAsyncAdded(BValue val) {
        if (val instanceof BNrioDevice) {
            AccessBacnetUtil.addBacnetPoints((BComponent)((BNrioDevice)val));
        }
        if (val instanceof BIAccessDevice) {
            this.addDoors((BIAccessDevice)val);
        }
    }

    public void doAsyncStarted(BValue val) throws Exception {
        if (val instanceof BIAccessPointDeviceExt) {
            ((BIAccessPointDeviceExt)val).asyncStarted();
        }
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue val = this.get(property);
        if (val instanceof BNrioDevice || val instanceof BIAccessDevice) {
            this.asyncAdded(val);
        }
    }

    public void checkRemove(Property property, Context context) {
        if (!this.isStarted) {
            return;
        }
        BValue oldValue = this.get(property);
        if (oldValue instanceof BIAccessDevice) {
            BIAccessDevice c = (BIAccessDevice)oldValue;
            String oldName = property.getDefaultDisplayName(context);
            AccessBacnetUtil.removeBacnetPoints(oldName);
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        AccessPointDeviceExtUtil.renamed((BComponent)this, property, oldName, context);
    }
}

