/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BIAccessDriverService;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAccessFloor
extends BComponent
implements BIStatus {
    public static final Property out = BAccessFloor.newProperty((int)8, (BValue)new BStatusBoolean(false), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:FloorFE"), (BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("active"))), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("inactive"))));
    public static final Property enabledSchedule = BAccessFloor.newProperty((int)0, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property logScheduleActivity = BAccessFloor.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BAccessFloor.class);
    public static final BIcon ICON = BIcon.make((String)"module://accessDriver/rc/floor.png");
    private boolean scheduled = false;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getEnabledSchedule() {
        return (BStatusBoolean)this.get(enabledSchedule);
    }

    public void setEnabledSchedule(BStatusBoolean v) {
        this.set(enabledSchedule, (BValue)v, null);
    }

    public boolean getLogScheduleActivity() {
        return this.getBoolean(logScheduleActivity);
    }

    public void setLogScheduleActivity(boolean v) {
        this.setBoolean(logScheduleActivity, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAccessElevator;
    }

    public void started() throws Exception {
        this.scheduled = this.getEnabledSchedule().getValue();
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void changed(Property p, Context cx) {
        boolean newScheduled;
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabledSchedule) && (newScheduled = this.getEnabledSchedule().getValue()) != this.scheduled) {
            BAccessElevator elevator;
            this.scheduled = newScheduled;
            this.auditScheduleChange();
            if (!this.scheduled && this.getParent() instanceof BAccessElevator && (elevator = (BAccessElevator)this.getParent()).isFloorValidated(this)) {
                return;
            }
            this.setOut((BStatusBoolean)this.getEnabledSchedule().newCopy());
        }
    }

    private void auditScheduleChange() {
        if (!this.getLogScheduleActivity()) {
            return;
        }
        try {
            BLink[] links = this.getLinks((Slot)enabledSchedule);
            if (links.length > 0 && links[0].isActive()) {
                BLink link = links[0];
                String description = BAccessNetwork.lex.getText("scheduleAuthorization", new Object[]{this.getEnabledSchedule().getValue() ? BAccessNetwork.lex.getText("active") : BAccessNetwork.lex.getText("inactive")});
                String scheduleName = link.getSourceComponent().getDisplayName(null);
                BIAccessDriverService service = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
                service.accessAudit(this, BBadgeActivity.manualOverride, scheduleName, description, this.getEnabledSchedule().getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }
}

