/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BSecAlarmSourceExt;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.fault.BStatusFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BAccessAlarmSourceExt
extends BSecAlarmSourceExt {
    public static final Property securityAlgorithm = BAccessAlarmSourceExt.newProperty((int)0, (BValue)BSecurityAlgorithmEnum.normal, null);
    public static final Type TYPE = Sys.loadType(BAccessAlarmSourceExt.class);

    public BSecurityAlgorithmEnum getSecurityAlgorithm() {
        return (BSecurityAlgorithmEnum)this.get(securityAlgorithm);
    }

    public void setSecurityAlgorithm(BSecurityAlgorithmEnum v) {
        this.set(securityAlgorithm, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAccessAlarmSourceExt(BSecurityAlgorithmEnum secEnum) {
        this.setSecurityAlgorithm(secEnum);
    }

    public BAccessAlarmSourceExt() {
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.handleSecurityAlgorithm();
        if (this.getSecurityAlgorithm() != BSecurityAlgorithmEnum.intrusionTimeout) {
            this.setFlags((Slot)alarmClass, this.getFlags((Slot)alarmClass) | Integer.MIN_VALUE);
            this.getParent().setFlags((Slot)this.getPropertyInParent(), this.getParent().getFlags((Slot)this.getPropertyInParent()) | Integer.MIN_VALUE);
        }
        this.setFlags((Slot)securityAlgorithm, this.getFlags((Slot)securityAlgorithm) | 1);
    }

    public void handleSecurityAlgorithm() {
        if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.normal) {
            if (Flags.isReadonly((BComplex)this, (Slot)toFaultText)) {
                this.setToFaultText(BFormat.DEFAULT);
            }
            if (Flags.isReadonly((BComplex)this, (Slot)toOffnormalText)) {
                this.setToOffnormalText(BFormat.DEFAULT);
            }
            if (Flags.isReadonly((BComplex)this, (Slot)toNormalText)) {
                this.setToNormalText(BFormat.DEFAULT);
            }
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) & 0xFFFFFFFE);
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) & 0xFFFFFFFE & 0xFFFFFFFB);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) & 0xFFFFFFFE & 0xFFFFFFFB);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) & 0xFFFFFFFE & 0xFFFFFFFB);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) & 0xFFFFFFFE & 0xFFFFFFFB);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) & 0xFFFFFFFE & 0xFFFFFFFB);
            if (this.isExternallyControlled()) {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 1);
            } else {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) & 0xFFFFFFFE & 0xFFFFFFFB);
            }
            if (this.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                this.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
            this.setFaultAlgorithm(new BFaultAlgorithm());
        } else if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.supervisionFault) {
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) | 1);
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) | 1);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) | 1);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) | 1 | 4);
            this.setFlags((Slot)timeDelay, this.getFlags((Slot)timeDelay) | 1 | 4);
            this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 4);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) | 1);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) | 1);
            this.setToFaultText(BFormat.make((String)BAccessNetwork.lex.getText("sdi.toFaultText")));
            this.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("sdi.toNormalText")));
            this.setToOffnormalText(BFormat.DEFAULT);
            BStatusFaultAlgorithm al = new BStatusFaultAlgorithm();
            al.setFaultValues(BStatus.fault);
            this.setFaultAlgorithm((BFaultAlgorithm)al);
            this.setOffnormalAlgorithm(new BOffnormalAlgorithm());
        } else if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.doorForced) {
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) | 1);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) | 1);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) | 1);
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) | 1 | 4);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) | 1);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) | 1);
            if (this.isExternallyControlled()) {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 1);
            } else {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) & 0xFFFFFFFE & 0xFFFFFFFB);
            }
            this.setToFaultText(BFormat.DEFAULT);
            this.setToOffnormalText(BFormat.make((String)BAccessNetwork.lex.getText("doorForcedAlarm.offNormalText")));
            this.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("doorForcedAlarm.toNormalText")));
            if (this.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                this.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
            this.setFaultAlgorithm(new BFaultAlgorithm());
        } else if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.doorHeldOpen) {
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) | 1);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) | 1);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) | 1);
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) | 1 | 4);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) | 1);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) | 1);
            if (this.isExternallyControlled()) {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 1);
            } else {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) & 0xFFFFFFFE & 0xFFFFFFFB);
            }
            this.setToFaultText(BFormat.DEFAULT);
            this.setToOffnormalText(BFormat.make((String)BAccessNetwork.lex.getText("doorHeldOpenAlarm.offNormalText")));
            this.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("doorHeldOpenAlarm.toNormalText")));
            if (this.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                this.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
            this.setFaultAlgorithm(new BFaultAlgorithm());
        } else if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.intrusionTimeout) {
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) | 1);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) | 1);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) | 1);
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) | 4);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) | 1);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) | 1);
            if (this.isExternallyControlled()) {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 1);
            } else {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) & 0xFFFFFFFE & 0xFFFFFFFB);
            }
            this.setToFaultText(BFormat.DEFAULT);
            this.setToOffnormalText(BFormat.make((String)BAccessNetwork.lex.getText("intrusionTimeoutAlarm.offNormalText")));
            this.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("intrusionTimeoutAlarm.toNormalText")));
            if (this.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                this.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
            this.setFaultAlgorithm(new BFaultAlgorithm());
        } else if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.exitRequestTimeout) {
            this.setFlags((Slot)alarmEnable, this.getFlags((Slot)alarmEnable) | 1);
            this.setFlags((Slot)toOffnormalText, this.getFlags((Slot)toOffnormalText) | 1);
            this.setFlags((Slot)toNormalText, this.getFlags((Slot)toNormalText) | 1);
            this.setFlags((Slot)toFaultText, this.getFlags((Slot)toFaultText) | 1 | 4);
            this.setFlags((Slot)offnormalAlgorithm, this.getFlags((Slot)offnormalAlgorithm) | 1);
            this.setFlags((Slot)faultAlgorithm, this.getFlags((Slot)faultAlgorithm) | 1);
            if (this.isExternallyControlled()) {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) | 1);
            } else {
                this.setFlags((Slot)alarmInhibit, this.getFlags((Slot)alarmInhibit) & 0xFFFFFFFE & 0xFFFFFFFB);
            }
            this.setToFaultText(BFormat.DEFAULT);
            this.setToOffnormalText(BFormat.make((String)BAccessNetwork.lex.getText("exitRequestTimeout.offNormalText")));
            this.setToNormalText(BFormat.make((String)BAccessNetwork.lex.getText("exitRequestTimeout.toNormalText")));
            if (this.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                this.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
            this.setFaultAlgorithm(new BFaultAlgorithm());
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == alarmClass) {
            if (this.getSecurityAlgorithm() == BSecurityAlgorithmEnum.supervisionFault) {
                return BAccessNetwork.lex.getText("AccessAlarmSourceExt.alarmClass." + this.getParent().getType().getTypeName() + "." + this.getSecurityAlgorithm().getTag());
            }
            return BAccessNetwork.lex.getText("AccessAlarmSourceExt.alarmClass." + this.getSecurityAlgorithm().getTag());
        }
        return super.getDisplayName(slot, cx);
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(securityAlgorithm)) {
            this.handleSecurityAlgorithm();
        }
    }
}

