/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bql.cursor.BogCursor;
import com.tridium.nrio.BNrioDevice;
import com.tridiumx.accessDriver.BAccessBacnetOutput;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.points.BIAccessPointDeviceExt;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryOutputDescriptor;
import javax.baja.bacnet.export.BBacnetBinaryValueDescriptor;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class AccessBacnetUtil {
    public static Logger log = Logger.getLogger("bacnet.server");
    private static String BACNET_WRITABLE = "in1,in2,in3,in4,in5,in6,in7,in8,in9,in10,in11,in12,in13,in14,in15,in16";

    public static boolean isBacnetEnabled() {
        try {
            BBacnetNetwork network = (BBacnetNetwork)Sys.getService((Type)BBacnetNetwork.TYPE);
            return network.getEnabled();
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
    }

    public static boolean hasBacnet() {
        try {
            BBacnetNetwork network = (BBacnetNetwork)Sys.getService((Type)BBacnetNetwork.TYPE);
            return true;
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
    }

    public static void removeBacnetPoints(String oldDescription) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        final Level level = log.getLevel();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(Level.SEVERE);
                return null;
            }
        });
        BComponent exportTable = BBacnetNetwork.localDevice().getExportTable();
        BBacnetPointDescriptor[] bacObj = (BBacnetPointDescriptor[])exportTable.getChildren(BBacnetPointDescriptor.class);
        for (int i = 0; i < bacObj.length; ++i) {
            if (!bacObj[i].getDescription().startsWith(oldDescription)) continue;
            exportTable.remove(bacObj[i].getPropertyInParent(), null);
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(level);
                return null;
            }
        });
    }

    public static void removeInvalidOrds() {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        final Level level = log.getLevel();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(Level.SEVERE);
                return null;
            }
        });
        BComponent exportTable = BBacnetNetwork.localDevice().getExportTable();
        BBacnetPointDescriptor[] bacObj = (BBacnetPointDescriptor[])exportTable.getChildren(BBacnetPointDescriptor.class);
        for (int i = 0; i < bacObj.length; ++i) {
            BOrd ord = bacObj[i].getPointOrd();
            try {
                ord.resolve((BObject)exportTable);
                continue;
            }
            catch (UnresolvedException e) {
                exportTable.remove(bacObj[i].getPropertyInParent(), null);
                continue;
            }
            catch (NullOrdException e) {
                exportTable.remove(bacObj[i].getPropertyInParent(), null);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(level);
                return null;
            }
        });
    }

    public static void addBacnetPoints(BComponent device) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        BBacnetExportTable exportTable = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
        int nextBooleanInst = exportTable.getNextInstance(5);
        int nextNumericInst = exportTable.getNextInstance(2);
        int nextBooleanWritableInst = exportTable.getNextInstance(4);
        Type[] returnTypes = new Type[]{BBooleanPoint.TYPE, BNumericPoint.TYPE};
        BogCursor cursor = new BogCursor((BComplex)device, 10, returnTypes, true, null);
        if (device instanceof BAccessBacnetOutput) {
            AccessBacnetUtil.addBacnetOutputPoint((BComponent)exportTable, nextBooleanWritableInst++, device);
        } else if (device instanceof BBooleanPoint) {
            AccessBacnetUtil.addBacnetPoint((BComponent)exportTable, nextBooleanInst++, device);
        } else if (device instanceof BNumericPoint) {
            AccessBacnetUtil.addBacnetNumericPoint((BComponent)exportTable, nextNumericInst++, device);
        }
        while (cursor.next()) {
            BComponent point = (BComponent)cursor.get();
            if (point instanceof BAccessBacnetOutput) {
                AccessBacnetUtil.addBacnetOutputPoint((BComponent)exportTable, nextBooleanWritableInst++, point);
                continue;
            }
            if (point instanceof BBooleanPoint) {
                AccessBacnetUtil.addBacnetPoint((BComponent)exportTable, nextBooleanInst++, point);
                continue;
            }
            if (!(point instanceof BNumericPoint)) continue;
            AccessBacnetUtil.addBacnetNumericPoint((BComponent)exportTable, nextNumericInst++, point);
        }
    }

    public static void addBacnetWritablePoints(BComponent device) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        BBacnetExportTable exportTable = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
        int nextBooleanWritableInst = exportTable.getNextInstance(4);
        Type[] returnTypes = new Type[]{BAccessBacnetOutput.TYPE};
        BogCursor cursor = new BogCursor((BComplex)device, 10, returnTypes, true, null);
        if (device instanceof BAccessBacnetOutput) {
            AccessBacnetUtil.addBacnetOutputPoint((BComponent)exportTable, nextBooleanWritableInst++, device);
        }
        while (cursor.next()) {
            BComponent point = (BComponent)cursor.get();
            AccessBacnetUtil.addBacnetOutputPoint((BComponent)exportTable, nextBooleanWritableInst++, point);
        }
    }

    public static void addBacnetPoint(BComponent exportTable, int inst, BComponent comp) {
        if (!AccessBacnetUtil.isBacnetEnabled() || comp.getSlotPathOrd() == null) {
            return;
        }
        BBacnetObjectIdentifier objectId = BBacnetObjectIdentifier.make((int)5, (int)inst);
        BBacnetBinaryValueDescriptor bacObj = new BBacnetBinaryValueDescriptor();
        bacObj.setObjectOrd(comp.getHandleOrd(), null);
        bacObj.setObjectName(AccessBacnetUtil.bacnetObjectName(comp));
        bacObj.setDescription(AccessBacnetUtil.bacnetObjectDisplayName(comp));
        bacObj.setObjectId(objectId);
        exportTable.add(null, (BValue)bacObj);
    }

    public static void addBacnetOutputPoint(BComponent exportTable, int inst, BComponent comp) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        if (!network.getBacnetDoorControl()) {
            return;
        }
        BBacnetObjectIdentifier objectId = BBacnetObjectIdentifier.make((int)4, (int)inst);
        BBacnetBinaryOutputDescriptor bacObj = new BBacnetBinaryOutputDescriptor();
        bacObj.setObjectOrd(comp.getHandleOrd(), null);
        bacObj.setObjectName(AccessBacnetUtil.bacnetObjectName(comp));
        bacObj.setDescription(AccessBacnetUtil.bacnetObjectDisplayName(comp));
        bacObj.setObjectId(objectId);
        exportTable.add(null, (BValue)bacObj);
        bacObj.makeWritable((BValue)BString.make((String)BACNET_WRITABLE));
        for (int i = 1; i <= 16; ++i) {
            bacObj.setFlags(bacObj.getSlot("bacnetValueIn" + i), 2048);
        }
    }

    public static void addBacnetNumericPoint(BComponent exportTable, int inst, BComponent comp) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        BBacnetObjectIdentifier objectId = BBacnetObjectIdentifier.make((int)2, (int)inst);
        BBacnetAnalogValueDescriptor bacObj = new BBacnetAnalogValueDescriptor();
        bacObj.setObjectOrd(comp.getHandleOrd(), null);
        bacObj.setObjectName(AccessBacnetUtil.bacnetObjectName(comp));
        bacObj.setDescription(AccessBacnetUtil.bacnetObjectDisplayName(comp));
        bacObj.setObjectId(objectId);
        exportTable.add(null, (BValue)bacObj);
    }

    public static String bacnetObjectName(BComponent c) {
        StringBuffer b = new StringBuffer(c.getName());
        while (!(c instanceof BDeviceNetwork)) {
            c = (BComponent)c.getParent();
            b.insert(0, "/").insert(0, c.getName());
        }
        return b.toString();
    }

    public static String bacnetObjectDisplayName(BComponent c) {
        StringBuffer b = new StringBuffer(c.getDisplayName(null));
        while (!(c instanceof BIAccessDevice)) {
            if ((c = (BComponent)c.getParent()) instanceof BIAccessPointDeviceExt) continue;
            b.insert(0, ".").insert(0, c.getDisplayName(null));
        }
        return b.toString();
    }

    public static void removeWritableBacnetTable() {
        final Level level = log.getLevel();
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    log.setLevel(Level.SEVERE);
                    return null;
                }
            });
            BBacnetExportTable exportTable = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
            BBacnetBinaryOutputDescriptor[] children = (BBacnetBinaryOutputDescriptor[])exportTable.getChildren(BBacnetBinaryOutputDescriptor.class);
            for (int i = 0; i < children.length; ++i) {
                BOrd pointOrd = children[i].getPointOrd();
                if (pointOrd == null || pointOrd.isNull()) continue;
                OrdTarget ordTarget = null;
                try {
                    ordTarget = pointOrd.resolve();
                }
                catch (UnresolvedException ue) {
                    ordTarget = null;
                }
                if (ordTarget != null && !AccessBacnetUtil.isAccessPoint(ordTarget.getComponent())) continue;
                exportTable.remove(children[i].getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(level);
                return null;
            }
        });
    }

    public static void removeBacnetTable() {
        if (!AccessBacnetUtil.hasBacnet()) {
            return;
        }
        Level level = log.getLevel();
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    log.setLevel(Level.SEVERE);
                    return null;
                }
            });
            BBacnetExportTable exportTable = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
            BIBacnetExportObject[] children = exportTable.getExportedObjects(BIBacnetExportObject.TYPE);
            for (int i = 0; i < children.length; ++i) {
                if (!AccessBacnetUtil.isAccessPoint((BComponent)children[i].getObject())) continue;
                BComponent parent = (BComponent)children[i].getParent();
                parent.remove((BComplex)((BComponent)children[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                log.setLevel(Level.SEVERE);
                return null;
            }
        });
    }

    public static void rebuildBacnetTable() {
        AccessBacnetUtil.removeBacnetTable();
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        BIAccessDevice[] devices = (BIAccessDevice[])accessNetwork.getChildren(BIAccessDevice.class);
        for (int i = 0; i < devices.length; ++i) {
            AccessBacnetUtil.addBacnetPoints((BComponent)((BNrioDevice)devices[i]));
        }
    }

    public static void updateDisplayNameForBacnet(BComponent component, String oldName) {
        if (!AccessBacnetUtil.isBacnetEnabled()) {
            return;
        }
        String ord = component.getSlotPathOrd().toString();
        String matchString = "slot:/Drivers/";
        int index = ord.indexOf(matchString);
        ord = ord.substring(index + matchString.length());
        index = ord.lastIndexOf(47);
        ord = ord.substring(0, index) + "/" + oldName;
        BComponent exportTable = BBacnetNetwork.localDevice().getExportTable();
        BBacnetPointDescriptor[] bacObj = (BBacnetPointDescriptor[])exportTable.getChildren(BBacnetPointDescriptor.class);
        for (int i = 0; i < bacObj.length; ++i) {
            String objectName = bacObj[i].getObjectName();
            if (!objectName.startsWith(ord)) continue;
            BComponent io = (BComponent)BOrd.make((String)("station:|" + bacObj[i].getPointOrd())).get();
            bacObj[i].setObjectName(AccessBacnetUtil.bacnetObjectName(io));
            bacObj[i].setDescription(AccessBacnetUtil.bacnetObjectDisplayName(io));
        }
    }

    private static boolean isAccessPoint(BComponent object) {
        return AccessBacnetUtil.getAccessNetwork(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BAccessNetwork getAccessNetwork(BComponent object) {
        BComplex parent;
        BAccessNetwork network = null;
        if (object == null) {
            return null;
        }
        try {
            for (parent = object.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BAccessNetwork)) continue;
                network = (BAccessNetwork)parent;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            parent = null;
        }
        return network;
    }
}

