/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aceEdge.ui.nrio;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.aceEdge.ui.nrio.BAceNrioMatch;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;

@NiagaraType
@NiagaraAction(name="buttonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public class BAceNrioMatchDialog
extends BDialog {
    public static final Action buttonPressed = BAceNrioMatchDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BAceNrioMatchDialog.class);
    private static final int ADDRESS_COL = 0;
    private static final int SEC_ADDRESS_COL = 1;
    private static final int UID_COL = 2;
    private static final int VERSION_COL = 3;
    public static final int MATCH_INFO_SIZE = 12;
    public static final byte WINK = 1;
    public static final byte MATCH = 2;
    public static final byte CANCEL = 3;
    public static final byte DISCOVER = 4;
    NrioMatchTable matchTab;
    BButton cancelButton;
    BButton matchButton;
    BButton winkButton;
    BButton discoverButton;
    byte result = 0;
    private static int discoverReq;
    BAceComponent nrioDev;
    MatchSubscriber subscriber;

    public void buttonPressed(BWidgetEvent parameter) {
        this.invoke(buttonPressed, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAceNrioMatchDialog() {
    }

    public BAceNrioMatchDialog(BWidget parent, String title, BAceComponent target) {
        super(parent, title, true);
        this.nrioDev = target;
        this.subscriber = new MatchSubscriber();
        this.subscriber.subscribe((BComponent)target);
        this.cancelButton = new BButton("Cancel");
        this.linkTo((BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.matchButton = new BButton("Match");
        this.linkTo((BComponent)this.matchButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.winkButton = new BButton("Wink");
        this.linkTo((BComponent)this.winkButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.discoverButton = new BButton("Discover");
        this.linkTo((BComponent)this.discoverButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.matchTab = new NrioMatchTable();
        BFlowPane center = new BFlowPane();
        center.setAlign(BHalign.center);
        center.add("matchTab", (BValue)this.matchTab);
        BFlowPane bottom = new BFlowPane();
        bottom.setAlign(BHalign.center);
        bottom.add("discoverButton", (BValue)this.discoverButton);
        bottom.add("winkButton", (BValue)this.winkButton);
        bottom.add("matchButton", (BValue)this.matchButton);
        bottom.add("cancelButton", (BValue)this.cancelButton);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)center));
        pane.setBottom((BWidget)new BBorderPane((BWidget)bottom));
        this.setContent((BWidget)pane);
        BBlob blob = (BBlob)this.nrioDev.get("matchList");
        this.populateTable(blob);
    }

    public byte[] getSelected() {
        if (this.matchTab.getSelection().isEmpty()) {
            return new byte[0];
        }
        int seleted = this.matchTab.getSelection().getRow();
        return ((MatchTableModel)this.matchTab.getModel()).getRow(seleted);
    }

    public byte getResult() {
        return this.result;
    }

    public void doButtonPressed(BWidgetEvent event) {
        if (event.getWidget().equals((Object)this.winkButton)) {
            this.result = 1;
            BAceNrioMatch match = new BAceNrioMatch();
            BAceNrioMatch.AceMatchCommand cmd = (BAceNrioMatch.AceMatchCommand)match.makeCommand(event.getWidget(), this.nrioDev);
            cmd.updateMatchInfo(this, this.result);
            return;
        }
        if (event.getWidget().equals((Object)this.discoverButton)) {
            this.result = (byte)4;
            this.matchTab.clear();
            this.setScreenSizeToPreferredSize();
            Property p = this.nrioDev.getProperty("discoverReq");
            int pId = p.getFacets().geti("pId", -1);
            BAcePrimitive pv = BAcePrimitive.makeS32((int)(++discoverReq));
            this.nrioDev.updateValue(pId, pv);
            return;
        }
        this.close();
        if (event.getWidget().equals((Object)this.matchButton)) {
            this.result = (byte)2;
        } else if (event.getWidget().equals((Object)this.cancelButton)) {
            this.result = (byte)3;
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.result = (byte)3;
        this.close();
    }

    void populateTable(BBlob v) {
        boolean row = true;
        this.matchTab.clear();
        for (int i = 1; i < v.length(); i += 12) {
            byte[] devData = new byte[12];
            v.copyBytes(i, devData, 0, 12);
            this.matchTab.addRow(devData);
        }
        if (this.matchTab.tableModel.getRowCount() > 0) {
            this.matchTab.getSelection().select(0);
        }
    }

    class MatchSubscriber
    extends Subscriber {
        MatchSubscriber() {
            this.setMask(BComponentEventMask.make((int)1));
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                if (!event.getSlot().getName().equals("matchList")) {
                    return;
                }
                BAceNrioMatchDialog.this.populateTable((BBlob)event.getValue());
                BAceNrioMatchDialog.this.matchTab.tableModel.updateTable(true);
                BAceNrioMatchDialog.this.setScreenSizeToPreferredSize();
            }
        }
    }

    class MatchRow {
        byte[] data;

        MatchRow(byte[] d) {
            this.data = d;
        }

        String getAddress() {
            return Integer.toString(this.data[0]);
        }

        String getSecAddress() {
            return Integer.toString(this.data[1]);
        }

        String getUid() {
            StringBuffer sb = new StringBuffer();
            for (int i = 2; i <= 7; ++i) {
                String hex = Integer.toHexString(0xFF & this.data[i]);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            return sb.toString();
        }

        String getVersion() {
            String primaryModuleVer = new String(Integer.toString(this.data[8]) + ":" + Integer.toString(this.data[9]));
            String secondaryModuleVer = new String(Integer.toString(this.data[10]) + ":" + Integer.toString(this.data[11]));
            if (secondaryModuleVer.equals("0:0")) {
                return primaryModuleVer;
            }
            return primaryModuleVer + ";" + secondaryModuleVer;
        }
    }

    class MatchHeaderRenderer
    extends TableHeaderRenderer {
        MatchHeaderRenderer() {
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            if (header.column == 3) {
                return 120.0;
            }
            return super.getPreferredHeaderWidth(header);
        }
    }

    class MatchTableModel
    extends TableModel {
        ArrayList<MatchRow> rows = new ArrayList();

        protected MatchTableModel() {
        }

        public void addRow(byte[] data) {
            this.rows.add(new MatchRow(data));
        }

        public byte[] getRow(int row) {
            return this.rows.get((int)row).data;
        }

        public void clearTable() {
            this.rows.clear();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.rows.get(row).getAddress();
                }
                case 1: {
                    return this.rows.get(row).getSecAddress();
                }
                case 2: {
                    return this.rows.get(row).getUid();
                }
                case 3: {
                    return this.rows.get(row).getVersion();
                }
            }
            return null;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Address";
                }
                case 1: {
                    return "Sec Addr";
                }
                case 2: {
                    return "Uid";
                }
                case 3: {
                    return "Version";
                }
            }
            return "?";
        }
    }

    class NrioMatchTable
    extends BTable {
        MatchTableModel tableModel;

        public NrioMatchTable() {
            this.tableModel = new MatchTableModel();
            this.setModel(this.tableModel);
            this.setMultipleSelection(false);
            this.setHeaderRenderer(new MatchHeaderRenderer());
        }

        public void addRow(byte[] data) {
            this.tableModel.addRow(data);
        }

        public void clear() {
            this.tableModel.clearTable();
        }
    }
}

