/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aceEdge.ui.nrio;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAceStatus;
import com.tridium.ace.ui.BAceComponentMenuAgent;
import com.tridium.ace.ui.BIAceAgent;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraSingleton
public class BAceNrioDeviceMenuAgent
extends BAceComponentMenuAgent
implements BIAceAgent {
    public static final BAceNrioDeviceMenuAgent INSTANCE = new BAceNrioDeviceMenuAgent();
    public static final Type TYPE = Sys.loadType(BAceNrioDeviceMenuAgent.class);
    private static final String WINK_ACTION_NAME = "wink";
    private static final String MATCH_CMD_NAME = "Match";
    private static final String PING_ACTION_NAME = "ping";

    public Type getType() {
        return TYPE;
    }

    public BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        if (!(target instanceof BAceComponent)) {
            return menu;
        }
        BAceComponent comp = (BAceComponent)target;
        return BAceNrioDeviceMenuAgent.updateItems(comp, menu);
    }

    private static BMenu updateItems(BAceComponent comp, BMenu menu) {
        BValue bv = comp.get("status");
        if (bv == null || !(bv instanceof BAceStatus)) {
            return menu;
        }
        int status = ((BAceStatus)bv).getValue();
        bv = comp.get("devAddress");
        if (bv == null || !(bv instanceof BInteger)) {
            return menu;
        }
        int devAddress = ((BInteger)bv).getInt();
        if (devAddress != -1) {
            BAceNrioDeviceMenuAgent.setActionEnabled(menu, PING_ACTION_NAME, true);
            if (status == 0) {
                BAceNrioDeviceMenuAgent.setActionEnabled(menu, WINK_ACTION_NAME, true);
                BAceNrioDeviceMenuAgent.setActionEnabled(menu, MATCH_CMD_NAME, false);
            } else {
                BAceNrioDeviceMenuAgent.setActionEnabled(menu, WINK_ACTION_NAME, false);
                BAceNrioDeviceMenuAgent.setActionEnabled(menu, MATCH_CMD_NAME, true);
            }
        } else {
            BAceNrioDeviceMenuAgent.setActionEnabled(menu, PING_ACTION_NAME, false);
            BAceNrioDeviceMenuAgent.setActionEnabled(menu, WINK_ACTION_NAME, false);
            BAceNrioDeviceMenuAgent.setActionEnabled(menu, MATCH_CMD_NAME, true);
        }
        menu.removeConsecutiveSeparators();
        return menu;
    }

    private static void setActionEnabled(BMenu menu, String actionName, boolean enable) {
        BMenuItem[] mia;
        BMenu actions = menu.getSubMenu("actions");
        for (BMenuItem item : mia = actions.getMenuItems()) {
            if (!item.getText().equals(actionName)) continue;
            item.setEnabled(enable);
            String newName = actionName.substring(0, 1).toUpperCase() + actionName.substring(1);
            item.setText(newName);
            break;
        }
    }
}

