/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusServerNumericProxyExt
extends BModbusServerProxyExt
implements BIModbusNumericProxyExt {
    public static final Property regType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property dataType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Type TYPE = Sys.loadType(BModbusServerNumericProxyExt.class);

    @Override
    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    @Override
    public void setRegType(BRegisterTypeEnum v) {
        this.set(regType, (BValue)v, null);
    }

    @Override
    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    @Override
    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
        int numRegisters = 1;
        if (!this.isDataTypeInteger()) {
            numRegisters *= 2;
        }
        ModbusResponse rsp = new ModbusResponse(this.modbusNet().getModbusMode(), device);
        int pointAddress = this.getDataAddress().getDataAddress();
        try {
            rsp.data = this.isHoldingRegisterType() ? device.getHoldingRegisterValues(pointAddress, numRegisters) : device.getInputRegisterValues(pointAddress, numRegisters);
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericProxyExt.read() caught exception: ", (Throwable)e);
            }
            this.readFail("Exception during read (" + e + ")");
            return;
        }
        rsp.exceptionCode = 0;
        rsp.byteCount = (byte)rsp.data.length;
        rsp.numberPoints = numRegisters;
        this.setOutValues(rsp);
    }

    private void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(rec, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(rec, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(rec, 4);
            }
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setIntegerOutValues(ModbusResponse rec, int dataSize) {
        long regValue;
        try {
            regValue = rec.getRegister(0, dataSize, ((BModbusServerDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing integer value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    private void setFloatOutValues(ModbusResponse rec, int dataSize) {
        float regValue;
        try {
            regValue = rec.getFloat(0, dataSize, ((BModbusServerDevice)this.getDevice()).isFloat3210Order());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(dataType)) {
            this.setStale(true, null);
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        } else if (prop.equals(regType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusHoldingAddress()) {
                    if (!this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                    }
                } else if (this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    @Override
    protected boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (!this.isDataTypeInteger()) {
                numRegs *= 2;
            }
            if (this.isHoldingRegisterType()) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        if (addr.isModbusAnalogAddress()) {
            BRegisterTypeEnum rType = BRegisterTypeEnum.holding;
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                rType = BRegisterTypeEnum.input;
            }
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (!this.isDataTypeInteger()) {
                numRegs *= 2;
            }
            if (rType.equals((Object)BRegisterTypeEnum.holding)) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        return false;
    }

    private boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    private boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    public boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType) || this.getDataType().equals((Object)BDataTypeEnum.unsignedLong);
    }

    public boolean isDataTypeSignedLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public boolean isDataTypeUnsignedLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.unsignedLong);
    }

    public boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    private boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer float point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    private boolean updateOutput(BStatusValue out) {
        double fValue = ((BStatusNumeric)out).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork network = (BModbusServerNetwork)this.modbusNet();
            int count = 1;
            int address = device.getDeviceAddress();
            int pointAddress = this.getDataAddress().getDataAddress();
            byte[] dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(fValue) : (this.isDataTypeLong() ? this.setLongByteArray(fValue) : this.setFloatByteArray(fValue));
            if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                count *= 2;
            }
            if (this.isHoldingRegisterType()) {
                device.setHoldingRegisterValues(pointAddress, dataOut);
            } else {
                device.setInputRegisterValues(pointAddress, dataOut);
            }
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericWritableProxyExt.updateOutput() caught exception: ", (Throwable)e);
            }
            this.writeFail("Error when writing (" + e + ")");
            return false;
        }
        this.writeOk(out);
        return true;
    }

    private byte[] setIntegerByteArray(double fValue) {
        byte[] ba = new byte[2];
        fValue = fValue >= 0.0 ? (fValue += 0.5) : (fValue -= 0.5);
        double maxValue = 65535.0;
        double minValue = 0.0;
        if (this.isDataTypeSigned()) {
            maxValue = 32767.0;
            minValue = -32768.0;
        }
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        int intValue = (int)fValue;
        ba[0] = (byte)((intValue & 0xFF00) >> 8);
        ba[1] = (byte)(intValue & 0xFF);
        return ba;
    }

    private byte[] setLongByteArray(double fValue) {
        double minValue;
        byte[] ba = new byte[4];
        fValue = fValue >= 0.0 ? (fValue += 0.5) : (fValue -= 0.5);
        double maxValue = this.isDataTypeSigned() ? 2.147483647E9 : 4.294967295E9;
        double d = minValue = this.isDataTypeSigned() ? -2.147483648E9 : 0.0;
        if (fValue > maxValue) {
            fValue = maxValue;
        } else if (fValue < minValue) {
            fValue = minValue;
        }
        long longVvalue = (long)fValue;
        if (((BModbusServerDevice)this.getDevice()).isLong3210Order()) {
            ba[0] = (byte)((longVvalue & 0xFFFFFFFFFF000000L) >> 24);
            ba[1] = (byte)((longVvalue & 0xFF0000L) >> 16);
            ba[2] = (byte)((longVvalue & 0xFF00L) >> 8);
            ba[3] = (byte)(longVvalue & 0xFFL);
        } else {
            ba[0] = (byte)((longVvalue & 0xFF00L) >> 8);
            ba[1] = (byte)(longVvalue & 0xFFL);
            ba[2] = (byte)((longVvalue & 0xFFFFFFFFFF000000L) >> 24);
            ba[3] = (byte)((longVvalue & 0xFF0000L) >> 16);
        }
        return ba;
    }

    private byte[] setFloatByteArray(double fValue) {
        byte[] ba = new byte[4];
        int floatBits = Float.floatToIntBits((float)fValue);
        if (((BModbusServerDevice)this.getDevice()).isFloat3210Order()) {
            ba[0] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[1] = (byte)((floatBits & 0xFF0000) >> 16);
            ba[2] = (byte)((floatBits & 0xFF00) >> 8);
            ba[3] = (byte)(floatBits & 0xFF);
        } else {
            ba[0] = (byte)((floatBits & 0xFF00) >> 8);
            ba[1] = (byte)(floatBits & 0xFF);
            ba[2] = (byte)((floatBits & 0xFF000000) >> 24);
            ba[3] = (byte)((floatBits & 0xFF0000) >> 16);
        }
        return ba;
    }
}

