/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;

public class ModbusResponse
extends ModbusMessage {
    public int exceptionCode;
    public int startAddress;
    public int numberPoints;
    public int byteCount;
    public byte[] data = new byte[255];

    public ModbusResponse(int comType, BModbusDevice modDevice) {
        super(comType, modDevice);
    }

    public ModbusResponse(int comType, BModbusDevice modDevice, ModbusWriteRequest writeRequest) {
        super(comType, modDevice);
        this.deviceAddress = writeRequest.deviceAddress;
        this.functionCode = writeRequest.functionCode;
        this.startAddress = writeRequest.startAddress;
        this.numberPoints = writeRequest.numberPoints;
        this.byteCount = writeRequest.byteCount;
        this.data = new byte[writeRequest.data.length];
        for (int i = 0; i < writeRequest.data.length; ++i) {
            this.data[i] = writeRequest.data[i];
        }
    }

    @Override
    public final void writeRtu(OutputStream out) throws IOException {
        ModbusOutputStream modOut = this.formatBaseMessage();
        modOut.writeCRC();
        out.write(modOut.toByteArray());
    }

    @Override
    public void writeAscii(OutputStream out) throws IOException {
        ModbusOutputStream modOut = this.formatBaseMessage();
        modOut.writeLRC();
        out.write(modOut.toAsciiHexByteArray());
    }

    @Override
    public void writeTcp(OutputStream out) throws IOException {
        ModbusOutputStream modOut = this.formatBaseMessage();
        byte[] ba = modOut.toByteArray();
        modOut = new ModbusOutputStream();
        modOut.write((byte)((this.transactionIdentifier & 0xFF00) >> 8));
        modOut.write((byte)(this.transactionIdentifier & 0xFF));
        modOut.write((byte)0);
        modOut.write((byte)0);
        int msgLen = ba.length;
        modOut.write((byte)((msgLen & 0xFF00) >> 8));
        modOut.write((byte)(msgLen & 0xFF));
        modOut.write(ba);
        out.write(modOut.toByteArray());
    }

    protected ModbusOutputStream formatBaseMessage() throws IOException {
        ModbusOutputStream out = new ModbusOutputStream();
        out.write((byte)this.deviceAddress);
        out.write((byte)this.functionCode);
        switch (this.functionCode) {
            case 5: 
            case 6: {
                out.writeWord(this.startAddress);
                out.write(this.data);
                break;
            }
            case 15: 
            case 16: {
                out.writeWord(this.startAddress);
                out.writeWord(this.numberPoints);
                break;
            }
            default: {
                out.write((byte)this.byteCount);
                if ((this.functionCode & 0x80) != 0) break;
                out.write(this.data);
            }
        }
        return out;
    }

    public boolean isError() {
        return this.exceptionCode != 0;
    }

    public String getString(int length) {
        if (length > this.byteCount) {
            throw new IllegalArgumentException("Incomplete string returned: ");
        }
        byte[] byteArray = new byte[this.byteCount];
        for (int i = 0; i < this.byteCount; ++i) {
            byteArray[i] = this.data[i];
        }
        return new String(byteArray, StandardCharsets.UTF_8);
    }

    public boolean getBinary(int index) {
        if (index >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        int byteOffset = index / 8;
        int bitOffset = index % 8;
        if (byteOffset >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        return (this.data[byteOffset] & 1 << bitOffset) != 0;
    }

    public long getRegister(int index, int dataSize) {
        return this.getRegister(index, dataSize, false);
    }

    public long getRegister(int index, int dataSize, boolean bigEndian) {
        return this.getRegister(index, dataSize, bigEndian, false);
    }

    public long getRegister(int index, int dataSize, boolean bigEndian, boolean signed) {
        long value = 0L;
        if (index >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        int byteOffset = index * dataSize;
        if (byteOffset >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        switch (dataSize) {
            case 2: {
                int iValue = this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset] & 0xFF) << 8;
                if (signed && iValue >= 32768) {
                    iValue |= 0xFFFF0000;
                }
                return iValue;
            }
            case 4: {
                value = bigEndian ? (long)(this.data[byteOffset + 3] & 0xFF | (this.data[byteOffset + 2] & 0xFF) << 8 | (this.data[byteOffset + 1] & 0xFF) << 16 | (this.data[byteOffset + 0] & 0xFF) << 24) : (long)(this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset + 0] & 0xFF) << 8 | (this.data[byteOffset + 3] & 0xFF) << 16 | (this.data[byteOffset + 2] & 0xFF) << 24);
                if (signed) {
                    return value;
                }
                return value &= 0xFFFFFFFFL;
            }
        }
        throw new IllegalArgumentException("Unsupported data size: " + dataSize);
    }

    public float getFloat(int index, int dataSize, boolean bigEndian) {
        if (index >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        int byteOffset = index * dataSize;
        if (byteOffset >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + index);
        }
        long bits = bigEndian ? (long)(this.data[byteOffset + 3] & 0xFF | (this.data[byteOffset + 2] & 0xFF) << 8 | (this.data[byteOffset + 1] & 0xFF) << 16 | (this.data[byteOffset + 0] & 0xFF) << 24) : (long)(this.data[byteOffset + 1] & 0xFF | (this.data[byteOffset + 0] & 0xFF) << 8 | (this.data[byteOffset + 3] & 0xFF) << 16 | (this.data[byteOffset + 2] & 0xFF) << 24);
        return Float.intBitsToFloat((int)bits);
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        String comTypeString = "RTU";
        if (this.comType == 0) {
            comTypeString = "ASCII";
        } else if (this.comType == 2) {
            comTypeString = "TCP";
        }
        sb.append("Modbus " + comTypeString + " Response Message = " + TextUtil.getClassName(this.getClass()));
        sb.append("\n  Tag = " + this.getTag());
        sb.append("\n  Modbus Device Address = " + (this.deviceAddress & 0xFF));
        sb.append("\n  Modbus Function Code = " + this.functionCode);
        sb.append("\n  Modbus Exception Code = " + this.exceptionCode);
        sb.append("\n  Modbus Data Starting Address = " + this.startAddress);
        sb.append("\n  Modbus Number of Data Points = " + this.numberPoints);
        sb.append("\n  Modbus Byte Count = " + this.byteCount);
        sb.append("\n  Modbus Transaction ID = " + this.transactionIdentifier);
        sb.append("\n  Modbus Data = " + ByteArrayUtil.toHexString((byte[])this.data));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out);
            sb.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])out.toByteArray()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getExceptionString() {
        switch (this.exceptionCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "illegal function";
            }
            case 2: {
                return "illegal data address";
            }
            case 3: {
                return "illegal data value";
            }
            case 4: {
                return "slave device failure";
            }
            case 5: {
                return "acknowledge";
            }
            case 6: {
                return "slave device busy";
            }
            case 7: {
                return "negative acknowledge";
            }
            case 8: {
                return "memory parity error";
            }
            case 9: {
                return "device timeout";
            }
            case 10: {
                return "gateway path unavailable";
            }
            case 11: {
                return "gateway target device failed to respond";
            }
            case -1: {
                return "crc error";
            }
            case -5: {
                return "lrc error";
            }
            case -2: {
                return "ok not active";
            }
            case -3: {
                return "unknown";
            }
            case -6: {
                return "down";
            }
            case -7: {
                return "fault";
            }
            case -8: {
                return "disabled";
            }
        }
        return "other error";
    }
}

