/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.point.BModbusClientNumericBitsProxyExt;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusEnumBitsProxyExt;
import javax.baja.control.BEnumPoint;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModbusClientEnumBitsProxyExt
extends BModbusClientNumericBitsProxyExt
implements BIModbusEnumBitsProxyExt {
    public static final Type TYPE = Sys.loadType(BModbusClientEnumBitsProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(rec, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(rec, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(rec, 4);
            }
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setIntegerOutValues(ModbusResponse rec, int dataSize) {
        int regValue;
        try {
            regValue = this.getBitsValue((int)rec.getRegister(0, dataSize, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()));
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing integer value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusEnum(this.getEnum(regValue)));
    }

    private void setFloatOutValues(ModbusResponse rec, int dataSize) {
        float regValue;
        try {
            regValue = this.getBitsValue(rec.getFloat(0, dataSize, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()));
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusEnum(this.getEnum((int)regValue)));
    }

    @Override
    public boolean updateOutput(BStatusValue out) {
        ModbusWriteRequest writeReq;
        int ordinal = ((BStatusEnum)out).getValue().getOrdinal();
        if (ordinal > this.getMask()) {
            this.writeFail("Enum ordinal " + ordinal + " is greater than maximum value of " + this.getMask() + " (" + this.getNumberOfBits() + " bits)");
            return false;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork network = (BModbusClientNetwork)this.modbusNet();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int count = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            count *= 2;
        }
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest readReq = new ModbusReadRequest(network.getModbusMode(), device, address, code, pointAddress, count);
        ModbusResponse resp = (ModbusResponse)device.sendModbusMessage(readReq);
        if (resp == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        byte[] dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(this.mergeBitsValue(ordinal, (float)resp.getRegister(0, 2, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : (this.isDataTypeLong() ? this.setIntegerByteArray(this.mergeBitsValue(ordinal, (float)resp.getRegister(0, 4, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : this.setFloatByteArray(this.mergeBitsValue(ordinal, resp.getFloat(0, 4, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()))));
        code = 6;
        if (device.isPresetMultiple()) {
            code = 16;
        }
        if ((resp = (ModbusResponse)device.sendModbusMessage(writeReq = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress, count, dataOut))) == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        if (code == 6 && count > 1) {
            dataOut[0] = dataOut[2];
            dataOut[1] = dataOut[3];
            writeReq = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress + 1, 1, dataOut);
            resp = (ModbusResponse)device.sendModbusMessage(writeReq);
            if (resp == null) {
                resp = new ModbusResponse(network.getModbusMode(), device);
                resp.exceptionCode = 9;
            }
            if (resp.isError() && resp.exceptionCode != 5) {
                this.writeFail(resp.getExceptionString());
                return false;
            }
        }
        this.writeOk(out);
        return true;
    }

    private BEnum getEnum(int ordinal) {
        BEnumRange range = (BEnumRange)((BEnumPoint)this.getParent()).getFacets().get("range");
        if (range == null) {
            return BDynamicEnum.make((int)ordinal);
        }
        return range.get(ordinal, true);
    }

    @Override
    public float mergeBitsValue(float val, float reg) {
        return this.mergeBitsValue((int)val, reg);
    }

    @Override
    public float mergeBitsValue(int val, float reg) {
        float outVal = ((BEnumPoint)this.getParent()).getOut().getValue().getOrdinal();
        return (int)reg & ~this.getRegisterMask() | val << this.getBeginningBit();
    }
}

