/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDevicePollConfigEntry
extends BComponent
implements ModbusMessageConst {
    public static final Property enabled = BDevicePollConfigEntry.newProperty((int)0, (boolean)true, null);
    public static final Property startAddress = BDevicePollConfigEntry.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property dataType = BDevicePollConfigEntry.newProperty((int)0, (BValue)BRegisterTypesEnum.holdingRegister, null);
    public static final Property consecutivePointsToPoll = BDevicePollConfigEntry.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)9999));
    public static final Property readGroupSize = BDevicePollConfigEntry.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    public static final Property readStatus = BDevicePollConfigEntry.newProperty((int)3, (BValue)new BCommStatus(-2), null);
    public static final Type TYPE = Sys.loadType(BDevicePollConfigEntry.class);
    private byte[] byteArray = null;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BFlexAddress getStartAddress() {
        return (BFlexAddress)this.get(startAddress);
    }

    public void setStartAddress(BFlexAddress v) {
        this.set(startAddress, (BValue)v, null);
    }

    public BRegisterTypesEnum getDataType() {
        return (BRegisterTypesEnum)this.get(dataType);
    }

    public void setDataType(BRegisterTypesEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    public int getConsecutivePointsToPoll() {
        return this.getInt(consecutivePointsToPoll);
    }

    public void setConsecutivePointsToPoll(int v) {
        this.setInt(consecutivePointsToPoll, v, null);
    }

    public int getReadGroupSize() {
        return this.getInt(readGroupSize);
    }

    public void setReadGroupSize(int v) {
        this.setInt(readGroupSize, v, null);
    }

    public BCommStatus getReadStatus() {
        return (BCommStatus)this.get(readStatus);
    }

    public void setReadStatus(BCommStatus v) {
        this.set(readStatus, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDevicePollConfigEntry() {
    }

    public BDevicePollConfigEntry(boolean enabled, BRegisterTypesEnum dataType, BFlexAddress startAddress, int consecutiveNum, int readSize) {
        this.setEnabled(enabled);
        this.setDataType(dataType);
        this.setStartAddress(startAddress);
        this.setConsecutivePointsToPoll(consecutiveNum);
        this.setReadGroupSize(readSize);
    }

    public BDevicePollConfigEntry(BDevicePollConfigEntry src) {
        this.copyFrom((BComplex)src);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BDevicePollConfigTable;
    }

    public String toString(Context context) {
        return this.getDataType().getTag() + ": " + this.getStartAddress().getDataAddressNoModbusAltering() + " - " + (this.getStartAddress().getDataAddressNoModbusAltering() + this.getConsecutivePointsToPoll() - 1) + ": " + (this.getEnabled() ? this.getLexicon().getText("devicePoll.strings.enabled") : this.getLexicon().getText("devicePoll.strings.disabled"));
    }

    public String toDebugString() {
        return this.getDataType().getTag() + ": " + this.getStartAddress().getDataAddressNoModbusAltering() + " - " + (this.getStartAddress().getDataAddressNoModbusAltering() + this.getConsecutivePointsToPoll() - 1) + ": " + (this.getEnabled() ? "enabled" : "disabled");
    }

    public BModbusClientDevice getDevice() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BModbusClientDevice)) continue;
            return (BModbusClientDevice)parent;
        }
        return null;
    }

    public void validateAddress() {
        BFlexAddress regAddress = this.getStartAddress();
        if (regAddress.isModbusFormat()) {
            if (regAddress.isModbusHoldingAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.holdingRegister, null);
            } else if (regAddress.isModbusInputAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.inputRegister, null);
            } else if (regAddress.isModbusCoilAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.discreteCoil, null);
            } else if (regAddress.isModbusStatusAddress()) {
                this.set(dataType, (BValue)BRegisterTypesEnum.discreteInput, null);
            }
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(dataType) || property.equals(startAddress)) {
            if (context != null) {
                this.validateAddress();
                if (this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
                    ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
                }
            }
        } else if ((property.equals(enabled) || property.equals(consecutivePointsToPoll)) && this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public void setByteArray(byte[] data) {
        this.byteArray = data;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }
}

