/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.datatypes.BModbusConfig;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BModbusDevice
extends BBasicDevice {
    public static final Property deviceAddress = BModbusDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)247));
    public static final Property modbusConfig = BModbusDevice.newProperty((int)0, (BValue)new BModbusConfig(), null);
    public static final Type TYPE = Sys.loadType(BModbusDevice.class);
    private long totalMessages = 0L;
    private long totalCrcErrors = 0L;
    private long totalLrcErrors = 0L;
    private long totalTransactionIdErrors = 0L;
    private long timeouts = 0L;

    public int getDeviceAddress() {
        return this.getInt(deviceAddress);
    }

    public void setDeviceAddress(int v) {
        this.setInt(deviceAddress, v, null);
    }

    public BModbusConfig getModbusConfig() {
        return (BModbusConfig)this.get(modbusConfig);
    }

    public void setModbusConfig(BModbusConfig v) {
        this.set(modbusConfig, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BModbusDevice() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public boolean isFloat3210Order() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return this.getModbusConfig().getFloatByteOrder() == BDataByteOrderEnum.order3210;
        }
        return ((BModbusNetwork)this.getNetwork()).getFloatByteOrder() == BDataByteOrderEnum.order3210;
    }

    public boolean isLong3210Order() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return this.getModbusConfig().getLongByteOrder() == BDataByteOrderEnum.order3210;
        }
        return ((BModbusNetwork)this.getNetwork()).getLongByteOrder() == BDataByteOrderEnum.order3210;
    }

    public BModbusNetwork modbusNet() {
        return (BModbusNetwork)this.getNetwork();
    }

    public abstract BPointDeviceExt getPointDeviceExt();

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"ModbusDevice", 2);
        out.prop((Object)"Total Timeouts", (Object)new Long(this.timeouts));
        out.prop((Object)"Total CRC Errors", (Object)new Long(this.totalCrcErrors));
        out.prop((Object)"Total LRC Errors", (Object)new Long(this.totalLrcErrors));
        out.prop((Object)"Total Transaction ID Errors", (Object)new Long(this.totalTransactionIdErrors));
        out.endProps();
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementCrcErrors();
        }
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementLrcErrors();
        }
    }

    public final void incrementTransactionIdErrors() {
        ++this.totalTransactionIdErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementTransactionIdErrors();
        }
    }

    public int getModbusMode() {
        return 0;
    }

    public void incrementRequest() {
        ++this.totalMessages;
    }

    public void incrementTimeouts() {
        ++this.timeouts;
    }

    public long getTotalMessages() {
        return this.totalMessages;
    }

    public long getTotalCrcErrors() {
        return this.totalCrcErrors;
    }

    public long getTotalLrcErrors() {
        return this.totalLrcErrors;
    }

    public long getTotalTransactionIdErrors() {
        return this.totalTransactionIdErrors;
    }

    public long getTotalTimeouts() {
        return this.timeouts;
    }
}

