/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aceEdge;

import com.tridium.aceEdge.BAceEdgeNetwork;
import com.tridium.driver.util.DrUtil;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="trunk", type="int", defaultValue="1", flags=64, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="2")}), @NiagaraProperty(name="useAceNrio", type="boolean", defaultValue="false"), @NiagaraProperty(name="portName", type="String", defaultValue="COM1", flags=64)})
public class BNrioTrunk
extends BComponent {
    public static final Property faultCause = BNrioTrunk.newProperty((int)67, (String)"", null);
    public static final Property trunk = BNrioTrunk.newProperty((int)64, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)2)));
    public static final Property useAceNrio = BNrioTrunk.newProperty((int)0, (boolean)false, null);
    public static final Property portName = BNrioTrunk.newProperty((int)64, (String)"COM1", null);
    public static final Type TYPE = Sys.loadType(BNrioTrunk.class);
    private static final String ACE_HOME = Sys.getProtectedStationHome() + "/ace";
    private static final String ACE_ENABLE_NRIO = ACE_HOME + "/enableNrio";
    private static final String PROPERTY_NRIO_NETWORK_TRUNK = "trunk";

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public int getTrunk() {
        return this.getInt(trunk);
    }

    public void setTrunk(int v) {
        this.setInt(trunk, v, null);
    }

    public boolean getUseAceNrio() {
        return this.getBoolean(useAceNrio);
    }

    public void setUseAceNrio(boolean v) {
        this.setBoolean(useAceNrio, v, null);
    }

    public String getPortName() {
        return this.getString(portName);
    }

    public void setPortName(String v) {
        this.setString(portName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == useAceNrio || p == trunk || p == portName) {
            this.updateAceNrio();
        }
    }

    private void updateAceNrio() {
        BAceIpcPlatformService service = (BAceIpcPlatformService)Sys.getService((Type)BAceIpcPlatformService.TYPE);
        BAceEdgeNetwork aceNet = (BAceEdgeNetwork)DrUtil.getParent((BComplex)this, (Type)BAceEdgeNetwork.TYPE);
        this.handleUseAceNrio(service, aceNet.getEnabled());
    }

    public void updateAceNrio(BAceIpcPlatformService service, boolean aceEnabled) {
        this.handleUseAceNrio(service, aceEnabled);
    }

    private void handleUseAceNrio(BAceIpcPlatformService service, boolean aceEnabled) {
        boolean useAceNrio = this.getUseAceNrio();
        int trunk = this.getTrunk();
        BAceEdgeNetwork aceNet = (BAceEdgeNetwork)DrUtil.getParent((BComplex)this, (Type)BAceEdgeNetwork.TYPE);
        BISerialService serialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        serialService.checkPropertiesLoaded();
        String owner = null;
        if (useAceNrio && aceEnabled) {
            boolean trunkInUse = this.isNrioTrunkInUse(trunk);
            if (trunkInUse) {
                String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.NrioTrunkInUse").getText(null);
                aceNet.log().log(Level.SEVERE, errString);
                aceNet.configFatal(errString);
                this.setFaultCause(errString);
                return;
            }
            try {
                owner = serialService.getCurrentOwner(this.getPortName());
                if (owner.equals("none")) {
                    this.lockPortForAceEdge();
                } else if (!owner.equals(aceNet.getName())) {
                    String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.ComPortNotAvailable").getText(null);
                    aceNet.log().log(Level.SEVERE, errString);
                    aceNet.configFatal(errString);
                    this.setFaultCause(errString);
                    return;
                }
            }
            catch (Exception e) {
                String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.ComPortNotAvailable").getText(null);
                aceNet.log().log(Level.SEVERE, errString, e);
                aceNet.configFatal(errString);
                this.setFaultCause(errString);
                return;
            }
            try {
                this.verifyAceNrio(true, trunk, this.getOsPortName());
            }
            catch (Exception e) {
                this.unlockPortForAceEdge();
                String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.CannotCreateAceCookie").getText(null);
                aceNet.log().log(Level.SEVERE, errString, e);
                aceNet.configFatal(errString);
                this.setFaultCause(errString);
                return;
            }
        }
        try {
            owner = serialService.getCurrentOwner(this.getPortName());
            if (owner.equals(aceNet.getName())) {
                this.unlockPortForAceEdge();
            }
        }
        catch (Exception e) {
            String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.ComPortNotAvailable").getText(null);
            aceNet.log().log(Level.SEVERE, errString, e);
            aceNet.configFatal(errString);
            this.setFaultCause(errString);
            return;
        }
        try {
            this.verifyAceNrio(false, trunk, this.getOsPortName());
        }
        catch (Exception e) {
            String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioTrunkError.CannotCreateAceCookie").getText(null);
            aceNet.log().log(Level.SEVERE, errString, e);
            aceNet.configFatal(errString);
            this.setFaultCause(errString);
        }
    }

    private boolean isNrioTrunkInUse(int checkTrunk) {
        boolean trunkInUse = false;
        try {
            BComponent[] nrioServices;
            for (BComponent eachNrioNetwork : nrioServices = Nre.getServiceManager().getServices("nrio:NrioNetwork")) {
                BInteger nrioNetTrunk;
                if (!((BDeviceNetwork)eachNrioNetwork).getEnabled() || checkTrunk != (nrioNetTrunk = (BInteger)eachNrioNetwork.get(PROPERTY_NRIO_NETWORK_TRUNK)).getInt()) continue;
                trunkInUse = true;
            }
        }
        catch (ServiceNotFoundException e) {
            trunkInUse = false;
        }
        return trunkInUse;
    }

    private void lockPortForAceEdge() throws PortDeniedException, PortNotFoundException {
        BAceEdgeNetwork aceNet = (BAceEdgeNetwork)DrUtil.getParent((BComplex)this, (Type)BAceEdgeNetwork.TYPE);
        String ownerString = aceNet.getName();
        BSerialPortPlatformService serialPlatService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
        BSerialPort serialPort = (BSerialPort)serialPlatService.get(this.getPortName());
        serialPort.lock(ownerString);
    }

    private void unlockPortForAceEdge() {
        BAceEdgeNetwork aceNet = (BAceEdgeNetwork)DrUtil.getParent((BComplex)this, (Type)BAceEdgeNetwork.TYPE);
        BSerialPortPlatformService serialPlatService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
        BSerialPort serialPort = (BSerialPort)serialPlatService.get(this.getPortName());
        try {
            serialPort.unlock();
        }
        catch (Exception e) {
            aceNet.log().log(Level.SEVERE, "Exception unlocking AceNetwork NRIO serial port", e);
        }
    }

    private String getOsPortName() {
        BSerialPortPlatformService serialPlatService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
        BSerialPort serialPort = (BSerialPort)serialPlatService.get(this.getPortName());
        return serialPort.getOsPortName();
    }

    private void verifyAceNrio(boolean set, int trunk, String portName) throws Exception {
        block17: {
            BAceEdgeNetwork aceNet = (BAceEdgeNetwork)DrUtil.getParent((BComplex)this, (Type)BAceEdgeNetwork.TYPE);
            if (set) {
                try (FileOutputStream fos = AccessController.doPrivileged(() -> new FileOutputStream(ACE_ENABLE_NRIO));){
                    AccessController.doPrivileged(() -> {
                        String line = trunk + "," + portName;
                        fos.write(line.getBytes(Charset.forName("UTF-8")));
                        return null;
                    });
                    break block17;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            try {
                AccessController.doPrivileged(() -> {
                    File aceEnableNrio = new File(ACE_ENABLE_NRIO);
                    if (aceEnableNrio.exists()) {
                        if (!aceEnableNrio.delete()) {
                            aceNet.log().severe("Error deleting cookie: " + aceEnableNrio);
                        } else {
                            aceNet.log().fine("Removed " + aceEnableNrio + " for ACE control of remote I/O on trunk " + trunk);
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAceEdgeNetwork;
    }
}

