/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aceEdge;

import com.tridium.ace.BAceIpcNetwork;
import com.tridium.ace.kit.ACE;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.aceEdge.BNrioTrunk;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import com.tridium.sys.Nre;
import java.util.logging.Level;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BAceEdgeNetwork
extends BAceIpcNetwork {
    public static final Type TYPE = Sys.loadType(BAceEdgeNetwork.class);
    private KitRegistry catalog = null;
    private static final String catalogAddress = "module://aceEdge/rc/catalog/catalog.json";
    private static int MAX_NRIO_TRUNKS = 1;

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            BIService srv = (BIService)Nre.getServiceManager().getService("edgeIo:EdgeIoNetwork");
            if (srv != null) {
                String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioNetworkError.TwoTypesOfNetwork").getText(null);
                this.configFatal(errString);
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    protected void verifyAce(BAceIpcPlatformService service, boolean aceEnabled) {
        try {
            BNrioTrunk[] aceNrioTrunks = (BNrioTrunk[])this.getChildren(BNrioTrunk.class);
            for (int i = 0; i < aceNrioTrunks.length; ++i) {
                BNrioTrunk nrio = aceNrioTrunks[i];
                nrio.updateAceNrio(service, aceEnabled);
            }
        }
        catch (Exception e) {
            this.log().log(Level.SEVERE, "Verify ACE Nrio failed: Unable to initialize ACE control of remote I/O", e);
            String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioNetworkError.UnableInitAce").getText(null);
            this.configFail(errString);
        }
    }

    public boolean isChildLegal(BComponent child) {
        BNrioTrunk[] aceNrioTrunks;
        if (child instanceof BNrioTrunk && (aceNrioTrunks = (BNrioTrunk[])this.getChildren(BNrioTrunk.class)).length > MAX_NRIO_TRUNKS) {
            String errString = LexiconText.make((Type)TYPE, (String)"AceEdgeNrioNetworkError.TrunkNumInvalid").getText(null, new Object[]{MAX_NRIO_TRUNKS});
            this.configFail(errString);
            return false;
        }
        return true;
    }

    public KitRegistry getNetworkKitRegistry() {
        if (this.catalog == null) {
            this.catalog = (KitRegistry)ACE.getKitRegistry((String)catalogAddress);
        }
        return this.catalog;
    }
}

