/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BHsTagDictionary;
import com.tridium.tagdictionary.condition.BAlways;
import com.tridium.tagdictionary.condition.BAnd;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import com.tridium.tagdictionary.condition.BHasAncestor;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.tagdictionary.condition.BOr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSimpleTagInfo;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

final class HsImportUtil {
    private static final HashMap<String, Type> tagTypeMap = new HashMap(11);
    private static final Logger LOGGER;
    private static final Lexicon LEX;
    private static final String HS_NAME_SPACE = "hs";
    private static final int PRECISION_2 = 2;
    private static final int INDX_E_NAME = 0;
    private static final int INDX_E_REMOVE = 1;
    private static final int INDX_E_HAS_TAGS = 2;
    private static final int INDX_E_IS_TYPE = 3;
    private static final int INDX_E_HAS_ANCESTOR = 4;
    private static final int INDX_E_FILTER = 5;
    private static final int INDX_E_TAGS = 6;
    private static final int INDX_E_MIN = 7;
    private static final int NAME_AND_REMOVE_MIN_LENGTH = 2;
    private static final int INDX_T_NAME = 0;
    private static final int INDX_T_TYPE = 1;
    private static final int INDX_T_VERSION = 1;
    private static final int INDX_T_SMART_TYPE = 2;
    private static final int INDX_T_IMP_HAS_TAGS = 3;
    private static final int INDX_T_IMP_IS_TYPE = 4;
    private static final int INDX_T_IMP_HAS_ANCESTORS = 5;
    private static final int INDX_T_IMP_FILTER = 6;
    private static final int INDX_T_VR_HAS_TAGS = 7;
    private static final int INDX_T_VR_IS_TYPE = 8;
    private static final int INDX_T_VR_HAS_ANCESTORS = 9;
    private static final int INDX_T_VR_FILTER = 10;
    private static final int INDX_T_UNITS = 11;
    private static final int NAME_AND_TYPE_MIN_LENGTH = 2;
    private static final String VERSION_STR = "version";
    private static final String MERGE_VERSION_STR = "$$version";

    private HsImportUtil() {
    }

    static void makeImportFile(BIFile source, BIFile dest, int headerSize) {
        try {
            InputStream in = source.getInputStream();
            OutputStream out = dest.getOutputStream();
            for (int i = 0; i < headerSize; ++i) {
                out.write(HsImportUtil.readLine(in).getBytes());
            }
            while (in.available() > 0) {
                String line = HsImportUtil.readLine(in);
                if (line.isEmpty() || line.startsWith("**")) {
                    out.write(line.getBytes());
                    continue;
                }
                out.write("## ".getBytes());
                out.write(line.getBytes());
            }
            out.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error making import file", e);
        }
    }

    static void importEquip(BHsTagDictionary dictionary, BCsvFile equipFile, Map<String, String[]> mergeEquip) {
        try {
            InputStream in = equipFile.getInputStream();
            HsImportUtil.readLine(in);
            HsImportUtil.readLine(in);
            while (in.available() > 0) {
                String line = HsImportUtil.readLine(in).trim();
                if (line.isEmpty() || line.startsWith("**")) continue;
                Object[] elems = TextUtil.splitAndTrim((String)line, (char)',');
                if (elems.length < 7) {
                    LOGGER.warning("equip line skipped because it is less than 7 elements: " + line);
                    continue;
                }
                if (HsImportUtil.areAllElemsEmpty((String[])elems)) continue;
                String name = elems[0];
                if (name.isEmpty()) {
                    LOGGER.warning("equip line skipped because its name column is empty: " + line);
                    continue;
                }
                if (mergeEquip.containsKey(name)) {
                    Object[] mergeElems = mergeEquip.remove(name);
                    if (mergeElems.length < 2) {
                        LOGGER.warning("merge equip.csv line skipped because it has less than 2 elements: " + Arrays.toString(mergeElems));
                    } else {
                        if ("remove".equalsIgnoreCase(mergeElems[1])) {
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.info("equip " + name + " removed by merged equip.csv");
                            continue;
                        }
                        if (elems.length < 7) {
                            LOGGER.warning("merge equip.csv line skipped because it is less than 7 elements: " + Arrays.toString(mergeElems));
                        } else {
                            elems = mergeElems;
                        }
                    }
                }
                HsImportUtil.processTagGroupLine(name, (String[])elems, dictionary);
            }
            for (Map.Entry<String, String[]> entry : mergeEquip.entrySet()) {
                Object[] mergeElems = entry.getValue();
                if (mergeElems.length < 7) {
                    LOGGER.warning("merge equip.csv line skipped because it is less than 7 elements: " + Arrays.toString(mergeElems));
                    continue;
                }
                if ("remove".equalsIgnoreCase(mergeElems[1])) {
                    LOGGER.warning("merge equip.csv line requests remove for tag group named " + entry.getKey() + " that does not exist in the standard set: " + Arrays.toString(mergeElems));
                    continue;
                }
                HsImportUtil.processTagGroupLine(entry.getKey(), (String[])mergeElems, dictionary);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while importing a equip tag groups from equip.csv file", e);
        }
    }

    private static void processTagGroupLine(String name, String[] elems, BHsTagDictionary dictionary) {
        BTagGroupInfo newGroup = HsImportUtil.addTagInfoForGroup(dictionary, elems);
        if (newGroup == null) {
            LOGGER.warning("Importing equipment: invalid group on line: " + Arrays.toString(elems));
            return;
        }
        if (dictionary.getTagGroupDefinitions().get(name) != null) {
            LOGGER.warning("TagGroup with this name already exists: " + name);
        } else {
            dictionary.getTagGroupDefinitions().add(name, (BValue)newGroup, null);
        }
    }

    private static boolean areAllElemsEmpty(String[] elems) {
        for (String elem : elems) {
            if (elem.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static HashMap<String, String[]> importMergeCsv(BCsvFile mergeTagsCsv, boolean includeVersion) {
        HashMap<String, String[]> mergeTags = new HashMap<String, String[]>();
        String fileName = mergeTagsCsv.getFileName();
        try {
            InputStream in = mergeTagsCsv.getInputStream();
            String versionLine = HsImportUtil.readLine(in);
            if (includeVersion) {
                if (versionLine.startsWith(VERSION_STR)) {
                    String[] elems = TextUtil.splitAndTrim((String)versionLine, (char)',');
                    if (elems.length < 1 || elems[1].isEmpty()) {
                        LOGGER.severe(LEX.get("tagImport.missingVersion"));
                        return mergeTags;
                    }
                    elems[0] = MERGE_VERSION_STR;
                    mergeTags.put(elems[0], elems);
                    HsImportUtil.readLine(in);
                } else {
                    LOGGER.severe(LEX.get("tagImport.missingVersion"));
                    return mergeTags;
                }
            }
            HsImportUtil.readLine(in);
            while (in.available() > 0) {
                String[] elems;
                String line = HsImportUtil.readLine(in).trim();
                if (line.isEmpty() || line.startsWith("**") || HsImportUtil.areAllElemsEmpty(elems = TextUtil.splitAndTrim((String)line, (char)','))) continue;
                if (elems[0].isEmpty()) {
                    LOGGER.warning(fileName + " line skipped because its name column is empty: " + line);
                    continue;
                }
                mergeTags.put(elems[0], elems);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while importing the merge tags for the haystack dictionary from: " + fileName, e);
        }
        return mergeTags;
    }

    static void importTags(BHsTagDictionary dictionary, BCsvFile csvFile, Map<String, String[]> mergeTags) {
        BTagInfoList tagInfos = dictionary.getTagDefinitions();
        BRelationInfoList relationInfos = dictionary.getRelationDefinitions();
        try {
            InputStream in = csvFile.getInputStream();
            String versionLine = HsImportUtil.readLine(in);
            if (versionLine.startsWith(VERSION_STR)) {
                String[] elems = TextUtil.splitAndTrim((String)versionLine, (char)',');
                String version = HsImportUtil.getVersionFrom(elems, mergeTags);
                if (version != null) {
                    dictionary.setVersion(version);
                }
            } else {
                LOGGER.severe(LEX.get("missingVersion"));
                dictionary.setStatus(BStatus.makeFault((BStatus)dictionary.getStatus(), (boolean)true));
                dictionary.setFaultCause(LEX.getText("importDictionary.missingVersion"));
                return;
            }
            HsImportUtil.readLine(in);
            HsImportUtil.readLine(in);
            while (in.available() > 0) {
                String line = HsImportUtil.readLine(in).trim();
                if (line.isEmpty()) continue;
                Object[] elems = TextUtil.splitAndTrim((String)line, (char)',');
                if (line.startsWith("**")) continue;
                if (elems.length < 2) {
                    LOGGER.warning("tag line skipped because it is less than 2 elements: " + line);
                    continue;
                }
                if (HsImportUtil.areAllElemsEmpty((String[])elems)) continue;
                String name = elems[0];
                if (name.isEmpty()) {
                    LOGGER.warning("tag line skipped because its name column is empty: " + line);
                    continue;
                }
                if (mergeTags.containsKey(name)) {
                    Object[] mergeElems = mergeTags.remove(name);
                    if (mergeElems.length < 2) {
                        LOGGER.warning("merge tags.csv line skipped because it has less than 2 elements: " + Arrays.toString(mergeElems));
                    } else {
                        if ("remove".equalsIgnoreCase(mergeElems[1])) {
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.info("tag " + name + " removed by merged tags.csv");
                            continue;
                        }
                        elems = mergeElems;
                    }
                }
                HsImportUtil.processTagLine((String[])elems, dictionary, relationInfos, tagInfos);
            }
            for (Map.Entry<String, String[]> entry : mergeTags.entrySet()) {
                Object[] mergeElems = entry.getValue();
                if (mergeElems.length < 2) {
                    LOGGER.warning("merge tags.csv line skipped because it has less than 2 elements: " + Arrays.toString(mergeElems));
                    continue;
                }
                if ("remove".equalsIgnoreCase(mergeElems[1])) {
                    LOGGER.warning("merge tags.csv line requests remove for tag named " + entry.getKey() + " that does not exist in the standard set: " + Arrays.toString(mergeElems));
                    continue;
                }
                HsImportUtil.processTagLine((String[])mergeElems, dictionary, relationInfos, tagInfos);
            }
            HsImportUtil.orderByName((BComponent)tagInfos);
            HsImportUtil.orderByName((BComponent)relationInfos);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while importing a haystack dictionary from tags.csv.", e);
        }
    }

    private static String getVersionFrom(String[] elems, Map<String, String[]> mergeTags) {
        String version = null;
        if (elems.length > 1 && elems[0].equalsIgnoreCase(VERSION_STR)) {
            String[] mergeElems;
            if (!elems[1].isEmpty()) {
                version = elems[1];
            }
            if (mergeTags.containsKey(MERGE_VERSION_STR) && (mergeElems = mergeTags.remove(MERGE_VERSION_STR)).length > 1 && !mergeElems[1].isEmpty()) {
                version = mergeElems[1] + ' ' + LEX.getText("tagImport.versionSuffix");
            }
        }
        return version;
    }

    private static void processTagLine(String[] elems, BHsTagDictionary dictionary, BRelationInfoList relationInfos, BTagInfoList tagInfos) {
        try {
            String units;
            BSimpleTagInfo newTag;
            String name;
            block24: {
                String smartType;
                BIDataValue defaultValue;
                String type = elems[1];
                name = elems[0];
                if ("Ref".equals(type) && !"id".equals(name)) {
                    BRelationInfo newRelationInfo = new BRelationInfo();
                    String smartType2 = elems.length > 2 ? elems[2] : null;
                    boolean isSmartRelation = false;
                    if (smartType2 != null && !smartType2.isEmpty()) {
                        try {
                            newRelationInfo = (BRelationInfo)BTypeSpec.make((String)smartType2).getResolvedType().getInstance();
                            isSmartRelation = true;
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Invalid smartTagType for: " + name, e);
                        }
                    }
                    BRelationInfo addedRelInfo = (BRelationInfo)relationInfos.get(relationInfos.add(name, (BValue)newRelationInfo));
                    if (!isSmartRelation) {
                        return;
                    }
                    BTagRuleCondition impliedRuleCondition = null;
                    if (elems.length > 6) {
                        impliedRuleCondition = HsImportUtil.makeValidityRule(elems[3], elems[4], elems[5], elems[6]);
                    }
                    if (impliedRuleCondition != null) {
                        HsImportUtil.addImpliedRule(dictionary, addedRelInfo, impliedRuleCondition);
                    } else {
                        HsImportUtil.addImpliedRule(dictionary, addedRelInfo, (BTagRuleCondition)new BAlways());
                    }
                    return;
                }
                Type importType = tagTypeMap.get(type.toLowerCase());
                if (importType == null) {
                    LOGGER.warning("Type " + type + " not supported; skipping line: " + Arrays.toString(elems));
                    return;
                }
                if (importType.isAbstract()) {
                    TypeInfo[] concreteTypes = Sys.getRegistry().getConcreteTypes(importType.getTypeInfo());
                    defaultValue = (BIDataValue)concreteTypes[0];
                } else {
                    defaultValue = (BIDataValue)importType.getInstance();
                }
                newTag = new BSimpleTagInfo(defaultValue);
                String string = smartType = elems.length > 2 ? elems[2] : null;
                if (smartType != null && !smartType.isEmpty()) {
                    try {
                        newTag = (BTagInfo)BTypeSpec.make((String)smartType).getResolvedType().getInstance();
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Invalid smartTagType for: " + name, e);
                        }
                        if (!LOGGER.isLoggable(Level.WARNING)) break block24;
                        LOGGER.warning("Invalid smartTagType for: " + name);
                    }
                }
            }
            BTagRuleCondition tagValidityRule = null;
            if (elems.length > 10) {
                tagValidityRule = HsImportUtil.makeValidityRule(elems[7], elems[8], elems[9], elems[10]);
            }
            if (tagValidityRule != null) {
                newTag.setValidity(tagValidityRule);
            }
            BTagInfo addedTag = (BTagInfo)tagInfos.get(tagInfos.add(name, (BValue)newTag));
            BTagRuleCondition impliedRuleCondition = null;
            if (elems.length > 6) {
                impliedRuleCondition = HsImportUtil.makeValidityRule(elems[3], elems[4], elems[5], elems[6]);
            }
            if (impliedRuleCondition != null) {
                HsImportUtil.addImpliedRule(dictionary, addedTag, impliedRuleCondition);
            }
            String string = units = elems.length > 11 ? elems[11] : null;
            if (units != null && !units.isEmpty()) {
                try {
                    BUnit defUnit = UnitDatabase.getUnit((String)units);
                    BFacets defFacets = BFacets.makeNumeric((BUnit)defUnit, (int)2);
                    addedTag.add("defFacets", (BValue)defFacets);
                }
                catch (UnitException e) {
                    LOGGER.log(Level.FINE, "Unit " + units + " not found", e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while importing a haystack dictionary from tags.csv.", e);
        }
    }

    static void orderByName(BComponent comp) {
        Object[] properties = comp.getDynamicPropertiesArray();
        if (properties.length <= 0) {
            return;
        }
        Object[] keys = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            keys[i] = properties[i].getName();
        }
        SortUtil.sort((Object[])keys, (Object[])properties, (boolean)true);
        comp.reorder((Property[])properties);
    }

    private static void addImpliedRule(BHsTagDictionary dictionary, BTagInfo tagInfo, BTagRuleCondition condition) {
        BTagRuleList tagRuleList = dictionary.getTagRules();
        if (tagRuleList.get(tagInfo.getName()) == null) {
            BTagRule impliedTagRule = new BTagRule();
            impliedTagRule.setCondition(condition);
            impliedTagRule.getTagList().add(tagInfo.getName(), tagInfo.newCopy());
            tagRuleList.add(tagInfo.getName(), (BValue)impliedTagRule);
        }
    }

    private static void addImpliedRule(BHsTagDictionary dictionary, BRelationInfo relationInfo, BTagRuleCondition condition) {
        BTagRuleList tagRuleList = dictionary.getTagRules();
        if (tagRuleList.get(relationInfo.getName()) == null) {
            BTagRule impliedTagRule = new BTagRule();
            impliedTagRule.setCondition(condition);
            impliedTagRule.getRelationList().add(relationInfo.getName(), relationInfo.newCopy());
            tagRuleList.add(relationInfo.getName(), (BValue)impliedTagRule);
        }
    }

    private static String readLine(InputStream in) throws IOException {
        String line = "";
        StringBuffer sb = new StringBuffer();
        while (in.available() > 0) {
            char data = (char)in.read();
            sb.append(data);
            if (data != '\n') continue;
            line = sb.toString();
            if (line.charAt(0) != '#') break;
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            line = sb.toString();
        }
        if (!line.isEmpty() && line.charAt(0) == '#') {
            line = "";
        }
        return line;
    }

    private static BTagGroupInfo addTagInfoForGroup(BHsTagDictionary dictionary, String[] elems) {
        if (elems.length < 7) {
            LOGGER.warning("tag group elems are less than 7 elements: " + Arrays.toString(elems));
            return null;
        }
        try {
            BTagGroupInfo tagGroup = new BTagGroupInfo();
            String[] tagKeys = TextUtil.splitAndTrim((String)elems[6], (char)' ');
            String[] defaultValues = HsImportUtil.parseDefaultValues(tagKeys);
            for (int i = 0; i < tagKeys.length; ++i) {
                BTagRuleCondition validity;
                BIDataValue overrideValue;
                String key = tagKeys[i];
                BTagInfo tagInfo = (BTagInfo)dictionary.getTagDefinitions().get(key);
                if (tagInfo == null) {
                    LOGGER.log(Level.WARNING, "undefined tag for group: {0}", tagKeys[i]);
                    continue;
                }
                BTagInfo addTagInfo = (BTagInfo)tagInfo.newCopy();
                BIDataValue defaultValue = tagInfo.getDefaultValue();
                if (addTagInfo instanceof BSimpleTagInfo && !(defaultValue instanceof BMarker) && (overrideValue = HsImportUtil.stringToDataValue(defaultValues[i], defaultValue.getType())) != null) {
                    ((BSimpleTagInfo)addTagInfo).setDefaultValue(overrideValue);
                }
                if ((validity = tagInfo.getValidity()) instanceof BAlways) {
                    tagInfo.setValidity((BTagRuleCondition)new BIsTypeCondition(BControlPoint.TYPE));
                }
                tagGroup.getTagList().add(key, (BValue)addTagInfo);
            }
            BTagRuleCondition ruleCondition = HsImportUtil.makeValidityRule(elems[2], elems[3], elems[4], elems[5]);
            if (ruleCondition != null) {
                tagGroup.setValidity(ruleCondition);
            }
            return tagGroup;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "AddTagInfoForGroup: " + e + " for line: " + Arrays.toString(elems), e);
            return null;
        }
    }

    private static BIDataValue stringToDataValue(String fromValue, Type toType) {
        if (toType.is(BString.TYPE)) {
            return BString.make((String)fromValue);
        }
        if (toType.is(BInteger.TYPE)) {
            return BInteger.make((String)fromValue);
        }
        if (toType.is(BLong.TYPE)) {
            return BLong.make((String)fromValue);
        }
        if (toType.is(BDouble.TYPE)) {
            return BDouble.make((String)fromValue);
        }
        if (toType.is(BFloat.TYPE)) {
            return BFloat.make((String)fromValue);
        }
        if (toType.is(BBoolean.TYPE)) {
            return BBoolean.make((String)fromValue);
        }
        LOGGER.warning("stringToDataValue: unsupported type: " + fromValue + " to " + toType);
        return null;
    }

    private static String[] parseDefaultValues(String[] tagKeys) {
        String[] defValues = new String[tagKeys.length];
        for (int i = 0; i < tagKeys.length; ++i) {
            String thisTagKey = tagKeys[i];
            int c1 = thisTagKey.indexOf(40);
            int c2 = thisTagKey.indexOf(41);
            if (c1 < 0 && c2 < 0) {
                defValues[i] = "";
                continue;
            }
            if (c1 > 0 && c2 > c1) {
                defValues[i] = thisTagKey.substring(c1 + 1, c2);
                tagKeys[i] = thisTagKey.substring(0, c1);
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning("Invalid tagGroup tag formatting ( tag(value): " + tagKeys[i]);
        }
        return defValues;
    }

    private static BTagRuleCondition makeValidityRule(String hasTags, String isTypes, String hasAncestors, String filter) {
        String[] types;
        String condFilter;
        String condFilter2;
        int condCount = 0;
        BBooleanFilter hasTagsCond = null;
        if (hasTags != null && !hasTags.isEmpty() && (condFilter2 = HsImportUtil.parseConditionString(hasTags, "or")) != null) {
            hasTagsCond = new BBooleanFilter(condFilter2);
            ++condCount;
        }
        BHasAncestor ancestorCond = null;
        if (hasAncestors != null && !hasAncestors.isEmpty() && (condFilter = HsImportUtil.parseConditionString(hasAncestors, "or")) != null) {
            ancestorCond = new BHasAncestor(condFilter);
            ++condCount;
        }
        BBooleanFilter filterCond = null;
        if (filter != null && !filter.isEmpty()) {
            filterCond = new BBooleanFilter(filter);
            ++condCount;
        }
        BOr isTypeCond = null;
        if (isTypes != null && !isTypes.isEmpty() && (types = TextUtil.splitAndTrim((String)isTypes, (char)' ')) != null && types.length > 0) {
            ArrayList<BIsTypeCondition> conditions = new ArrayList<BIsTypeCondition>(types.length);
            for (String type : types) {
                BTypeSpec typeSpec = BTypeSpec.make((String)type);
                if (typeSpec == null) continue;
                conditions.add(new BIsTypeCondition(typeSpec.getResolvedType()));
            }
            if (!conditions.isEmpty()) {
                if (conditions.size() == 1) {
                    isTypeCond = (BTagRuleCondition)conditions.get(0);
                } else {
                    isTypeCond = new BOr();
                    for (BIsTypeCondition cond : conditions) {
                        isTypeCond.add("t?", (BValue)cond, 1, null);
                    }
                }
                ++condCount;
            }
        }
        switch (condCount) {
            default: {
                return null;
            }
            case 1: {
                if (hasTagsCond != null) {
                    return hasTagsCond;
                }
                if (ancestorCond != null) {
                    return ancestorCond;
                }
                if (filterCond != null) {
                    return filterCond;
                }
                if (isTypeCond != null) {
                    return isTypeCond;
                }
                return null;
            }
            case 2: 
            case 3: 
            case 4: 
        }
        BAnd andCond = new BAnd();
        if (hasTagsCond != null) {
            andCond.add("a?", (BValue)hasTagsCond, 1, null);
        }
        if (isTypeCond != null) {
            andCond.add("a?", isTypeCond, 1, null);
        }
        BOr orCond = new BOr();
        if (ancestorCond != null && filterCond != null) {
            orCond.add("o?", (BValue)ancestorCond, 1, null);
            orCond.add("o?", (BValue)filterCond, 1, null);
            andCond.add("a?", (BValue)orCond, 1, null);
        } else {
            if (ancestorCond != null) {
                andCond.add("a?", (BValue)ancestorCond, 1, null);
            }
            if (filterCond != null) {
                andCond.add("a?", (BValue)filterCond, 1, null);
            }
        }
        return andCond;
    }

    private static String parseConditionString(String list, String operator) {
        String[] ancestors = TextUtil.splitAndTrim((String)list.trim(), (char)' ');
        if (ancestors.length == 1) {
            return "hs:" + ancestors[0];
        }
        if (ancestors.length > 1) {
            StringBuilder condFilter = new StringBuilder("hs:" + ancestors[0]);
            for (int i = 1; i < ancestors.length; ++i) {
                condFilter.append(' ').append(operator).append(' ').append(HS_NAME_SPACE).append(':').append(ancestors[i]);
            }
            return condFilter.toString();
        }
        return null;
    }

    static {
        tagTypeMap.put("marker", BMarker.TYPE);
        tagTypeMap.put("bool", BBoolean.TYPE);
        tagTypeMap.put("number", BDouble.TYPE);
        tagTypeMap.put("str", BString.TYPE);
        tagTypeMap.put("uri", BString.TYPE);
        tagTypeMap.put("ref", BOrd.TYPE);
        tagTypeMap.put("date", BAbsTime.TYPE);
        tagTypeMap.put("time", BAbsTime.TYPE);
        tagTypeMap.put("datetime", BAbsTime.TYPE);
        tagTypeMap.put("obj", BString.TYPE);
        tagTypeMap.put("coord", BString.TYPE);
        LOGGER = Logger.getLogger("tag.haystack");
        LEX = Lexicon.make((String)"haystack");
    }
}

