/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BEquipRelation;
import java.util.Collection;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BSiteRelation
extends BRelationInfo {
    public static final Type TYPE = Sys.loadType(BSiteRelation.class);
    private static final Id ID_SITE = Id.newId((String)"hs", (String)"site");
    private static final Id ID_SITE_REF = Id.newId((String)"hs", (String)"siteRef");

    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity source) {
        Entity equipSite;
        Optional equipSiteRef;
        if (!(source instanceof BControlPoint) || BEquipRelation.hasDirectRelation((BComponent)source, ID_SITE_REF)) {
            return Optional.empty();
        }
        BComponent equip = BEquipRelation.getEquip((BControlPoint)source);
        if (equip != null && (equipSiteRef = equip.relations().get(ID_SITE_REF, 2)).isPresent() && (equipSite = ((Relation)equipSiteRef.get()).getEndpoint()).tags().contains(ID_SITE)) {
            return Optional.of(new BasicRelation(ID_SITE_REF, equipSite, false));
        }
        return Optional.empty();
    }

    public void addRelations(Entity source, Collection<Relation> relations) {
        Optional<Relation> outbound = this.getRelation(source);
        if (outbound.isPresent()) {
            relations.add(outbound.get());
        }
        if (!(source instanceof BComponent) || !source.tags().contains(ID_SITE)) {
            return;
        }
        for (RelationKnob relationKnob : ((BComponent)source).getRelationKnobs()) {
            BComponent equip;
            if (!ID_SITE_REF.getQName().equals(relationKnob.getRelationId()) || !(equip = relationKnob.getRelationComponent()).tags().contains(BEquipRelation.ID_EQUIP)) continue;
            for (Relation relation : equip.relations().getAll(BEquipRelation.ID_EQUIP_REF, 1)) {
                BComponent endpoint = (BComponent)relation.getEndpoint();
                if (!(endpoint instanceof BControlPoint) || BEquipRelation.hasDirectRelation(endpoint, ID_SITE_REF)) continue;
                relations.add((Relation)new BasicRelation(ID_SITE_REF, (Entity)endpoint, true));
            }
        }
    }
}

