/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BNumericFacetTag;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;

@NiagaraType
public class BMinValTag
extends BNumericFacetTag {
    public static final Type TYPE = Sys.loadType(BMinValTag.class);
    private static final Logger LOGGER = Logger.getLogger("tag.haystack");

    @Override
    public Type getType() {
        return TYPE;
    }

    public Tag getTag(Entity entity) {
        if (entity instanceof BNumericPoint) {
            try {
                BNumber minVal = (BNumber)((BNumericPoint)entity).getFacets().get("min", (BObject)BDouble.NEGATIVE_INFINITY);
                return new Tag(this.getTagId(), (BIDataValue)minVal);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "BMinValTag#getTag", e);
                return new Tag(this.getTagId(), (BIDataValue)BDouble.NEGATIVE_INFINITY);
            }
        }
        return null;
    }

    public BIDataValue getDefaultValue() {
        return BDouble.NEGATIVE_INFINITY;
    }
}

