/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BNumericFacetTag;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;

@NiagaraType
public class BMaxValTag
extends BNumericFacetTag {
    public static final Type TYPE = Sys.loadType(BMaxValTag.class);
    private static final Logger LOGGER = Logger.getLogger("tag.haystack");

    @Override
    public Type getType() {
        return TYPE;
    }

    public Tag getTag(Entity entity) {
        if (entity instanceof BNumericPoint) {
            try {
                BNumber maxVal = (BNumber)((BNumericPoint)entity).getFacets().get("max", (BObject)BDouble.POSITIVE_INFINITY);
                return new Tag(this.getTagId(), (BIDataValue)maxVal);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "BMaxValTag#getTag", e);
                return new Tag(this.getTagId(), (BIDataValue)BDouble.POSITIVE_INFINITY);
            }
        }
        return null;
    }

    public BIDataValue getDefaultValue() {
        return BDouble.POSITIVE_INFINITY;
    }
}

