/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.HsImportUtil;
import com.tridium.sys.module.BModulePaletteNode;
import com.tridium.tagdictionary.util.ImportUtil;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.tagdictionary.TagRule;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="namespace", type="String", defaultValue="hs", override=true, flags=1), @NiagaraProperty(name="neqlizeExcludedTags", type="String", defaultValue="BHsTagDictionary.DEFAULT_EXCLUDE_TAGS", override=true, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, flags=1), @NiagaraProperty(name="neqlizeExcludedRelations", type="String", defaultValue="", override=true, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, flags=1), @NiagaraProperty(name="frozen", type="boolean", defaultValue="true", override=true, flags=1), @NiagaraProperty(name="version", type="String", defaultValue="\"1.0\"", flags=1), @NiagaraProperty(name="tagsImportFile", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="equipImportFile", type="BOrd", defaultValue="BOrd.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="importDictionary", flags=16), @NiagaraAction(name="makeImportFiles", parameterType="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:DirectoryOrdFE\"")})})
public class BHsTagDictionary
extends BSmartTagDictionary {
    public static final Property namespace = BHsTagDictionary.newProperty((int)1, (String)"hs", null);
    public static final Property neqlizeExcludedTags = BHsTagDictionary.newProperty((int)1, (String)"hs:area, hs:cur, hs:curErr,\nhs:curStatus, hs:curVal, hs:dis,\nhs:enum, hs:geo*, hs:his,\nhs:hisErr, hs:hisInterpolate,\nhs:hisStatus, hs:hisTotalized,\nhs:id, hs:kind, hs:maxVal,\nhs:minVal, hs:unit, hs:writable,\nhs:writeErr, hs:writeLevel,\nhs:writeStatus, hs:writeVal,\nhs:yearBuilt", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property neqlizeExcludedRelations = BHsTagDictionary.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property frozen = BHsTagDictionary.newProperty((int)1, (boolean)true, null);
    public static final Property version = BHsTagDictionary.newProperty((int)1, (String)"1.0", null);
    public static final Property tagsImportFile = BHsTagDictionary.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property equipImportFile = BHsTagDictionary.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Action importDictionary = BHsTagDictionary.newAction((int)16, null);
    public static final Action makeImportFiles = BHsTagDictionary.newAction((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:DirectoryOrdFE"));
    public static final Type TYPE = Sys.loadType(BHsTagDictionary.class);
    public static final String HS_NAME_SPACE = "hs";
    private static final Logger LOGGER = Logger.getLogger("tag.haystack");
    private static final Lexicon LEXICON = Lexicon.make((String)"haystack");
    private static final int TAGS_HEADER_SIZE = 3;
    private static final int EQUIP_HEADER_SIZE = 2;
    public static final String TAGS_IMPORT_FILE_NAME = "tagsMerge.csv";
    public static final String EQUIP_IMPORT_FILE_NAME = "equipMerge.csv";
    public static final String TAGS_FILE_NAME = "tags.csv";
    public static final String EQUIP_FILE_NAME = "equip.csv";
    public static final FilePath rcFilePath = new FilePath("/com/tridium/haystack/data");
    public static final String HAYSTACK_VERSION = "3.0.2";
    public static final String TAGS_CSV_FILE_VERSION = "3.0.2 N.2";
    public static final String TAGS_WITH_SMART_REFS_CSV_FILE_VERSION = "3.0.2 N.2 w/ SmartRefs " + LEXICON.getText("tagImport.versionSuffix");
    public static final BString HS_KIND_BOOL = BString.make((String)"Bool");
    public static final BString HS_KIND_NUMBER = BString.make((String)"Number");
    public static final BString HS_KIND_STR = BString.make((String)"Str");
    public static final String DEFAULT_EXCLUDE_TAGS = "hs:area, hs:cur, hs:curErr,\nhs:curStatus, hs:curVal, hs:dis,\nhs:enum, hs:geo*, hs:his,\nhs:hisErr, hs:hisInterpolate,\nhs:hisStatus, hs:hisTotalized,\nhs:id, hs:kind, hs:maxVal,\nhs:minVal, hs:unit, hs:writable,\nhs:writeErr, hs:writeLevel,\nhs:writeStatus, hs:writeVal,\nhs:yearBuilt";

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public BOrd getTagsImportFile() {
        return (BOrd)this.get(tagsImportFile);
    }

    public void setTagsImportFile(BOrd v) {
        this.set(tagsImportFile, (BValue)v, null);
    }

    public BOrd getEquipImportFile() {
        return (BOrd)this.get(equipImportFile);
    }

    public void setEquipImportFile(BOrd v) {
        this.set(equipImportFile, (BValue)v, null);
    }

    public void importDictionary() {
        this.invoke(importDictionary, null, null);
    }

    public void makeImportFiles(BOrd parameter) {
        this.invoke(makeImportFiles, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.getTagDefinitions().iterator().hasNext()) {
            this.doImportDictionary(null);
        }
    }

    public String toString(Context context) {
        String name = this.getName();
        if (name != null) {
            return LEXICON.getText("tag.dictionary.shortName", new Object[]{name});
        }
        return super.toString(context);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(importDictionary)) {
            return action.getParameterDefault();
        }
        return super.getActionParameterDefault(action);
    }

    public BTagDictionary getStandardDictionary() {
        BModule module = TYPE.getModule();
        BIFile dataDir = module.findFile(new FilePath("/com/tridium/haystack/data"));
        BIFile tagCsv = module.getChild(dataDir, TAGS_FILE_NAME);
        BIFile equipCsv = module.getChild(dataDir, EQUIP_FILE_NAME);
        HashMap<Object, Object> mergeTags = new HashMap();
        HashMap<String, String[]> mergeEquip = new HashMap();
        try {
            BObject bObject;
            BOrd tagsImportFileOrd = this.getTagsImportFile();
            BOrd equipImportFileOrd = this.getEquipImportFile();
            if (!tagsImportFileOrd.equals((Object)BOrd.DEFAULT) && (bObject = tagsImportFileOrd.resolve((BObject)this).get()) instanceof BCsvFile) {
                mergeTags = HsImportUtil.importMergeCsv((BCsvFile)bObject, true);
            }
            if (!equipImportFileOrd.equals((Object)BOrd.DEFAULT) && (bObject = equipImportFileOrd.resolve((BObject)this).get()) instanceof BCsvFile) {
                if (!mergeTags.isEmpty()) {
                    mergeEquip = HsImportUtil.importMergeCsv((BCsvFile)bObject, false);
                } else {
                    LOGGER.warning(LEXICON.getText("importEquipFile.missingImportTags", new Object[]{tagsImportFileOrd}));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error retrieving the tags and equip import files", e);
        }
        BHsTagDictionary newDictionary = new BHsTagDictionary();
        newDictionary.setNamespace(HS_NAME_SPACE);
        newDictionary.setFrozen(true);
        if (tagCsv instanceof BCsvFile) {
            HsImportUtil.importTags(newDictionary, (BCsvFile)tagCsv, mergeTags);
            if (newDictionary.getStatus().isFault()) {
                return newDictionary;
            }
        } else {
            LOGGER.warning("Could not import tags from tags.csv");
        }
        if (equipCsv instanceof BCsvFile) {
            HsImportUtil.importEquip(newDictionary, (BCsvFile)equipCsv, mergeEquip);
        } else {
            LOGGER.warning("Could not import tag groups from equip.csv");
        }
        return newDictionary;
    }

    public void doMakeImportFiles(BOrd destination) throws Exception {
        boolean equipMergeExist;
        BDirectory destDir = (BDirectory)destination.resolve().get();
        FilePath tagsImportFilePath = destDir.getFilePath().merge(TAGS_IMPORT_FILE_NAME);
        FilePath equipImportFilePath = destDir.getFilePath().merge(EQUIP_IMPORT_FILE_NAME);
        BModule module = TYPE.getModule();
        BIFile dataDir = module.findFile(rcFilePath);
        BIFile tagCsv = module.getChild(dataDir, TAGS_FILE_NAME);
        BIFile equipCsv = module.getChild(dataDir, EQUIP_FILE_NAME);
        BFileSystem fileSystem = BFileSystem.INSTANCE;
        boolean tagsMergeExist = fileSystem.findFile(tagsImportFilePath) != null;
        boolean bl = equipMergeExist = fileSystem.findFile(equipImportFilePath) != null;
        if (!tagsMergeExist) {
            BIFile tagsMergeFile = fileSystem.makeFile(tagsImportFilePath);
            HsImportUtil.makeImportFile(tagCsv, tagsMergeFile, 3);
        }
        if (!equipMergeExist) {
            BIFile equipMergeFile = fileSystem.makeFile(equipImportFilePath);
            HsImportUtil.makeImportFile(equipCsv, equipMergeFile, 2);
        }
        if (tagsMergeExist && equipMergeExist) {
            throw new RuntimeException(LEXICON.getText("makeImportFile.filesExist", new Object[]{tagsImportFilePath + ", " + equipImportFilePath}));
        }
        if (tagsMergeExist) {
            throw new RuntimeException(LEXICON.getText("makeImportFile.filesExist", new Object[]{tagsImportFilePath}));
        }
        if (equipMergeExist) {
            throw new RuntimeException(LEXICON.getText("makeImportFile.filesExist", new Object[]{equipImportFilePath}));
        }
    }

    public void doImportDictionary(Context context) {
        if (this.getSpace() instanceof BModulePaletteNode) {
            LOGGER.warning("Haystack.importDictionary action does not function in a module palette.");
            return;
        }
        new Thread(() -> this.implImportDictionary(context)).start();
    }

    private void implImportDictionary(Context context) {
        BHsTagDictionary newDictionary = (BHsTagDictionary)this.getStandardDictionary();
        if (newDictionary.getStatus().isFault()) {
            this.setStatus(newDictionary.getStatus());
            this.setFaultCause(newDictionary.getFaultCause());
            LOGGER.severe(LEXICON.getText("importDictionary.didNotImport"));
            return;
        }
        if (BHsTagDictionary.equivalent(newDictionary, this)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this.getName() + " tag dictionary is up to date.");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.getName() + " tag dictionary is out of date or has been modified.");
        }
        try {
            this.setFrozen(false);
            ImportUtil.updateTags((BTagInfoList)newDictionary.getTagDefinitions(), (BTagInfoList)this.getTagDefinitions(), (Context)context);
            BHsTagDictionary.updateTagGroups(newDictionary.getTagGroupDefinitions(), this.getTagGroupDefinitions(), context);
            ImportUtil.updateRelations((BRelationInfoList)newDictionary.getRelationDefinitions(), (BRelationInfoList)this.getRelationDefinitions(), (Context)context);
            BHsTagDictionary.updateTagRules(newDictionary.getTagRules(), this.getTagRules(), context);
            this.setVersion(newDictionary.getVersion());
        }
        finally {
            this.setFrozen(true);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.getName() + " tag dictionary has been reloaded.");
        }
    }

    public static boolean equivalent(BHsTagDictionary source, BHsTagDictionary dest) {
        if (!source.getNamespace().equals(dest.getNamespace())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Source namespace (" + source.getNamespace() + ") does not match the destination namespace (" + dest.getNamespace() + ')');
            }
            return false;
        }
        if (!source.getVersion().equals(dest.getVersion())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Source dictionary version (" + source.getVersion() + ") does not match the destination dictionary version (" + dest.getVersion() + ')');
            }
            return false;
        }
        if (source.getFrozen() != dest.getFrozen()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Source isFrozen (" + source.getFrozen() + ") does not match the destination isFrozen (" + dest.getFrozen() + ')');
            }
            return false;
        }
        if (!source.getTagDefinitions().equivalent((Object)dest.getTagDefinitions())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Source tags do not match the destination tags");
                BTagInfo[] sourceTags = (BTagInfo[])source.getTagDefinitions().getChildren(BTagInfo.class);
                BTagInfo[] destTags = (BTagInfo[])dest.getTagDefinitions().getChildren(BTagInfo.class);
                for (int i = 0; i < sourceTags.length && i < destTags.length; ++i) {
                    if (sourceTags[i].equivalent((Object)destTags[i])) continue;
                    LOGGER.fine("Source tag " + sourceTags[i].getTagId() + " is not equivalent to " + destTags[i].getTagId());
                }
            }
            return false;
        }
        if (!BHsTagDictionary.equivalent(source.getTagGroupDefinitions(), dest.getTagGroupDefinitions())) {
            LOGGER.fine("Source tag groups do not match the destination tag groups");
            return false;
        }
        if (!source.getRelationDefinitions().equivalent((Object)dest.getRelationDefinitions())) {
            LOGGER.fine("Source relations do not match the destination relations");
            return false;
        }
        if (!BHsTagDictionary.equivalent(source.getTagRules(), dest.getTagRules())) {
            LOGGER.fine("Source tag rules do not match destination tag rules");
            return false;
        }
        return true;
    }

    private static boolean equivalent(BTagGroupInfoList sourceList, BTagGroupInfoList destList) {
        BTagGroupInfoList destListNonHidden = new BTagGroupInfoList();
        for (Property property : destList.getProperties()) {
            if (Flags.isHidden((BComplex)destList, (Slot)property)) continue;
            destListNonHidden.add(property.getName(), destList.get(property).newCopy(true));
        }
        return destListNonHidden.equivalent((Object)sourceList);
    }

    private static void updateTagGroups(BTagGroupInfoList sourceList, BTagGroupInfoList destList, Context cx) {
        for (TagGroupInfo tgi : destList) {
            BTagGroupInfo destTagGroup = (BTagGroupInfo)tgi;
            BTagGroupInfo sourceTagGroup = (BTagGroupInfo)sourceList.get(destTagGroup.getName());
            if (sourceTagGroup != null) {
                destTagGroup.setValidity((BTagRuleCondition)sourceTagGroup.getValidity().newCopy(true));
                ImportUtil.updateTags((BTagInfoList)sourceTagGroup.getTagList(), (BTagInfoList)destTagGroup.getTagList(), (Context)cx);
                continue;
            }
            BHsTagDictionary.hideComponent((BComponent)destTagGroup);
        }
        for (TagGroupInfo tgi : sourceList) {
            BTagGroupInfo sourceTagGroup = (BTagGroupInfo)tgi;
            String name = sourceTagGroup.getName();
            if (destList.get(name) != null) continue;
            destList.add(name, sourceTagGroup.newCopy(true), cx);
        }
        HsImportUtil.orderByName((BComponent)destList);
    }

    private static void hideComponent(BComponent component) {
        BComponent parent = component.getParentComponent();
        Property property = component.getPropertyInParent();
        parent.setFlags((Slot)property, parent.getFlags((Slot)property) | 4);
    }

    private static boolean equivalent(BTagRuleList sourceList, BTagRuleList destList) {
        for (Property sourceProperty : sourceList.getProperties()) {
            BValue destProperty = destList.get(sourceProperty.getName());
            if (destProperty != null && destProperty.equivalent((Object)sourceList.get(sourceProperty))) continue;
            return false;
        }
        return true;
    }

    private static void updateTagRules(BTagRuleList sourceList, BTagRuleList destList, Context cx) {
        for (TagRule tagRule : sourceList) {
            String name = ((BComplex)tagRule).getName();
            if (destList.get(name) == null) {
                destList.add(name, ((BValue)tagRule).newCopy(true), cx);
                continue;
            }
            destList.set(name, ((BValue)tagRule).newCopy(true), cx);
        }
        HsImportUtil.orderByName((BComponent)destList);
    }
}

