/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.hsqldb;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.hsqldb.BHsqlPassword;
import com.tridium.rdb.hsqldb.HsqlConnection;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.persist.HsqlProperties;

public class BHsqlDatabase
extends BRdbms {
    public static final Property hostAddress = BHsqlDatabase.newProperty((int)5, (BValue)BOrd.NULL, null);
    public static final Property baseDirectory = BHsqlDatabase.newProperty((int)0, (BValue)BOrd.make((String)"file:^^hsqldb"), (BFacets)BFacets.make((String)"targetType", (String)"baja:IDirectory"));
    public static final Property databaseName = BHsqlDatabase.newProperty((int)0, (String)"", null);
    public static final Property password = BHsqlDatabase.newProperty((int)0, (BValue)BPassword.make((String)"Niagara123"), null);
    public static final Property defragOnSave = BHsqlDatabase.newProperty((int)0, (boolean)false, null);
    public static final Property defragAndSavePeriodicSchedule = BHsqlDatabase.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((boolean)true, (BTime)BTime.make((int)2, (int)0, (int)0), (BTime)BTime.make((int)23, (int)29, (int)29), (BRelTime)BRelTime.makeDays((int)30), (BDaysOfWeekBits)BDaysOfWeekBits.make((int)1))), null);
    public static final Property checkpointDefragSize = BHsqlDatabase.newProperty((int)4, (int)2, null);
    public static final Action defragAndSave = BHsqlDatabase.newAction((int)0, null);
    public static final Action setHsqlPassword = BHsqlDatabase.newAction((int)0, (BValue)new BHsqlPassword(), null);
    public static final Type TYPE = Sys.loadType(BHsqlDatabase.class);
    private Properties oldPropertiesFile;
    private boolean checkedForHsqlUpgrade = false;
    private final RdbmsDialect dialect = new RdbmsDialect(){

        public String getValidationQuery() {
            return "CALL USER()";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("**********ISSUE  CHECKPOINT DEFRAG ********** ->" + BHsqlDatabase.this.getDefragOnSave());
            }
            if (BHsqlDatabase.this.getDefragOnSave()) {
                this.executeSql(conn, "SET FILES DEFRAG " + BHsqlDatabase.this.getCheckpointDefragSize());
                this.executeSql(conn, "CHECKPOINT DEFRAG");
            } else {
                this.executeSql(conn, "SET FILES DEFRAG 0");
                this.executeSql(conn, "CHECKPOINT");
            }
        }

        private void executeSql(Connection conn, String sql) throws SQLException {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(sql);
            }
            try (Statement statement = conn.createStatement();){
                statement.execute(sql);
            }
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return false;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 2;
        }

        public String getIdentityCreation() {
            return "GENERATED BY DEFAULT AS IDENTITY";
        }

        public String getIdentityLookup() {
            return "CALL IDENTITY()";
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return false;
        }

        public String getStringLengthFunctionName() {
            return "CHAR_LENGTH";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return false;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE PRECISION";
        }

        public String getCharType() {
            return BHsqlDatabase.this.getUseUnicodeEncodingScheme() ? "CHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BHsqlDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "BINARY(16)";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "BOOLEAN";
        }

        public String getTimestampType() {
            return "TIMESTAMP";
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.localTimestamp) || BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public boolean useUtcTimestamps() {
            return BHsqlDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public String getBlobType() {
            return "LONGVARBINARY";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return "LONGVARCHAR";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BHsqlDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return -4;
        }

        public int getJdbcTypeBoolean() {
            return 16;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return -1;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    public static final Logger logger = Logger.getLogger("rdb");
    private static final LexiconModule lex = LexiconModule.make(BHsqlDatabase.class);
    private ExecutorService defragAndSaveExecutor = Executors.newSingleThreadExecutor();

    public BOrd getBaseDirectory() {
        return (BOrd)this.get(baseDirectory);
    }

    public void setBaseDirectory(BOrd v) {
        this.set(baseDirectory, (BValue)v, null);
    }

    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    public void setDatabaseName(String v) {
        this.setString(databaseName, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public boolean getDefragOnSave() {
        return this.getBoolean(defragOnSave);
    }

    public void setDefragOnSave(boolean v) {
        this.setBoolean(defragOnSave, v, null);
    }

    public BTimeTrigger getDefragAndSavePeriodicSchedule() {
        return (BTimeTrigger)this.get(defragAndSavePeriodicSchedule);
    }

    public void setDefragAndSavePeriodicSchedule(BTimeTrigger v) {
        this.set(defragAndSavePeriodicSchedule, (BValue)v, null);
    }

    public int getCheckpointDefragSize() {
        return this.getInt(checkpointDefragSize);
    }

    public void setCheckpointDefragSize(int v) {
        this.setInt(checkpointDefragSize, v, null);
    }

    public void defragAndSave() {
        this.invoke(defragAndSave, null, null);
    }

    public void setHsqlPassword(BHsqlPassword changeHsqlPassword) {
        this.invoke(setHsqlPassword, (BValue)changeHsqlPassword, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void rdbmsStarted() throws Exception {
        this.add("defragAndSavePeriodicSchedulePeriodicScheduleLink", (BValue)new BLink(this.getDefragAndSavePeriodicSchedule().getOrdInSession(), "fireTrigger", "defragAndSave", true), 6);
        this.updateDefragAndSaveFlags();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (prop.equals(defragOnSave) || prop.equals(defragAndSavePeriodicSchedule)) {
            this.updateDefragAndSaveFlags();
        }
    }

    private void updateDefragAndSaveFlags() {
        int flag1 = this.getFlags((Slot)defragAndSave);
        int flag2 = this.getFlags((Slot)defragAndSavePeriodicSchedule);
        if (this.getDefragOnSave()) {
            flag1 |= 1;
            flag1 |= 4;
            flag2 |= 1;
            flag2 |= 4;
        } else {
            flag1 &= 0xFFFFFFFE;
            flag1 &= 0xFFFFFFFB;
            flag2 &= 0xFFFFFFFE;
            flag2 &= 0xFFFFFFFB;
        }
        this.setFlags((Slot)defragAndSave, flag1);
        this.setFlags((Slot)defragAndSavePeriodicSchedule, flag2);
    }

    public void stopped() throws Exception {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SHUTDOWN");
            }
            statement.execute("SHUTDOWN");
            this.defragAndSaveExecutor.shutdown();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doSetHsqlPassword(BHsqlPassword changeHsqlPassword, Context cx) throws Exception {
        String message = null;
        BPassword hsqlPassword = this.getPassword();
        BPassword oldHsqlPassword = changeHsqlPassword.getOldHsqlPassword();
        BPassword newHsqlPassword = changeHsqlPassword.getNewHsqlPassword();
        String newHsqlPasswordValue = AccessController.doPrivileged(() -> ((BPassword)changeHsqlPassword.getNewHsqlPassword()).getValue());
        BPassword confirmHsqlPassword = changeHsqlPassword.getConfirmHsqlPassword();
        String regex = "^[a-zA-Z0-9@#!$&+><\\[\\])(]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(newHsqlPasswordValue);
        StringBuilder passwordStrengthRequirements = new StringBuilder();
        for (Localizable localizable : BPasswordStrength.STRONG.getLocalizableRequirements()) {
            passwordStrengthRequirements.append(localizable.toString(cx));
        }
        if (!hsqlPassword.validate(oldHsqlPassword)) {
            message = lex.getText("rdbHsqlDb.oldPassword.message", cx);
        } else if (hsqlPassword.validate(newHsqlPassword)) {
            message = lex.getText("rdbHsqlDb.samePassword.message", cx);
        } else if (newHsqlPassword.validate(BPassword.make((String)""))) {
            message = lex.getText("rdbHsqlDb.blankPassword.message", cx);
        } else if (!newHsqlPassword.validate(confirmHsqlPassword)) {
            message = lex.getText("rdbHsqlDb.noMatchPassword.message", cx);
        } else if (!matcher.matches()) {
            message = lex.getText("rdbHsqlDb.regularExpressionMismatchPasswordStrength.message", cx, new Object[]{passwordStrengthRequirements});
        } else {
            try {
                BPasswordStrength.STRONG.isPasswordValid(newHsqlPasswordValue);
            }
            catch (Exception e) {
                message = lex.getText("rdbHsqlDb.regularExpressionMismatchPasswordStrength.message", cx, new Object[]{passwordStrengthRequirements});
            }
        }
        if (message != null) {
            throw new ActionInvokeException(message, (Throwable)new IllegalArgumentException());
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            String sql = "SET PASSWORD '" + newHsqlPasswordValue + "'";
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SET PASSWORD *****");
            }
            statement.execute(sql);
            this.setPassword(BPassword.make((String)newHsqlPasswordValue));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot change hsql password", e);
            return;
        }
        try {
            this.doPing();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot ping station after changing hsql password", e);
        }
    }

    public void doDefragAndSave() throws Exception {
        if (this.getDefragOnSave()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Cannot issue CHECKPOINT DEFRAG on " + this.getName() + " (" + this.getType() + ") as redundant where on each save sation alreading issuing CHECKPOINT DEFRAG");
            }
            return;
        }
        this.defragAndSaveExecutor.submit(() -> {
            try (Connection connection = this.getConnection();){
                String sql;
                try (Statement statement = connection.createStatement();){
                    sql = "SET FILES DEFRAG " + this.getCheckpointDefragSize();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(sql);
                    }
                    statement.execute(sql);
                }
                statement = connection.createStatement();
                var4_8 = null;
                try {
                    sql = "CHECKPOINT DEFRAG";
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(sql);
                    }
                    statement.execute(sql);
                }
                catch (Throwable throwable) {
                    var4_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (var4_8 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var4_8.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot issue checkpoint on " + this.getName() + " (" + this.getType() + ")", e);
                return;
            }
            try {
                BStationSaveJob job = new BStationSaveJob();
                Station.saveSync((BJob)job);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot save sation after issuing \"CHECKPOINT DEFRAG\"", e);
            }
        });
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbHsqlDb");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        if (this.getDatabaseName().length() == 0) {
            throw new BajaRuntimeException("Database Name cannot be empty");
        }
        try {
            boolean firstCheck = this.checkForHsqlUpgrade();
            FilePath path = (FilePath)this.getBaseDirectory().parse()[0];
            BDirectory dir = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.makeDir(path));
            String home = ((BLocalFileStore)dir.getStore()).getLocalFile().getAbsolutePath();
            String url = "jdbc:hsqldb:file:" + home + File.separator + this.getDatabaseName();
            Properties info = new Properties();
            if (firstCheck) {
                BHsqlDatabase.addProps(info);
            }
            if (Flags.isUserDefined1((BComplex)this, (Slot)BHsqlDatabase.password)) {
                this.setPassword(BPassword.make((String)""));
                BHsqlPassword convertedAxDefaultPassword = new BHsqlPassword();
                convertedAxDefaultPassword.setOldHsqlPassword(BPassword.make((String)""));
                convertedAxDefaultPassword.setNewHsqlPassword(BPassword.make((String)"Niagara123"));
                convertedAxDefaultPassword.setConfirmHsqlPassword(BPassword.make((String)"Niagara123"));
                this.setFlags((Slot)BHsqlDatabase.password, this.getFlags((Slot)BHsqlDatabase.password) & 0xEFFFFFFF);
                this.setHsqlPassword(convertedAxDefaultPassword);
            }
            info.put("user", userName);
            info.put("password", AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
            HsqlProperties hprops = AccessController.doPrivileged(() -> DatabaseURL.parseURL(url, true, true));
            hprops.addProperties(info);
            Connection conn = AccessController.doPrivileged(() -> new JDBCConnection(hprops));
            return new HsqlConnection(conn);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static void addProps(Properties info) {
        info.put("check_props", "true");
        info.put("hsqldb.log_data", "false");
        info.put("hsqldb.default_table_type", "cached");
        info.put("hsqldb.applog", "0");
        info.put("hsqldb.lock_file", "false");
    }

    private synchronized boolean checkForHsqlUpgrade() throws Exception {
        if (this.checkedForHsqlUpgrade) {
            return false;
        }
        this.checkedForHsqlUpgrade = true;
        BIFile propsFile = null;
        try {
            propsFile = (BIFile)BOrd.make((String)(this.getBaseDirectory() + "/" + this.getDatabaseName() + ".properties")).get();
        }
        catch (Exception e) {
            return true;
        }
        Properties props = new Properties();
        try (InputStream inputStream = propsFile.getInputStream();){
            props.load(inputStream);
        }
        String versionProp = props.getProperty("version");
        Version version = new Version(versionProp);
        Version version20 = new Version("2.0");
        Version version25 = new Version("2.5");
        if (version.compareTo(version25) < 0) {
            logger.info("Upgrading HSQL Database from " + version + " to 2.X");
            String stringModified = props.getProperty("modified");
            if (stringModified != null && stringModified.equals("yes")) {
                String warningText = "***This HSQL " + version + " Database was being modified while the HSQL backup occured; if you plan on safely upgrading a backup of a Hsql database to HSQL 2.X, you may need to shutdown the station using Hsql old version before backing it up.";
                logger.warning(warningText);
            }
            BHsqlDatabase.addProps(props);
            try (OutputStream outputStream = propsFile.getOutputStream();){
                props.store(outputStream, "none");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot write to properties file", e);
            }
            this.oldPropertiesFile = props;
            BIFile scriptFile = (BIFile)BOrd.make((String)(this.getBaseDirectory() + "/" + this.getDatabaseName() + ".script")).get();
            String bigString = BajaFileUtil.readString((BIFile)scriptFile);
            if (version.compareTo(version20) < 0) {
                bigString = TextUtil.replace((String)bigString, (String)" BINARY", (String)" BINARY(16)");
            }
            bigString = TextUtil.replace((String)bigString, (String)" DEADLOCK", (String)" CONFLICT");
            scriptFile.write(bigString.getBytes());
            return true;
        }
        return true;
    }

    public RdbmsContext getRdbmsContext() {
        return this.dialect;
    }
}

