/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import com.tridium.sys.license.NLicenseManager;
import com.tridiumx.jsonToolkit.util.JsonStringUtil;
import com.tridiumx.jsonToolkit.util.Log;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.status.BStatus;
import javax.baja.sys.Sys;

public interface LicenseLimit {
    public static final String LICENSE_PROTOTYPE_NAME = "DR-JSON or DR-S-JSON";
    public static final String LICENSE_FEATURE_NAME = "jsonToolkit";
    public static final String IMPORT_ATTRIBUTE = "import";
    public static final String EXPORT_ATTRIBUTE = "export";
    public static final String SMA_EXEMPT_ATTRIBUTE = "sma.exempt";
    public static final String NO_LIC_MSG = JsonStringUtil.lexicon.getText("unlicensedWarning", new Object[]{"DR-JSON or DR-S-JSON"});
    public static final String NO_SMA_MSG = JsonStringUtil.lexicon.getText("smaExpired");

    public void setStatus(BStatus var1);

    public void setFaultCause(String var1);

    default public void initLicenseProperty() {
        try {
            LicenseLimit.checkSmaAndLicense();
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (FeatureNotLicensedException e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(NO_LIC_MSG);
            Log.log.log(Level.WARNING, NO_LIC_MSG, Log.log.isLoggable(Level.FINE) ? e : null);
        }
    }

    public static void checkSmaAndLicense() {
        LicenseLimit.checkLicense();
        LicenseLimit.checkSma();
    }

    public static Feature checkLicense() {
        Log.log.finest(() -> "Checking License");
        return Sys.getLicenseManager().getFeature("tridium", LICENSE_FEATURE_NAME);
    }

    public static void checkExportLicensed() {
        LicenseLimit.checkSmaAndLicenseAttribute(EXPORT_ATTRIBUTE);
    }

    public static void checkImportLicensed() {
        LicenseLimit.checkSmaAndLicenseAttribute(IMPORT_ATTRIBUTE);
    }

    public static void checkSmaAndLicenseAttribute(String attributeName) {
        if (!LicenseLimit.checkLicenseAttribute(attributeName)) {
            throw new FeatureNotLicensedException(String.format("JSON Toolkit license attribute %s missing", attributeName));
        }
        LicenseLimit.checkSma();
    }

    public static boolean isSmaExempt() {
        return LicenseLimit.checkLicenseAttribute(SMA_EXEMPT_ATTRIBUTE);
    }

    public static boolean checkLicenseAttribute(String attribute) {
        try {
            return LicenseLimit.checkLicense().getb(attribute, false);
        }
        catch (FeatureNotLicensedException fnle) {
            Log.log.info("Feature disabled by current license: " + attribute);
        }
        catch (LicenseDatabaseException unexpected) {
            Log.log.log(Level.WARNING, "Unexpected error checking license attribute: " + attribute, Log.log.isLoggable(Level.FINE) ? unexpected : null);
        }
        return false;
    }

    public static void checkSma() {
        Optional<Long> sma;
        if (!LicenseLimit.isSmaExempt() && (sma = LicenseLimit.getSmaExpiration()).isPresent() && sma.get() < System.currentTimeMillis()) {
            throw new FeatureNotLicensedException(NO_SMA_MSG);
        }
    }

    public static Optional<Long> getSmaExpiration() {
        NLicenseManager licenseManager = (NLicenseManager)Sys.getLicenseManager();
        Optional sma = licenseManager.getLicenseMaintenanceExpiration(Sys.getBajaVendor());
        return sma;
    }
}

