/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import com.tridium.sys.Nre;
import com.tridiumx.jsonToolkit.util.Log;
import com.tridiumx.jsonToolkit.util.ThreadPool;
import java.security.AccessController;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="rate", type="int", defaultValue="50", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(4000)")}), @NiagaraProperty(name="maxSize", type="int", defaultValue="1000", flags=4, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)")})})
public abstract class BEngineCycleQueue<T>
extends BComponent {
    public static final Property rate = BEngineCycleQueue.newProperty((int)4, (int)50, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)4000))));
    public static final Property maxSize = BEngineCycleQueue.newProperty((int)4, (int)1000, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BEngineCycleQueue.class);
    private final Runnable emptier = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.fine("init emptier");
            try {
                int lastCycle = BEngineCycleQueue.getCurrentCycles();
                log.fine("lastCycle:" + lastCycle);
                while (!BEngineCycleQueue.this.stopping) {
                    int currentCycle = BEngineCycleQueue.getCurrentCycles();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("CUR:" + currentCycle + " LAST:" + lastCycle + " >? " + (currentCycle > lastCycle));
                    }
                    if (currentCycle > lastCycle) {
                        Object next = BEngineCycleQueue.this.getQueue().take();
                        lastCycle = BEngineCycleQueue.getCurrentCycles();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(currentCycle + " De-queueing: " + next);
                        }
                        BEngineCycleQueue.this.processedCount.incrementAndGet();
                        BEngineCycleQueue.this.setOutValue(next);
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.finest("waitingForNextCycle:" + lastCycle + '/' + currentCycle);
                    }
                    try {
                        Thread.sleep(BEngineCycleQueue.this.getRate());
                    }
                    catch (InterruptedException e) {
                        log.log(Level.FINE, "Sleep interrupted", e);
                        throw e;
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("queueSize:" + BEngineCycleQueue.this.getQueue().size());
                }
            }
            catch (InterruptedException ie) {
                if (!BEngineCycleQueue.this.stopping) {
                    log.log(Level.WARNING, "IException whilst emptying ", ie);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception whilst emptying ", e);
            }
            finally {
                log.fine("Finished emptying queue");
            }
        }
    };
    private boolean stopping;
    private Thread thread;
    private LinkedBlockingQueue<T> queue;
    private final AtomicLong processedCount = new AtomicLong();
    private static final Object QUEUE_SYNC = new Object();
    private static final Logger log = Log.child("messageQueue");

    public int getRate() {
        return this.getInt(rate);
    }

    public void setRate(int v) {
        this.setInt(rate, v, null);
    }

    public int getMaxSize() {
        return this.getInt(maxSize);
    }

    public void setMaxSize(int v) {
        this.setInt(maxSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(maxSize)) {
            Object object = QUEUE_SYNC;
            synchronized (object) {
                LinkedBlockingQueue<T> temp = this.queue;
                this.queue = new LinkedBlockingQueue(this.getMaxSize());
                if (temp != null) {
                    temp.drainTo(this.queue, this.getMaxSize());
                    if (!temp.isEmpty()) {
                        log.severe(String.format("Queue %s dropping %s messages as max size reduced", this.getSlotPath().toDisplayString(), temp.size()));
                        temp.clear();
                    }
                }
            }
        }
    }

    public void stopped() {
        this.stopping = true;
        try {
            this.thread.interrupt();
        }
        catch (Exception e) {
            log.log(Level.FINE, "Stopping Queue", e);
        }
    }

    public BIcon getIcon() {
        return BIcon.std((String)"connection.png");
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return ThreadPool.post(this, action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedBlockingQueue<T> getQueue() {
        Object object = QUEUE_SYNC;
        synchronized (object) {
            if (this.queue == null) {
                this.queue = new LinkedBlockingQueue(this.getMaxSize());
            }
            return this.queue;
        }
    }

    public int size() {
        return this.getQueue().size();
    }

    protected void performEnqueue(T message) {
        if (!this.isRunning()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("enqueueing: " + message);
        }
        if (!this.getQueue().offer(message)) {
            throw new QueueFullException();
        }
        if (this.thread == null || this.thread.getState() == Thread.State.TERMINATED) {
            this.thread = this.getThread();
        }
        if (this.thread.getState() == Thread.State.NEW) {
            log.fine("Starting emptier thread");
            this.thread.start();
        }
    }

    protected abstract void setOutValue(T var1);

    private Thread getThread() {
        return new Thread(this.emptier, log.getName());
    }

    private static int getCurrentCycles() {
        return AccessController.doPrivileged(Nre::getEngineManager).getCycles();
    }

    public long getProcessedCount() {
        return this.processedCount.get();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(false);
        try {
            out.th((Object)"Queue State");
            out.tr((Object)"Current Size", (Object)this.size());
            out.tr((Object)"Processed Count", (Object)this.getProcessedCount());
        }
        finally {
            out.endTable();
        }
        super.spy(out);
    }
}

