/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.subscription;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionEventFilter;
import com.tridiumx.jsonToolkit.outbound.schema.support.FilterResult;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class Subscription
implements Predicate<BComponentEvent> {
    private final Set<Property> subscriptionTargets = new HashSet<Property>();
    private final Property[] propertyPathInComponent;
    private final int depth;
    protected final List<SubscriptionEventFilter> filters = new ArrayList<SubscriptionEventFilter>();

    Subscription(Property[] propertyPathInComponent, int depth) {
        this.propertyPathInComponent = propertyPathInComponent;
        this.depth = depth;
    }

    public void addSubscriptionTarget(BComponent subscriptionTarget) {
        this.subscriptionTargets.add(subscriptionTarget.getPropertyInParent());
    }

    public Set<Property> getSubscriptionTargets() {
        return this.subscriptionTargets;
    }

    public int getDepth() {
        return this.depth;
    }

    public Property[] getPropertyPathInComponent() {
        return this.propertyPathInComponent;
    }

    public List<SubscriptionEventFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public Subscription withFilter(SubscriptionEventFilter newFilter) {
        if (newFilter != null) {
            this.filters.add(newFilter);
        }
        return this;
    }

    @Override
    public boolean test(BComponentEvent event) {
        boolean generateJson = true;
        for (SubscriptionEventFilter filter : this.filters) {
            FilterResult result = filter.test(event);
            if (result == FilterResult.CONTINUE) continue;
            generateJson = result == FilterResult.PROPAGATE;
            break;
        }
        return generateJson;
    }

    public BValue getLiveBindingValue(BJsonSchemaBoundMember member, BComponentEvent event) {
        BComponent foundLiveValue = null;
        boolean log = JsonSchemaUtil.logger.isLoggable(Level.FINEST);
        BComponent eventSource = event.getSourceComponent();
        if (this.propertyPathInComponent != null && this.propertyPathInComponent.length > 0) {
            BComponent source = eventSource;
            for (Property property : this.propertyPathInComponent) {
                foundLiveValue = source = source.asComplex().get(property.getName());
                if (!log) continue;
                JsonSchemaUtil.logger.finest(String.format("Json Schema [%s] SUBS: [%s] found value in path", member.schemaName(), member.getSchemaPath()));
            }
        } else if (this.subscriptionTargets.contains(eventSource.getPropertyInParent())) {
            foundLiveValue = eventSource;
            if (log) {
                JsonSchemaUtil.logger.finest(String.format("Json Schema [%s] SUBS: [%s] value is the event source", member.schemaName(), member.getSchemaPath()));
            }
        } else if (this.depth > 0) {
            foundLiveValue = eventSource.getParent();
            if (log) {
                JsonSchemaUtil.logger.finest(String.format("Json Schema [%s] SUBS: [%s] value is the event sources parent", member.schemaName(), member.getSchemaPath()));
            }
        }
        return foundLiveValue;
    }
}

