/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query.style;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryResultHolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BQueryResultWriter;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"jsonToolkit:JsonSchemaBoundQueryResult"})})
public class BRowArray
extends BQueryResultWriter {
    public static final Type TYPE = Sys.loadType(BRowArray.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BString previewText() {
        return BString.make((String)"[\n  [a1,b1,c1],\n  [a2,b2,c2],\n  [a3,b3,c3]\n]");
    }

    @Override
    public void appendJson(JSONWriter json, QueryResultHolder result) {
        json.array();
        try {
            if (this.includeHeader()) {
                this.writeHeaderArray(json, result);
            }
            result.getResultList().forEach(map -> {
                json.array();
                try {
                    map.forEach((key, value) -> json.value(JsonSchemaUtil.toJsonType(value, this.getSchema().getConfig())));
                }
                finally {
                    json.endArray();
                }
            });
            this.processChildJsonMembers(json, false);
        }
        finally {
            json.endArray();
        }
    }

    protected boolean includeHeader() {
        return false;
    }
}

