/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query.style;

import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryResultHolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BQueryResultWriter;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"jsonToolkit:JsonSchemaBoundQueryResult"})})
public class BObjectsArray
extends BQueryResultWriter {
    public static final Type TYPE = Sys.loadType(BObjectsArray.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BString previewText() {
        return BString.make((String)"[\n {\n  'a' : a1,\n  'b' : b1,\n  'c' : c1\n },\n {\n  'a' : a2,\n  'b' : b2,\n  'c' : c2\n }\n]");
    }

    @Override
    public void appendJson(JSONWriter json, QueryResultHolder result) {
        json.array();
        try {
            result.getResultList().forEach(map -> {
                json.object();
                try {
                    map.forEach((key, value) -> JsonSchemaNameUtil.writeKey(this.getBoundQueryResult(), json, key).value(JsonSchemaUtil.toJsonType(value, this.getSchema().getConfig())));
                }
                finally {
                    json.endObject();
                }
            });
            this.processChildJsonMembers(json, false);
        }
        finally {
            json.endArray();
        }
    }
}

